/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.SyncInfoReader;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTest;

public class ISynchronizerTest
extends ResourceTest {
    public static int NUMBER_OF_PARTNERS = 100;
    public IResource[] resources;

    public ISynchronizerTest() {
    }

    public ISynchronizerTest(String name) {
        super(name);
    }

    protected void assertEquals(String message, byte[] b1, byte[] b2) {
        ISynchronizerTest.assertTrue((String)message, (b1.length == b2.length ? 1 : 0) != 0);
        int i = 0;
        while (i < b1.length) {
            ISynchronizerTest.assertTrue((String)message, (b1[i] == b2[i] ? 1 : 0) != 0);
            ++i;
        }
    }

    @Override
    public String[] defineHierarchy() {
        return new String[]{"/", "1/", "1/1", "1/2/", "1/2/1", "1/2/2/", "2/", "2/1", "2/2/", "2/2/1", "2/2/2/"};
    }

    protected void flushAllSyncInfo(IResource root) throws CoreException {
        ISynchronizerTest.assertNotNull((Object)root);
        ISynchronizer synchronizer = ISynchronizerTest.getWorkspace().getSynchronizer();
        QualifiedName[] partners = synchronizer.getPartners();
        IWorkspaceRunnable body = monitor -> {
            IResourceVisitor visitor = resource -> {
                QualifiedName[] qualifiedNameArray2 = partners;
                int n = partners.length;
                int n2 = 0;
                while (n2 < n) {
                    QualifiedName partner = qualifiedNameArray2[n2];
                    synchronizer.setSyncInfo(partner, resource, null);
                    ++n2;
                }
                return true;
            };
            root.accept(visitor, 2, true);
        };
        ISynchronizerTest.getWorkspace().run(body, null);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.resources = this.createHierarchy();
    }

    public static Test suite() {
        return new TestSuite(ISynchronizerTest.class);
    }

    @Override
    public void tearDown() throws Exception {
        QualifiedName[] names;
        QualifiedName[] qualifiedNameArray = names = ISynchronizerTest.getWorkspace().getSynchronizer().getPartners();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            QualifiedName name = qualifiedNameArray[n2];
            ISynchronizerTest.getWorkspace().getSynchronizer().remove(name);
            ++n2;
        }
        super.tearDown();
    }

    public void testDeleteResources() {
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        synchronizer.add(qname);
        Hashtable table = new Hashtable(10);
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            byte[] b = this.getRandomString().getBytes();
            table.put(resource.getFullPath(), b);
            synchronizer.setSyncInfo(qname, resource, b);
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"0.0", (Throwable)e);
        }
        visitor = resource -> {
            byte[] actual;
            block3: {
                actual = synchronizer.getSyncInfo(qname, resource);
                if (resource.getType() != 8) break block3;
                ISynchronizerTest.assertNull((String)("1.0." + resource.getFullPath()), (Object)actual);
                return true;
            }
            try {
                ISynchronizerTest.assertNotNull((String)("1.1." + resource.getFullPath()), (Object)actual);
                byte[] expected = (byte[])table.get(resource.getFullPath());
                this.assertEquals("1.2." + resource.getFullPath(), expected, actual);
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)("1.3." + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"1.4", (Throwable)e);
        }
        IProject[] projects = ISynchronizerTest.getWorkspace().getRoot().getProjects();
        IWorkspaceRunnable body = monitor -> {
            IProject[] iProjectArray2 = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IResource[] children;
                IProject project = iProjectArray2[n2];
                IResource[] iResourceArray = children = project.members();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource element = iResourceArray[n4];
                    element.delete(false, this.getMonitor());
                    ++n4;
                }
                ++n2;
            }
        };
        try {
            ISynchronizerTest.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"2.99", (Throwable)e);
        }
        visitor = resource -> {
            byte[] actual;
            block3: {
                actual = synchronizer.getSyncInfo(qname, resource);
                if (resource.getType() != 8) break block3;
                ISynchronizerTest.assertNull((String)"3.0", (Object)actual);
                return true;
            }
            try {
                ISynchronizerTest.assertNotNull((String)("3.1." + resource.getFullPath()), (Object)actual);
                byte[] expected = (byte[])table.get(resource.getFullPath());
                this.assertEquals("3.2." + resource.getFullPath(), expected, actual);
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)("3.3." + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"3.4", (Throwable)e);
        }
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.delete(false, this.getMonitor());
            }
            catch (CoreException e) {
                ResourcesPlugin.getPlugin().getLog().log(e.getStatus());
                ISynchronizerTest.fail((String)"4.0", (Throwable)e);
            }
            ++n2;
        }
        visitor = resource -> {
            try {
                ISynchronizerTest.assertNull((String)("5.0." + resource.getFullPath()), (Object)synchronizer.getSyncInfo(qname, resource));
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)("5.1." + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"5.2", (Throwable)e);
        }
    }

    public void testDeleteResources2() {
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        synchronizer.add(qname);
        Hashtable table = new Hashtable(10);
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            byte[] b = this.getRandomString().getBytes();
            table.put(resource.getFullPath(), b);
            synchronizer.setSyncInfo(qname, resource, b);
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"0.0", (Throwable)e);
        }
        visitor = resource -> {
            byte[] actual;
            block3: {
                actual = synchronizer.getSyncInfo(qname, resource);
                if (resource.getType() != 8) break block3;
                ISynchronizerTest.assertNull((String)("1.0." + resource.getFullPath()), (Object)actual);
                return true;
            }
            try {
                ISynchronizerTest.assertNotNull((String)("1.1." + resource.getFullPath()), (Object)actual);
                byte[] expected = (byte[])table.get(resource.getFullPath());
                this.assertEquals("1.2." + resource.getFullPath(), expected, actual);
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)("1.3." + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"1.4", (Throwable)e);
        }
        IProject[] projects = ISynchronizerTest.getWorkspace().getRoot().getProjects();
        IWorkspaceRunnable body = monitor -> {
            IProject[] iProjectArray2 = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray2[n2];
                IResource[] children = project.members();
                int j = 0;
                while (j < children.length) {
                    if (!children[j].getName().equals(".project")) {
                        children[j].delete(false, this.getMonitor());
                    }
                    ++j;
                }
                ++n2;
            }
        };
        try {
            ISynchronizerTest.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"2.99", (Throwable)e);
        }
        visitor = resource -> {
            byte[] actual;
            block3: {
                actual = synchronizer.getSyncInfo(qname, resource);
                if (resource.getType() != 8) break block3;
                ISynchronizerTest.assertNull((String)"3.0", (Object)actual);
                return true;
            }
            try {
                ISynchronizerTest.assertNotNull((String)("3.1." + resource.getFullPath()), (Object)actual);
                byte[] expected = (byte[])table.get(resource.getFullPath());
                this.assertEquals("3.2." + resource.getFullPath(), expected, actual);
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)("3.3." + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"3.4", (Throwable)e);
        }
        body = monitor -> {
            IProject[] iProjectArray2 = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IResource[] children;
                IProject project = iProjectArray2[n2];
                IResource[] iResourceArray = children = project.members(true);
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource element = iResourceArray[n4];
                    synchronizer.setSyncInfo(qname, element, null);
                    ++n4;
                }
                ++n2;
            }
        };
        try {
            ISynchronizerTest.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"4.99", (Throwable)e);
        }
        visitor = resource -> {
            int type = resource.getType();
            if (type == 8 || type == 4) {
                return true;
            }
            if (type == 1 && resource.getParent().getType() == 4 && resource.getName().equals(".project")) {
                return true;
            }
            ISynchronizerTest.assertNull((String)("5.0." + resource.getFullPath()), (Object)synchronizer.getSyncInfo(qname, resource));
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor, 2, true);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"5.99", (Throwable)e);
        }
    }

    public void testMoveResource() {
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        try {
            ISynchronizerTest.getWorkspace().getRoot().delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"0.0", (Throwable)e);
        }
        IResource[] resources = this.buildResources((IContainer)ISynchronizerTest.getWorkspace().getRoot(), new String[]{"/Foo", "/Foo/file.txt"});
        IProject project = (IProject)resources[0];
        IFile source = (IFile)resources[1];
        this.ensureExistsInWorkspace(resources, true);
        synchronizer.add(qname);
        byte[] b = new byte[]{1, 2, 3, 4};
        try {
            synchronizer.setSyncInfo(qname, (IResource)source, b);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"2.0", (Throwable)e);
        }
        IFile destination = project.getFile("newFile.txt");
        try {
            source.move(destination.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            byte[] old = synchronizer.getSyncInfo(qname, (IResource)source);
            ISynchronizerTest.assertNotNull((String)"4.0", (Object)old);
            this.assertEquals("4.1", b, old);
            ISynchronizerTest.assertNull((String)"4.2", (Object)synchronizer.getSyncInfo(qname, (IResource)destination));
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"4.3", (Throwable)e);
        }
    }

    public void testMoveResource2() {
        byte[] old;
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        try {
            ISynchronizerTest.getWorkspace().getRoot().delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"0.0", (Throwable)e);
        }
        IResource[] toTest = this.buildResources((IContainer)ISynchronizerTest.getWorkspace().getRoot(), new String[]{"/Foo", "/Foo/file.txt"});
        IProject sourceProject = (IProject)toTest[0];
        IFile sourceFile = (IFile)toTest[1];
        this.ensureExistsInWorkspace(toTest, true);
        synchronizer.add(qname);
        byte[] b = new byte[]{1, 2, 3, 4};
        try {
            synchronizer.setSyncInfo(qname, (IResource)sourceProject, b);
            synchronizer.setSyncInfo(qname, (IResource)sourceFile, b);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"2.0", (Throwable)e);
        }
        IFile destFile = sourceProject.getFile("newFile.txt");
        try {
            sourceFile.move(destFile.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            old = synchronizer.getSyncInfo(qname, (IResource)sourceFile);
            ISynchronizerTest.assertNotNull((String)"4.0", (Object)old);
            this.assertEquals("4.1", b, old);
            ISynchronizerTest.assertNull((String)"4.2", (Object)synchronizer.getSyncInfo(qname, (IResource)destFile));
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"4.3", (Throwable)e);
        }
        try {
            destFile.move(sourceFile.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            old = synchronizer.getSyncInfo(qname, (IResource)sourceFile);
            ISynchronizerTest.assertNotNull((String)"6.0", (Object)old);
            this.assertEquals("6.1", b, old);
            ISynchronizerTest.assertNull((String)"6.2", (Object)synchronizer.getSyncInfo(qname, (IResource)destFile));
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"6.3", (Throwable)e);
        }
        IProject destProject = ISynchronizerTest.getWorkspace().getRoot().getProject("newProject");
        try {
            sourceProject.move(destProject.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"7.0", (Throwable)e);
        }
        try {
            ISynchronizerTest.assertNull((String)"7.1", (Object)synchronizer.getSyncInfo(qname, (IResource)sourceProject));
            ISynchronizerTest.assertNull((String)"7.2", (Object)synchronizer.getSyncInfo(qname, (IResource)sourceFile));
            byte[] old2 = synchronizer.getSyncInfo(qname, (IResource)destProject.getFile(sourceFile.getName()));
            ISynchronizerTest.assertNotNull((String)"7.3", (Object)old2);
            this.assertEquals("7.4", b, old2);
            old2 = synchronizer.getSyncInfo(qname, (IResource)destProject);
            ISynchronizerTest.assertNotNull((String)"7.5", (Object)old2);
            this.assertEquals("7.6", b, old2);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"7.3", (Throwable)e);
        }
    }

    public void testRegistration() {
        QualifiedName[] partners = new QualifiedName[NUMBER_OF_PARTNERS];
        int i = 0;
        while (i < NUMBER_OF_PARTNERS) {
            QualifiedName name;
            partners[i] = name = new QualifiedName("org.eclipse.core.deployment", "myTarget" + i);
            ++i;
        }
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        int i2 = 0;
        while (i2 < NUMBER_OF_PARTNERS) {
            synchronizer.add(partners[i2]);
            synchronizer.add(partners[i2]);
            ++i2;
        }
        QualifiedName[] list = synchronizer.getPartners();
        ISynchronizerTest.assertNotNull((String)"3.0", (Object)list);
        ISynchronizerTest.assertEquals((String)"3.1", (int)NUMBER_OF_PARTNERS, (int)list.length);
        int i3 = 0;
        while (i3 < NUMBER_OF_PARTNERS) {
            synchronizer.remove(partners[i3]);
            ++i3;
        }
        ISynchronizerTest.assertEquals((String)"4.0", (int)0, (int)synchronizer.getPartners().length);
    }

    public void testSave() {
        File file;
        IResourceVisitor visitor;
        Synchronizer synchronizer;
        QualifiedName qname;
        Hashtable table;
        block29: {
            table = new Hashtable(10);
            qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
            synchronizer = (Synchronizer)ResourcesPlugin.getWorkspace().getSynchronizer();
            synchronizer.add(qname);
            visitor = resource -> {
                if (resource.getType() == 8) {
                    return true;
                }
                try {
                    byte[] b = this.getRandomString().getBytes();
                    synchronizer.setSyncInfo(qname, resource, b);
                    table.put(resource.getFullPath(), b);
                }
                catch (CoreException e) {
                    ISynchronizerTest.fail((String)("0.0." + resource.getFullPath()), (Throwable)e);
                }
                return true;
            };
            try {
                ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)"0.1", (Throwable)e);
            }
            file = Platform.getLocation().append(".testsyncinfo").toFile();
            FileOutputStream fileOutput = null;
            DataOutputStream o1 = null;
            try {
                fileOutput = new FileOutputStream(file);
                o1 = new DataOutputStream(fileOutput);
            }
            catch (FileNotFoundException e) {
                ISynchronizerTest.fail((String)"1.0", (Throwable)e);
            }
            DataOutputStream output = o1;
            ArrayList list = new ArrayList(5);
            visitor = resource -> {
                ResourceInfo info;
                block3: {
                    info = ((Resource)resource).getResourceInfo(false, false);
                    if (info != null) break block3;
                    return true;
                }
                try {
                    IPathRequestor requestor = new IPathRequestor(){

                        public IPath requestPath() {
                            return resource.getFullPath();
                        }

                        public String requestName() {
                            return resource.getName();
                        }
                    };
                    synchronizer.saveSyncInfo(info, requestor, output, list);
                }
                catch (IOException e) {
                    ISynchronizerTest.fail((String)"1.1", (Throwable)e);
                }
                return true;
            };
            try {
                try {
                    ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
                }
                catch (CoreException e) {
                    ISynchronizerTest.fail((String)"1.2", (Throwable)e);
                    try {
                        output.close();
                    }
                    catch (IOException e2) {
                        ISynchronizerTest.fail((String)"1.3", (Throwable)e2);
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    ISynchronizerTest.fail((String)"1.3", (Throwable)e);
                }
                throw throwable;
            }
            try {
                output.close();
            }
            catch (IOException e) {
                ISynchronizerTest.fail((String)"1.3", (Throwable)e);
            }
        }
        try {
            this.flushAllSyncInfo((IResource)ISynchronizerTest.getWorkspace().getRoot());
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            FileInputStream fileInput = new FileInputStream(file);
            DataInputStream input = new DataInputStream(fileInput);
            IWorkspaceRunnable body = monitor -> {
                SyncInfoReader reader = new SyncInfoReader((Workspace)ISynchronizerTest.getWorkspace(), synchronizer);
                try {
                    reader.readSyncInfo(input);
                }
                catch (IOException e) {
                    ISynchronizerTest.fail((String)"3.0", (Throwable)e);
                }
            };
            try {
                ISynchronizerTest.getWorkspace().run(body, this.getMonitor());
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {
                    ISynchronizerTest.fail((String)"3.1", (Throwable)e);
                }
            }
        }
        catch (FileNotFoundException e) {
            ISynchronizerTest.fail((String)"3.2", (Throwable)e);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"3.3", (Throwable)e);
        }
        visitor = resource -> {
            byte[] actual = synchronizer.getSyncInfo(qname, resource);
            if (resource.getType() == 8) {
                ISynchronizerTest.assertNull((String)"4.0", (Object)actual);
                return true;
            }
            ISynchronizerTest.assertNotNull((String)("4.1." + resource.getFullPath()), (Object)actual);
            byte[] expected = (byte[])table.get(resource.getFullPath());
            this.assertEquals("4.2." + resource.getFullPath(), expected, actual);
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"4.3", (Throwable)e);
        }
    }

    public void testSnap() {
    }

    public void testSyncInfo() {
        QualifiedName qname = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        ISynchronizer synchronizer = ResourcesPlugin.getWorkspace().getSynchronizer();
        Hashtable table = new Hashtable(10);
        IResourceVisitor visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            byte[] b = this.getRandomString().getBytes();
            table.put(resource.getFullPath(), b);
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"0.0", (Throwable)e);
        }
        visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            try {
                synchronizer.setSyncInfo(qname, resource, (byte[])table.get(resource.getFullPath()));
                ISynchronizerTest.assertTrue((String)("1.0." + resource.getFullPath()), (boolean)false);
            }
            catch (CoreException coreException) {}
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"1.1", (Throwable)e);
        }
        visitor = resource -> {
            try {
                synchronizer.getSyncInfo(qname, resource);
                ISynchronizerTest.assertTrue((String)("2.0." + resource.getFullPath()), (boolean)false);
            }
            catch (CoreException coreException) {}
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"2.1", (Throwable)e);
        }
        synchronizer.add(qname);
        visitor = resource -> {
            try {
                byte[] actual = synchronizer.getSyncInfo(qname, resource);
                ISynchronizerTest.assertNull((String)("3.0." + resource.getFullPath()), (Object)actual);
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)("3.1." + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"3.2", (Throwable)e);
        }
        visitor = resource -> {
            try {
                synchronizer.setSyncInfo(qname, resource, (byte[])table.get(resource.getFullPath()));
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)("4.0." + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"4.1", (Throwable)e);
        }
        visitor = resource -> {
            byte[] actual;
            block3: {
                actual = synchronizer.getSyncInfo(qname, resource);
                if (resource.getType() != 8) break block3;
                ISynchronizerTest.assertNull((String)"5.0", (Object)actual);
                return true;
            }
            try {
                ISynchronizerTest.assertNotNull((String)("5.1." + resource.getFullPath()), (Object)actual);
                byte[] expected = (byte[])table.get(resource.getFullPath());
                this.assertEquals("5.2." + resource.getFullPath(), expected, actual);
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)("5.3." + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"5.4", (Throwable)e);
        }
        visitor = resource -> {
            if (resource.getType() == 8) {
                return true;
            }
            try {
                byte[] b = this.getRandomString().getBytes();
                synchronizer.setSyncInfo(qname, resource, b);
                table.put(resource.getFullPath(), b);
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)"6.0", (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"6.1", (Throwable)e);
        }
        visitor = resource -> {
            byte[] actual;
            block3: {
                actual = synchronizer.getSyncInfo(qname, resource);
                if (resource.getType() != 8) break block3;
                ISynchronizerTest.assertNull((String)"7.0", (Object)actual);
                return true;
            }
            try {
                ISynchronizerTest.assertNotNull((String)("7.1." + resource.getFullPath()), (Object)actual);
                byte[] expected = (byte[])table.get(resource.getFullPath());
                this.assertEquals("7.2." + resource.getFullPath(), expected, actual);
            }
            catch (CoreException e) {
                ISynchronizerTest.fail((String)("7.3." + resource.getFullPath()), (Throwable)e);
            }
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"7.4", (Throwable)e);
        }
        synchronizer.remove(qname);
        visitor = resource -> {
            try {
                synchronizer.getSyncInfo(qname, resource);
                ISynchronizerTest.assertTrue((String)("9.0." + resource.getFullPath()), (boolean)false);
            }
            catch (CoreException coreException) {}
            return true;
        };
        try {
            ISynchronizerTest.getWorkspace().getRoot().accept(visitor);
        }
        catch (CoreException e) {
            ISynchronizerTest.fail((String)"9.1", (Throwable)e);
        }
    }

    public void testPhantomRemoval() {
        QualifiedName partner = new QualifiedName("org.eclipse.core.tests.resources", "myTarget");
        IWorkspace workspace = ISynchronizerTest.getWorkspace();
        ISynchronizer synchronizer = workspace.getSynchronizer();
        synchronizer.add(partner);
        IProject project = workspace.getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("foo");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        this.ensureExistsInWorkspace(new IResource[]{file1, file2}, true);
        try {
            synchronizer.setSyncInfo(partner, (IResource)folder, this.getRandomString().getBytes());
            synchronizer.setSyncInfo(partner, (IResource)file1, this.getRandomString().getBytes());
            synchronizer.setSyncInfo(partner, (IResource)file2, this.getRandomString().getBytes());
        }
        catch (CoreException ce) {
            ISynchronizerTest.fail((String)"1.0", (Throwable)ce);
        }
        ISynchronizerTest.assertTrue((String)"1.1", (boolean)file1.exists());
        ISynchronizerTest.assertTrue((String)"1.2", (!file1.isPhantom() ? 1 : 0) != 0);
        try {
            file1.delete(true, this.getMonitor());
        }
        catch (CoreException ce) {
            ISynchronizerTest.fail((String)"2.0", (Throwable)ce);
        }
        ISynchronizerTest.assertTrue((String)"2.1", (!file1.exists() ? 1 : 0) != 0);
        ISynchronizerTest.assertTrue((String)"2.2", (boolean)file1.isPhantom());
        try {
            synchronizer.setSyncInfo(partner, (IResource)file1, null);
        }
        catch (CoreException ce) {
            ISynchronizerTest.fail((String)"3.0", (Throwable)ce);
        }
        ISynchronizerTest.assertTrue((String)"3.1", (!file1.exists() ? 1 : 0) != 0);
        ISynchronizerTest.assertTrue((String)"3.2", (!file1.isPhantom() ? 1 : 0) != 0);
        ISynchronizerTest.assertTrue((String)"4.1", (boolean)folder.exists());
        ISynchronizerTest.assertTrue((String)"4.2", (!folder.isPhantom() ? 1 : 0) != 0);
        ISynchronizerTest.assertTrue((String)"4.3", (boolean)file2.exists());
        ISynchronizerTest.assertTrue((String)"4.4", (!file2.isPhantom() ? 1 : 0) != 0);
        try {
            folder.delete(true, this.getMonitor());
        }
        catch (CoreException ce) {
            ISynchronizerTest.fail((String)"5.0", (Throwable)ce);
        }
        ISynchronizerTest.assertTrue((String)"5.1", (!folder.exists() ? 1 : 0) != 0);
        ISynchronizerTest.assertTrue((String)"5.2", (boolean)folder.isPhantom());
        ISynchronizerTest.assertTrue((String)"5.3", (!file2.exists() ? 1 : 0) != 0);
        ISynchronizerTest.assertTrue((String)"5.4", (boolean)file2.isPhantom());
        try {
            synchronizer.setSyncInfo(partner, (IResource)folder, null);
        }
        catch (CoreException ce) {
            ISynchronizerTest.fail((String)"6.0", (Throwable)ce);
        }
        ISynchronizerTest.assertTrue((String)"6.1", (!folder.exists() ? 1 : 0) != 0);
        ISynchronizerTest.assertTrue((String)"6.2", (!folder.isPhantom() ? 1 : 0) != 0);
        ISynchronizerTest.assertTrue((String)"6.3", (!file2.exists() ? 1 : 0) != 0);
        ISynchronizerTest.assertTrue((String)"6.4", (!file2.isPhantom() ? 1 : 0) != 0);
        synchronizer.remove(partner);
        this.ensureDoesNotExistInWorkspace((IResource)project);
    }
}

