/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileSystem;
import org.eclipse.core.tests.resources.ResourceTest;

public class IWorkspaceRootTest
extends ResourceTest {
    public IWorkspaceRootTest() {
    }

    public IWorkspaceRootTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(IWorkspaceRootTest.class);
    }

    @Override
    protected void tearDown() throws Exception {
        IProject[] projects = IWorkspaceRootTest.getWorkspace().getRoot().getProjects();
        IWorkspaceRootTest.getWorkspace().delete((IResource[])projects, true, null);
    }

    public void testFindFilesNonCanonicalPath() {
        if (!IWorkspaceRootTest.isWindows()) {
            return;
        }
        IProject project = IWorkspaceRootTest.getWorkspace().getRoot().getProject("testFindFilesNonCanonicalPath");
        this.ensureExistsInWorkspace((IResource)project, true);
        IFile link = project.getFile("file.txt");
        IFileStore fileStore = this.getTempStore();
        this.createFileInFileSystem(fileStore);
        IWorkspaceRootTest.assertEquals((String)"0.1", (String)"file", (String)fileStore.getFileSystem().getScheme());
        IPath fileLocationLower = URIUtil.toPath((URI)fileStore.toURI());
        fileLocationLower = fileLocationLower.setDevice(fileLocationLower.getDevice().toLowerCase());
        IPath fileLocationUpper = fileLocationLower.setDevice(fileLocationLower.getDevice().toUpperCase());
        try {
            link.createLink(fileLocationLower, 0, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.99", (Throwable)e);
        }
        IFile[] files = IWorkspaceRootTest.getWorkspace().getRoot().findFilesForLocation(fileLocationUpper);
        IWorkspaceRootTest.assertEquals((String)"1.0", (int)1, (int)files.length);
        IWorkspaceRootTest.assertEquals((String)"1.1", (Object)link, (Object)files[0]);
    }

    public void testFindContainersForLocation() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IProject p1 = root.getProject("p1");
        IProject p2 = root.getProject("p2");
        this.testFindContainersForLocation(p1, p2);
    }

    private void replaceProject(IProject project, URI newLocation) throws CoreException {
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setLocationURI(newLocation);
        project.move(projectDesc, 256, null);
    }

    public void testFindContainersForLocationOnWrappedFileSystem() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IProject p1 = root.getProject("p1");
        IProject p2 = root.getProject("p2");
        this.ensureExistsInWorkspace(new IResource[]{p1, p2}, true);
        try {
            this.replaceProject(p1, WrapperFileSystem.getWrappedURI(p1.getLocationURI()));
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"0.1", (Throwable)e);
        }
        try {
            this.replaceProject(p2, WrapperFileSystem.getWrappedURI(p2.getLocationURI()));
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"0.2", (Throwable)e);
        }
        this.testFindContainersForLocation(p1, p2);
    }

    public void testFindContainersForLocation(IProject p1, IProject p2) {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IContainer[] result = root.findContainersForLocation(root.getLocation());
        IWorkspaceRootTest.assertEquals((String)"1.0", (int)1, (int)result.length);
        IWorkspaceRootTest.assertEquals((String)"1.1", (Object)root, (Object)result[0]);
        IFolder parent = p2.getFolder("parent");
        IFolder link = parent.getFolder("link");
        this.ensureExistsInWorkspace(new IResource[]{p1, p2, parent}, true);
        try {
            link.createLink(p1.getLocationURI(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.99", (Throwable)e);
        }
        this.assertResources("2.0", (IResource)p1, (IResource)link, (IResource[])root.findContainersForLocation(p1.getLocation()));
        IFolder existing = p2.getFolder("existing");
        this.ensureExistsInWorkspace((IResource)existing, true);
        this.assertResources("3.0", (IResource)existing, (IResource[])root.findContainersForLocation(existing.getLocation()));
        this.assertResources("3.1", (IResource)existing, (IResource[])root.findContainersForLocationURI(existing.getLocationURI()));
        IFolder nonExisting = p2.getFolder("nonExisting");
        this.assertResources("3.2", (IResource)nonExisting, (IResource[])root.findContainersForLocation(nonExisting.getLocation()));
        this.assertResources("3.3", (IResource)nonExisting, (IResource[])root.findContainersForLocationURI(nonExisting.getLocationURI()));
        this.assertResources("3.4", (IResource)existing, (IResource[])root.findContainersForLocation(existing.getLocation().makeRelative()));
        this.assertResources("3.5", (IResource)nonExisting, (IResource[])root.findContainersForLocation(nonExisting.getLocation().makeRelative()));
        URI relative = null;
        try {
            relative = new URI(null, "hello", null);
        }
        catch (URISyntaxException e) {
            IWorkspaceRootTest.fail((String)"4.99", (Throwable)e);
        }
        try {
            root.findContainersForLocationURI(relative);
            IWorkspaceRootTest.fail((String)"4.1");
        }
        catch (RuntimeException runtimeException) {}
        IFolder otherLink = p1.getFolder("otherLink");
        IFileStore linkStore = this.getTempStore();
        URI location = linkStore.toURI();
        try {
            linkStore.mkdir(0, this.getMonitor());
            otherLink.createLink(location, 0, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"5.99", (Throwable)e);
        }
        result = root.findContainersForLocationURI(location);
        this.assertResources("5.1", (IResource)otherLink, (IResource[])result);
        IFolder child = otherLink.getFolder("link-child");
        URI childLocation = linkStore.getChild(child.getName()).toURI();
        result = root.findContainersForLocationURI(childLocation);
        this.assertResources("5.1", (IResource)child, (IResource[])result);
    }

    public void testFindFilesForLocationOnWrappedFileSystem() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IProject project = root.getProject("p1");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            this.replaceProject(project, WrapperFileSystem.getWrappedURI(project.getLocationURI()));
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"0.1", (Throwable)e);
        }
        this.testFindFilesForLocation(project);
    }

    public void testFindFilesForLocation() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        this.testFindFilesForLocation(root.getProject("p1"));
    }

    public void testFindFilesForLocation(IProject project) {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IFile[] result = root.findFilesForLocation(root.getLocation());
        IWorkspaceRootTest.assertEquals((String)"1.0", (int)0, (int)result.length);
        IFile existing = project.getFile("file1");
        this.ensureExistsInWorkspace((IResource)existing, true);
        IPath existingFileLocation = existing.getLocation();
        result = root.findFilesForLocation(existingFileLocation);
        this.assertResources("2.0", (IResource)existing, (IResource[])result);
        result = root.findFilesForLocationURI(existing.getLocationURI());
        this.assertResources("2.1", (IResource)existing, (IResource[])result);
        IFile nonExisting = project.getFile("nonExisting");
        result = root.findFilesForLocation(nonExisting.getLocation());
        this.assertResources("3.1", (IResource)nonExisting, (IResource[])result);
        result = root.findFilesForLocationURI(nonExisting.getLocationURI());
        this.assertResources("3.2", (IResource)nonExisting, (IResource[])result);
        result = root.findFilesForLocation(existingFileLocation.makeRelative());
        this.assertResources("4.0", (IResource)existing, (IResource[])result);
        result = root.findFilesForLocation(nonExisting.getLocation().makeRelative());
        this.assertResources("4.1", (IResource)nonExisting, (IResource[])result);
        if (!IWorkspaceRootTest.isCaseSensitive((IResource)existing)) {
            Path differentCase = new Path(existingFileLocation.toOSString().toUpperCase());
            result = root.findFilesForLocation((IPath)differentCase);
            this.assertResources("5.0", (IResource)existing, (IResource[])result);
            result = root.findFilesForLocationURI(existing.getLocationURI());
            this.assertResources("5.1", (IResource)existing, (IResource[])result);
        }
        IFolder link = project.getFolder("link");
        IFileStore linkStore = this.getTempStore();
        URI location = linkStore.toURI();
        try {
            linkStore.mkdir(0, this.getMonitor());
            link.createLink(location, 0, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"5.99", (Throwable)e);
        }
        IFile child = link.getFile("link-child.txt");
        URI childLocation = linkStore.getChild(child.getName()).toURI();
        result = root.findFilesForLocationURI(childLocation);
        this.assertResources("2.1", (IResource)child, (IResource[])result);
    }

    private void assertResources(String message, IResource expected, IResource[] actual) {
        IWorkspaceRootTest.assertEquals((String)message, (int)1, (int)actual.length);
        IWorkspaceRootTest.assertEquals((String)message, (Object)expected, (Object)actual[0]);
    }

    private void assertResources(String message, IResource expected0, IResource expected1, IResource[] actual) {
        IWorkspaceRootTest.assertEquals((String)message, (int)2, (int)actual.length);
        if (actual[0].equals((Object)expected0)) {
            IWorkspaceRootTest.assertEquals((String)message, (Object)expected1, (Object)actual[1]);
        } else if (actual[0].equals((Object)expected1)) {
            IWorkspaceRootTest.assertEquals((String)message, (Object)expected0, (Object)actual[1]);
        } else {
            IWorkspaceRootTest.assertEquals((String)message, (Object)expected0, (Object)actual[0]);
        }
    }

    public void testGetContainerForLocation() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IWorkspaceRootTest.assertEquals((String)"1.0", (Object)root, (Object)root.getContainerForLocation(root.getLocation()));
    }

    public void testGetFile() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IFile file = root.getFile((IPath)new Path("//P1/a.txt"));
        IWorkspaceRootTest.assertTrue((String)"1.0", (!file.getFullPath().isUNC() ? 1 : 0) != 0);
    }

    public void testGetFileForLocation() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IWorkspaceRootTest.assertTrue((String)"1.0", (root.getFileForLocation(root.getLocation()) == null ? 1 : 0) != 0);
    }

    public void testPersistentProperty() {
        String storedValue;
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("test", "testProperty");
        try {
            root.setPersistentProperty(name, value);
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            storedValue = root.getPersistentProperty(name);
            IWorkspaceRootTest.assertEquals((String)"2.0", (String)value, (String)storedValue);
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"2.1", (Throwable)e);
        }
        try {
            name = new QualifiedName("test", "testNonProperty");
            storedValue = root.getPersistentProperty(name);
            IWorkspaceRootTest.assertEquals((String)"3.0", null, (String)storedValue);
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"3.1", (Throwable)e);
        }
    }

    public void testPersistentPropertyInRunnable() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        QualifiedName name = new QualifiedName("test", "testProperty");
        try {
            IWorkspaceRootTest.getWorkspace().run(monitor -> root.setPersistentProperty(name, "this is a test property value"), this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            String[] storedValue = new String[1];
            IWorkspaceRootTest.getWorkspace().run(monitor -> {
                String string = root.getPersistentProperty(name);
            }, this.getMonitor());
            IWorkspaceRootTest.assertEquals((String)"2.0", (String)"this is a test property value", (String)storedValue[0]);
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"2.1", (Throwable)e);
        }
        try {
            QualifiedName name2 = new QualifiedName("test", "testNonProperty");
            String[] storedValue = new String[1];
            IWorkspaceRootTest.getWorkspace().run(monitor -> {
                String string = root.getPersistentProperty(name2);
            }, this.getMonitor());
            IWorkspaceRootTest.assertEquals((String)"3.0", null, (String)storedValue[0]);
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"3.1", (Throwable)e);
        }
    }

    public void testRefreshLocal() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IProject project = root.getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            root.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.1", (Throwable)e);
        }
    }

    public void testBug234343_folderInHiddenProject() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IProject hiddenProject = root.getProject(this.getUniqueString());
        this.ensureDoesNotExistInWorkspace((IResource)hiddenProject);
        try {
            hiddenProject.create(null, 4096, this.getMonitor());
            hiddenProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.0", (Throwable)e);
        }
        IFolder folder = hiddenProject.getFolder("foo");
        try {
            folder.create(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"4.99", (Throwable)e);
        }
        IContainer[] containers = root.findContainersForLocationURI(folder.getLocationURI());
        IWorkspaceRootTest.assertEquals((String)"2.0", (int)0, (int)containers.length);
        containers = root.findContainersForLocationURI(folder.getLocationURI(), 8);
        IWorkspaceRootTest.assertEquals((String)"3.0", (int)1, (int)containers.length);
    }

    public void testBug234343_fileInHiddenProject() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IProject hiddenProject = root.getProject(this.getUniqueString());
        this.ensureDoesNotExistInWorkspace((IResource)hiddenProject);
        try {
            hiddenProject.create(null, 4096, this.getMonitor());
            hiddenProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.0", (Throwable)e);
        }
        IFile file = hiddenProject.getFile("foo");
        try {
            file.create((InputStream)new ByteArrayInputStream("foo".getBytes()), true, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"2.0", (Throwable)e);
        }
        IFile[] files = root.findFilesForLocationURI(file.getLocationURI());
        IWorkspaceRootTest.assertEquals((String)"3.0", (int)0, (int)files.length);
        files = root.findFilesForLocationURI(file.getLocationURI(), 8);
        IWorkspaceRootTest.assertEquals((String)"4.0", (int)1, (int)files.length);
        IContainer[] containers = root.findContainersForLocationURI(file.getLocationURI());
        IWorkspaceRootTest.assertEquals((String)"5.0", (int)0, (int)containers.length);
        containers = root.findContainersForLocationURI(file.getLocationURI(), 8);
        IWorkspaceRootTest.assertEquals((String)"6.0", (int)1, (int)containers.length);
    }

    public void testBug476585() {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IProject project = root.getProject("a");
        this.ensureExistsInWorkspace((IResource)project, true);
        String subProjectName = "subProject";
        IPath subProjectLocation = project.getLocation().append(subProjectName);
        IPath fileLocation = subProjectLocation.append("file.txt");
        IFile file = root.getFileForLocation(fileLocation);
        IWorkspaceRootTest.assertEquals((String)"1.0", (Object)project, (Object)file.getProject());
        IPath containerLocation = subProjectLocation.append("folder");
        IContainer container = root.getContainerForLocation(containerLocation);
        IWorkspaceRootTest.assertEquals((String)"1.1", (Object)project, (Object)container.getProject());
        IProject subProject = root.getProject(subProjectName);
        IProjectDescription newProjectDescription = IWorkspaceRootTest.getWorkspace().newProjectDescription(subProjectName);
        newProjectDescription.setLocation(subProjectLocation);
        try {
            subProject.create(newProjectDescription, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.99", (Throwable)e);
        }
        file = root.getFileForLocation(fileLocation);
        IWorkspaceRootTest.assertNotNull((String)"2.0", (Object)file);
        IWorkspaceRootTest.assertEquals((String)"2.1", (Object)subProject, (Object)file.getProject());
        container = root.getContainerForLocation(containerLocation);
        IWorkspaceRootTest.assertNotNull((String)"2.2", (Object)container);
        IWorkspaceRootTest.assertEquals((String)"2.3", (Object)subProject, (Object)container.getProject());
    }

    public void testFindMethodsWithHiddenAndTeamPrivateFlags() {
        int[][] nArrayArray = new int[4][];
        int[] nArray = new int[16];
        nArray[6] = 1;
        nArray[7] = 1;
        nArray[8] = 1;
        nArray[9] = 1;
        nArray[10] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[16];
        nArray2[0] = 8;
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 1;
        nArray2[9] = 1;
        nArray2[10] = 1;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray3 = new int[16];
        nArray3[0] = 2;
        nArray3[6] = 1;
        nArray3[7] = 1;
        nArray3[8] = 1;
        nArray3[9] = 1;
        nArray3[10] = 1;
        nArray3[11] = 1;
        nArray3[12] = 1;
        nArray3[13] = 1;
        nArray3[14] = 1;
        nArray3[15] = 1;
        nArrayArray[3] = nArray3;
        this.checkFindMethods(0, nArrayArray);
        int[][] nArrayArray2 = new int[4][];
        int[] nArray4 = new int[16];
        nArray4[6] = 1;
        nArrayArray2[0] = nArray4;
        int[] nArray5 = new int[16];
        nArray5[0] = 8;
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArray5[5] = 1;
        nArray5[6] = 1;
        nArray5[7] = 1;
        nArray5[8] = 1;
        nArray5[9] = 1;
        nArray5[10] = 1;
        nArrayArray2[1] = nArray5;
        nArrayArray2[2] = new int[]{10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray6 = new int[16];
        nArray6[0] = 2;
        nArray6[6] = 1;
        nArray6[11] = 1;
        nArrayArray2[3] = nArray6;
        this.checkFindMethods(4096, nArrayArray2);
        int[][] nArrayArray3 = new int[4][];
        int[] nArray7 = new int[16];
        nArray7[6] = 1;
        nArrayArray3[0] = nArray7;
        int[] nArray8 = new int[16];
        nArray8[0] = 8;
        nArray8[1] = 1;
        nArray8[6] = 1;
        nArrayArray3[1] = nArray8;
        nArrayArray3[2] = new int[]{10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray9 = new int[16];
        nArray9[0] = 2;
        nArray9[6] = 1;
        nArray9[7] = 1;
        nArray9[8] = 1;
        nArray9[9] = 1;
        nArray9[10] = 1;
        nArray9[11] = 1;
        nArray9[12] = 1;
        nArray9[13] = 1;
        nArray9[14] = 1;
        nArray9[15] = 1;
        nArrayArray3[3] = nArray9;
        this.checkFindMethods(2048, nArrayArray3);
        int[][] nArrayArray4 = new int[4][];
        int[] nArray10 = new int[16];
        nArray10[6] = 1;
        nArrayArray4[0] = nArray10;
        int[] nArray11 = new int[16];
        nArray11[0] = 8;
        nArray11[1] = 1;
        nArray11[6] = 1;
        nArrayArray4[1] = nArray11;
        nArrayArray4[2] = new int[]{10, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        int[] nArray12 = new int[16];
        nArray12[0] = 2;
        nArray12[6] = 1;
        nArray12[11] = 1;
        nArrayArray4[3] = nArray12;
        this.checkFindMethods(6144, nArrayArray4);
    }

    public void checkFindMethods(int updateFlags, int[][] results) {
        IWorkspaceRoot root = IWorkspaceRootTest.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        this.ensureDoesNotExistInWorkspace((IResource)project);
        try {
            project.create(null, 0, this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"1.0", (Throwable)e);
        }
        IFolder teamFolder = this.createFolder((IContainer)project, 2048, false);
        IFile mFileInTeamFolder = this.createFile((IContainer)teamFolder, updateFlags, false);
        IFile mLinkedFileInTeamFolder = this.createFile((IContainer)teamFolder, updateFlags, true);
        IFolder mFolderInTeamFolder = this.createFolder((IContainer)teamFolder, updateFlags, false);
        IFolder mLinkedFolderInTeamFolder = this.createFolder((IContainer)teamFolder, updateFlags, true);
        IFolder hiddenFolder = this.createFolder((IContainer)project, 4096, false);
        IFile mFileInHiddenFolder = this.createFile((IContainer)hiddenFolder, updateFlags, false);
        IFile mLinkedFileInHiddenFolder = this.createFile((IContainer)hiddenFolder, updateFlags, true);
        IFolder mFolderInHiddenFolder = this.createFolder((IContainer)hiddenFolder, updateFlags, false);
        IFolder mLinkedFolderInHiddenFolder = this.createFolder((IContainer)hiddenFolder, updateFlags, true);
        IFolder folder = this.createFolder((IContainer)project, 0, false);
        IFile mFileInFolder = this.createFile((IContainer)folder, updateFlags, false);
        IFile mLinkedFileInFolder = this.createFile((IContainer)folder, updateFlags, true);
        IFolder mFolderInFolder = this.createFolder((IContainer)folder, updateFlags, false);
        IFolder mLinkedFolderInFolder = this.createFolder((IContainer)folder, updateFlags, true);
        int[][] nArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            int[] result = nArray[n2];
            this.checkFindContainers(hiddenFolder.getLocationURI(), result[0], result[1]);
            this.checkFindFiles(mFileInHiddenFolder.getLocationURI(), result[0], result[4]);
            this.checkFindFiles(mLinkedFileInHiddenFolder.getLocationURI(), result[0], result[5]);
            this.checkFindContainers(mFolderInHiddenFolder.getLocationURI(), result[0], result[2]);
            this.checkFindContainers(mLinkedFolderInHiddenFolder.getLocationURI(), result[0], result[3]);
            this.checkFindContainers(folder.getLocationURI(), result[0], result[6]);
            this.checkFindFiles(mFileInFolder.getLocationURI(), result[0], result[7]);
            this.checkFindFiles(mLinkedFileInFolder.getLocationURI(), result[0], result[8]);
            this.checkFindContainers(mFolderInFolder.getLocationURI(), result[0], result[9]);
            this.checkFindContainers(mLinkedFolderInFolder.getLocationURI(), result[0], result[10]);
            this.checkFindContainers(teamFolder.getLocationURI(), result[0], result[11]);
            this.checkFindFiles(mFileInTeamFolder.getLocationURI(), result[0], result[12]);
            this.checkFindFiles(mLinkedFileInTeamFolder.getLocationURI(), result[0], result[13]);
            this.checkFindContainers(mFolderInTeamFolder.getLocationURI(), result[0], result[14]);
            this.checkFindContainers(mLinkedFolderInTeamFolder.getLocationURI(), result[0], result[15]);
            ++n2;
        }
    }

    private void checkFindFiles(URI location, int memberFlags, int foundResources) {
        IFile[] files = IWorkspaceRootTest.getWorkspace().getRoot().findFilesForLocationURI(location, memberFlags);
        IWorkspaceRootTest.assertEquals((int)foundResources, (int)files.length);
    }

    private void checkFindContainers(URI location, int memberFlags, int foundResources) {
        IContainer[] containers = IWorkspaceRootTest.getWorkspace().getRoot().findContainersForLocationURI(location, memberFlags);
        IWorkspaceRootTest.assertEquals((int)foundResources, (int)containers.length);
    }

    private IFile createFile(IContainer parent, int updateFlags, boolean linked) {
        IFile file;
        block6: {
            file = parent.getFile((IPath)new Path(this.getUniqueString()));
            try {
                if (linked) {
                    try {
                        IPath path = this.getTempDir().append(this.getUniqueString());
                        path.toFile().createNewFile();
                        file.createLink(URIUtil.toURI((IPath)path), updateFlags, this.getMonitor());
                        if ((updateFlags & 0x800) == 2048) {
                            file.setTeamPrivateMember(true);
                        }
                        break block6;
                    }
                    catch (IOException e) {
                        IWorkspaceRootTest.fail((String)"Can't create the file", (Throwable)e);
                    }
                    break block6;
                }
                file.create((InputStream)new ByteArrayInputStream("content".getBytes()), updateFlags, this.getMonitor());
            }
            catch (CoreException e) {
                IWorkspaceRootTest.fail((String)"Can't create the file", (Throwable)e);
            }
        }
        return file;
    }

    private IFolder createFolder(IContainer parent, int updateFlags, boolean linked) {
        IFolder folder = parent.getFolder((IPath)new Path(this.getUniqueString()));
        try {
            if (linked) {
                IPath path = this.getTempDir().append(this.getUniqueString());
                path.toFile().mkdir();
                folder.createLink(URIUtil.toURI((IPath)path), updateFlags, this.getMonitor());
                if ((updateFlags & 0x800) == 2048) {
                    folder.setTeamPrivateMember(true);
                }
            } else {
                folder.create(updateFlags, true, this.getMonitor());
            }
        }
        catch (CoreException e) {
            IWorkspaceRootTest.fail((String)"Can't create the folder", (Throwable)e);
        }
        return folder;
    }
}

