/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.filesystem.ram.MemoryTree;
import org.eclipse.core.tests.resources.ResourceTest;

public class NonLocalLinkedResourceTest
extends ResourceTest {
    private int nextFolder = 0;

    public static Test suite() {
        return new TestSuite(NonLocalLinkedResourceTest.class);
    }

    public NonLocalLinkedResourceTest() {
    }

    public NonLocalLinkedResourceTest(String name) {
        super(name);
    }

    protected IFileStore createFolderStore(String name) {
        IFileSystem system = this.getFileSystem();
        IFileStore store = system.getStore(Path.ROOT.append(name));
        try {
            store.mkdir(0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"createFolderStore", (Throwable)e);
        }
        return store;
    }

    protected IFileSystem getFileSystem() {
        try {
            return EFS.getFileSystem((String)"mem");
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"Test file system missing", (Throwable)e);
            return null;
        }
    }

    @Override
    protected IFileStore getTempStore() {
        IFileStore store;
        IFileSystem system = this.getFileSystem();
        while ((store = system.getStore(Path.ROOT.append(Integer.toString(this.nextFolder++)))).fetchInfo().exists()) {
        }
        return store;
    }

    @Override
    protected void tearDown() throws Exception {
        MemoryTree.TREE.deleteAll();
        super.tearDown();
    }

    public void testCopyFile() {
        IFileStore sourceStore = this.createFolderStore("source");
        IFileStore destinationStore = this.createFolderStore("destination");
        IProject project = NonLocalLinkedResourceTest.getWorkspace().getRoot().getProject("project");
        IFolder source = project.getFolder("source");
        IFolder destination = project.getFolder("destination");
        IFile sourceFile = source.getFile("file.txt");
        IFile destinationFile = destination.getFile(sourceFile.getName());
        IFile localFile = project.getFile(sourceFile.getName());
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            source.createLink(sourceStore.toURI(), 0, this.getMonitor());
            destination.createLink(destinationStore.toURI(), 0, this.getMonitor());
            sourceFile.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"0.99", (Throwable)e);
        }
        try {
            sourceFile.copy(destinationFile.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            sourceFile.copy(localFile.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"2.0", (Throwable)e);
        }
        this.ensureDoesNotExistInWorkspace((IResource)destinationFile);
        try {
            localFile.copy(destinationFile.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            localFile.copy(localFile.getFullPath(), 0, this.getMonitor());
            NonLocalLinkedResourceTest.fail((String)"4.0");
        }
        catch (CoreException coreException) {}
    }

    public void testCopyFolder() {
        IFileStore sourceStore = this.createFolderStore("source");
        IProject project = NonLocalLinkedResourceTest.getWorkspace().getRoot().getProject("project");
        IFolder parentFolder = project.getFolder("parent");
        IFolder source = parentFolder.getFolder("source");
        IFolder destination = project.getFolder("destination");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            parentFolder.create(0, true, this.getMonitor());
            source.createLink(sourceStore.toURI(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"0.99", (Throwable)e);
        }
        try {
            source.copy(destination.getFullPath(), 32, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"1.0", (Throwable)e);
        }
        NonLocalLinkedResourceTest.assertTrue((String)"1.1", (boolean)destination.exists());
        try {
            destination.delete(0, this.getMonitor());
            source.copy(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"2.0", (Throwable)e);
        }
        NonLocalLinkedResourceTest.assertTrue((String)"2.1", (boolean)destination.exists());
        try {
            source.copy(destination.getFullPath(), 0, this.getMonitor());
            NonLocalLinkedResourceTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
        try {
            source.copy(source.getFullPath(), 0, this.getMonitor());
            NonLocalLinkedResourceTest.fail((String)"4.0");
        }
        catch (CoreException coreException) {}
    }

    public void testMoveFile() {
        IFileStore sourceStore = this.createFolderStore("source");
        IFileStore destinationStore = this.createFolderStore("destination");
        IProject project = NonLocalLinkedResourceTest.getWorkspace().getRoot().getProject("project");
        IFolder source = project.getFolder("source");
        IFolder destination = project.getFolder("destination");
        IFile sourceFile = source.getFile("file.txt");
        IFile destinationFile = destination.getFile(sourceFile.getName());
        IFile localFile = project.getFile(sourceFile.getName());
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            source.createLink(sourceStore.toURI(), 0, this.getMonitor());
            destination.createLink(destinationStore.toURI(), 0, this.getMonitor());
            sourceFile.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"0.99", (Throwable)e);
        }
        try {
            sourceFile.move(destinationFile.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            destinationFile.move(sourceFile.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            sourceFile.move(localFile.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            localFile.move(destinationFile.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            localFile.copy(localFile.getFullPath(), 0, this.getMonitor());
            NonLocalLinkedResourceTest.fail((String)"4.0");
        }
        catch (CoreException coreException) {}
    }

    public void test342060() {
        IFileStore sourceStore = this.createBogusFolderStore("source");
        IFileStore destinationStore = this.createBogusFolderStore("destination");
        IProject project = NonLocalLinkedResourceTest.getWorkspace().getRoot().getProject("project");
        IFolder source = project.getFolder("source");
        IFolder destination = project.getFolder("destination");
        IFile sourceFile = source.getFile("file.txt");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            source.createLink(sourceStore.toURI(), 0, this.getMonitor());
            destination.createLink(destinationStore.toURI(), 0, this.getMonitor());
            sourceFile.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"0.99", (Throwable)e);
        }
        try {
            project.move(Path.fromPortableString((String)"movedProject"), 0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"1.0", (Throwable)e);
        }
    }

    protected IFileStore createBogusFolderStore(String name) {
        IFileSystem system = this.getBogusFileSystem();
        IFileStore store = system.getStore(Path.ROOT.append(name));
        try {
            store.mkdir(0, this.getMonitor());
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"createFolderStore", (Throwable)e);
        }
        return store;
    }

    protected IFileSystem getBogusFileSystem() {
        try {
            return EFS.getFileSystem((String)"bogus");
        }
        catch (CoreException e) {
            NonLocalLinkedResourceTest.fail((String)"Test file system missing", (Throwable)e);
            return null;
        }
    }
}

