/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.InputStream;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;
import org.eclipse.core.tests.resources.ResourceTest;

public class ProjectSnapshotTest
extends ResourceTest {
    private static final String REFRESH_SNAPSHOT_FILE_LOCATION = "resource-index.zip";
    protected IProject[] projects = new IProject[2];

    public ProjectSnapshotTest() {
    }

    public ProjectSnapshotTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ProjectSnapshotTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.projects[0] = ProjectSnapshotTest.getWorkspace().getRoot().getProject("p1");
        this.projects[1] = ProjectSnapshotTest.getWorkspace().getRoot().getProject("p2");
        this.ensureExistsInWorkspace((IResource[])this.projects, true);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void populateProject(IProject project) {
        IFile file = project.getFile("file");
        this.ensureExistsInFileSystem(file);
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        this.ensureExistsInFileSystem((IResource)folder);
        this.ensureExistsInFileSystem((IResource)subfolder);
        this.ensureExistsInFileSystem(subfile);
    }

    private URI getSnapshotLocation(IProject project) {
        IPath projPath = project.getLocation();
        projPath = projPath.append(REFRESH_SNAPSHOT_FILE_LOCATION);
        return URIUtil.toURI((IPath)projPath);
    }

    public void testSaveNullSnapshot() throws Throwable {
        boolean exceptionThrown = false;
        try {
            this.projects[0].saveSnapshot(1, null, null);
        }
        catch (CoreException coreException) {
            exceptionThrown = true;
        }
        ProjectSnapshotTest.assertTrue((String)"1.0", (boolean)exceptionThrown);
    }

    public void testLoadNoRefresh() throws Throwable {
        IProject project = this.projects[0];
        this.populateProject(project);
        project.refreshLocal(2, null);
        URI snapshotLocation = this.getSnapshotLocation(this.projects[1]);
        project.saveSnapshot(1, snapshotLocation, null);
        project.close(null);
        project.delete(true, false, null);
        project.create(null);
        project.loadSnapshot(1, snapshotLocation, null);
        project.open(0, null);
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        ProjectSnapshotTest.assertTrue((String)"1.1", (boolean)file.exists());
        ProjectSnapshotTest.assertTrue((String)"1.2", (boolean)folder.exists());
        ProjectSnapshotTest.assertTrue((String)"1.3", (boolean)subfolder.exists());
        ProjectSnapshotTest.assertTrue((String)"1.4", (boolean)subfile.exists());
    }

    public void testLoadWithRefresh() throws Throwable {
        IProject project = this.projects[0];
        this.populateProject(project);
        project.refreshLocal(2, null);
        URI snapshotLocation = this.getSnapshotLocation(this.projects[1]);
        project.saveSnapshot(1, snapshotLocation, null);
        project.close(null);
        project.delete(true, false, null);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException interruptedException) {
            ProjectSnapshotTest.fail((String)"0.0");
        }
        project.create(null);
        project.loadSnapshot(1, snapshotLocation, null);
        project.open(0, null);
        ResourceDeltaVerifier verifier = new ResourceDeltaVerifier();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)verifier);
        verifier.reset();
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        verifier.addExpectedChange((IResource)file, 2, 0);
        verifier.addExpectedChange((IResource)folder, 2, 0);
        verifier.addExpectedChange((IResource)subfolder, 2, 0);
        verifier.addExpectedChange((IResource)subfile, 2, 0);
        verifier.addExpectedChange((IResource)project, 4, 524288);
        IFile dotProject = project.getFile(".project");
        verifier.addExpectedChange((IResource)dotProject, 4, 256);
        project.refreshLocal(2, null);
        verifier.verifyDelta(null);
        ProjectSnapshotTest.assertTrue((String)("1.0 " + verifier.getMessage()), (boolean)verifier.isDeltaValid());
        ProjectSnapshotTest.assertTrue((String)"1.1", (!file.exists() ? 1 : 0) != 0);
        ProjectSnapshotTest.assertTrue((String)"1.2", (!folder.exists() ? 1 : 0) != 0);
        ProjectSnapshotTest.assertTrue((String)"1.3", (!subfolder.exists() ? 1 : 0) != 0);
        ProjectSnapshotTest.assertTrue((String)"1.4", (!subfile.exists() ? 1 : 0) != 0);
    }

    public void testLoadWithRename() throws Throwable {
        IProject project = this.projects[0];
        this.populateProject(project);
        project.refreshLocal(2, null);
        URI snapshotLocation = this.getSnapshotLocation(this.projects[1]);
        project.saveSnapshot(1, snapshotLocation, null);
        project.close(null);
        project.delete(true, false, null);
        project = ProjectSnapshotTest.getWorkspace().getRoot().getProject("p3");
        project.create(null);
        project.loadSnapshot(1, snapshotLocation, null);
        project.open(0, null);
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        ProjectSnapshotTest.assertTrue((String)"1.1", (boolean)file.exists());
        ProjectSnapshotTest.assertTrue((String)"1.2", (boolean)folder.exists());
        ProjectSnapshotTest.assertTrue((String)"1.3", (boolean)subfolder.exists());
        ProjectSnapshotTest.assertTrue((String)"1.4", (boolean)subfile.exists());
    }

    public void testLoadWithRename2() throws Throwable {
        IProject project = this.projects[0];
        this.populateProject(project);
        project.refreshLocal(2, null);
        project.move(Path.ROOT.append("p0"), true, null);
        project = ProjectSnapshotTest.getWorkspace().getRoot().getProject("p0");
        IFile file2 = project.getFile("file2");
        this.ensureExistsInFileSystem(file2);
        project.getFile("file3");
        URI snapshotLocation = this.getSnapshotLocation(this.projects[1]);
        project.saveSnapshot(1, snapshotLocation, null);
        project.close(null);
        project.delete(true, false, null);
        project = ProjectSnapshotTest.getWorkspace().getRoot().getProject("p3");
        project.create(null);
        project.loadSnapshot(1, snapshotLocation, null);
        project.open(0, null);
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        ProjectSnapshotTest.assertTrue((String)"1.1", (boolean)file.exists());
        ProjectSnapshotTest.assertTrue((String)"1.2", (boolean)folder.exists());
        ProjectSnapshotTest.assertTrue((String)"1.3", (boolean)subfolder.exists());
        ProjectSnapshotTest.assertTrue((String)"1.4", (boolean)subfile.exists());
    }

    public void testAutoLoadInvalidURI() throws Throwable {
        IProject project = ProjectSnapshotTest.getWorkspace().getRoot().getProject("project");
        IProjectDescription description = ProjectSnapshotTest.getWorkspace().newProjectDescription(project.getName());
        ((ProjectDescription)description).setSnapshotLocationURI(URI.create("./relative/uri.zip"));
        project.create(description, null);
        this.ensureExistsInFileSystem((IResource)project.getFolder("foo"));
        ProjectSnapshotTest.assertFalse((String)"1.0", (boolean)project.getFolder("foo").exists());
        project.open(null);
        ProjectSnapshotTest.assertTrue((String)"1.1", (boolean)project.isOpen());
        ProjectSnapshotTest.assertTrue((String)"1.2", (boolean)project.getFolder("foo").exists());
        boolean errorReported = false;
        try {
            project.saveSnapshot(2, URI.create("NON_EXISTING/foo/bar.zip"), null);
        }
        catch (CoreException coreException) {
            errorReported = true;
        }
        ProjectSnapshotTest.assertTrue((String)"1.4", (boolean)errorReported);
    }

    public void testAutoLoadMissingSnapshot() throws Throwable {
        IProject project = ProjectSnapshotTest.getWorkspace().getRoot().getProject("project");
        IProjectDescription description = ProjectSnapshotTest.getWorkspace().newProjectDescription(project.getName());
        ((ProjectDescription)description).setSnapshotLocationURI(this.getTempStore().toURI());
        project.create(description, null);
        this.ensureExistsInFileSystem(project.getFile("foo"));
        ProjectSnapshotTest.assertFalse((String)"1.0", (boolean)project.getFile("foo").exists());
        project.open(null);
        ProjectSnapshotTest.assertTrue((String)"1.1", (boolean)project.isOpen());
        ProjectSnapshotTest.assertTrue((String)"1.2", (boolean)project.getFile("foo").exists());
    }

    public void testAutoLoadWithRename() throws Throwable {
        IFileStore tempStore = this.getTempStore();
        tempStore.mkdir(0, null);
        IProject project = ProjectSnapshotTest.getWorkspace().getRoot().getProject("project");
        IProjectDescription description = ProjectSnapshotTest.getWorkspace().newProjectDescription(project.getName());
        description.setLocationURI(tempStore.getChild("project").toURI());
        project.create(description, null);
        project.open(null);
        this.populateProject(project);
        project.refreshLocal(2, null);
        URI snapshotLocation = tempStore.getChild("project-index.zip").toURI();
        snapshotLocation = project.getPathVariableManager().convertToRelative(snapshotLocation, true, null);
        project.saveSnapshot(3, snapshotLocation, null);
        IFileStore newProjectStore = tempStore.getChild("pnew");
        newProjectStore.mkdir(0, null);
        EFS.getStore((URI)project.getLocationURI()).getChild(".project").copy(newProjectStore.getChild(".project"), 0, null);
        project.close(null);
        project.delete(true, false, null);
        InputStream is = newProjectStore.getChild(".project").openInputStream(0, null);
        description = ProjectSnapshotTest.getWorkspace().loadProjectDescription(is);
        is.close();
        description.setLocationURI(newProjectStore.toURI());
        project = ProjectSnapshotTest.getWorkspace().getRoot().getProject(String.valueOf(description.getName()) + "-mybranch");
        project.create(description, null);
        project.open(0, null);
        IFile file = project.getFile("file");
        IFolder folder = project.getFolder("folder");
        IFolder subfolder = folder.getFolder("subfolder");
        IFile subfile = folder.getFile("subfile");
        ProjectSnapshotTest.assertTrue((String)"1.1", (boolean)file.exists());
        ProjectSnapshotTest.assertTrue((String)"1.2", (boolean)folder.exists());
        ProjectSnapshotTest.assertTrue((String)"1.3", (boolean)subfolder.exists());
        ProjectSnapshotTest.assertTrue((String)"1.4", (boolean)subfile.exists());
    }

    public void testResetAutoLoadSnapshot() throws Throwable {
        IProject project = this.projects[0];
        URI tempURI = this.getTempStore().toURI();
        IFile projectFile = project.getFile(".project");
        long stamp = projectFile.getModificationStamp();
        ProjectDescription desc = (ProjectDescription)project.getDescription();
        desc.setSnapshotLocationURI(null);
        project.setDescription((IProjectDescription)desc, null);
        ProjectSnapshotTest.assertEquals((String)"1.0", (long)stamp, (long)projectFile.getModificationStamp());
        project.saveSnapshot(2, tempURI, null);
        ProjectSnapshotTest.assertEquals((String)"2.0", (Object)tempURI, (Object)((ProjectDescription)project.getDescription()).getSnapshotLocationURI());
        long stamp2 = projectFile.getModificationStamp();
        ProjectSnapshotTest.assertFalse((String)"2.1", (stamp == stamp2 ? 1 : 0) != 0);
        project.saveSnapshot(2, tempURI, null);
        ProjectSnapshotTest.assertEquals((String)"2.2", (long)stamp2, (long)projectFile.getModificationStamp());
        desc = (ProjectDescription)project.getDescription();
        desc.setSnapshotLocationURI(null);
        project.setDescription((IProjectDescription)desc, null);
        ProjectSnapshotTest.assertNull((String)"3.0", (Object)((ProjectDescription)project.getDescription()).getSnapshotLocationURI());
        ProjectSnapshotTest.assertFalse((String)"3.1", (stamp2 == projectFile.getModificationStamp() ? 1 : 0) != 0);
        project.close(null);
        boolean exceptionThrown = false;
        try {
            project.saveSnapshot(2, tempURI, null);
        }
        catch (CoreException coreException) {
            exceptionThrown = true;
        }
        ProjectSnapshotTest.assertTrue((String)"4.0", (boolean)exceptionThrown);
    }
}

