/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class ResourceAttributeTest
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(ResourceAttributeTest.class);
    }

    public ResourceAttributeTest() {
    }

    public ResourceAttributeTest(String name) {
        super(name);
    }

    private void setArchive(IResource resource, boolean value) throws CoreException {
        ResourceAttributes attributes = resource.getResourceAttributes();
        ResourceAttributeTest.assertNotNull((String)"setAchive for null attributes", (Object)attributes);
        attributes.setArchive(value);
        resource.setResourceAttributes(attributes);
    }

    private void setExecutable(IResource resource, boolean value) throws CoreException {
        ResourceAttributes attributes = resource.getResourceAttributes();
        ResourceAttributeTest.assertNotNull((String)"setExecutable for null attributes", (Object)attributes);
        attributes.setExecutable(value);
        resource.setResourceAttributes(attributes);
    }

    private void setHidden(IResource resource, boolean value) throws CoreException {
        ResourceAttributes attributes = resource.getResourceAttributes();
        ResourceAttributeTest.assertNotNull((String)"setHidden for null attributes", (Object)attributes);
        attributes.setHidden(value);
        resource.setResourceAttributes(attributes);
    }

    private void setSymlink(IResource resource, boolean value) throws CoreException {
        ResourceAttributes attributes = resource.getResourceAttributes();
        ResourceAttributeTest.assertNotNull((String)"setSymlink for null attributes", (Object)attributes);
        attributes.setSymbolicLink(value);
        resource.setResourceAttributes(attributes);
    }

    public void testAttributeArchive() {
        if (!this.isAttributeSupported(8)) {
            return;
        }
        IProject project = ResourceAttributeTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("target");
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        try {
            ResourceAttributeTest.assertTrue((String)"1.0", (boolean)file.getResourceAttributes().isArchive());
            this.setArchive((IResource)file, false);
            ResourceAttributeTest.assertTrue((String)"1.2", (!file.getResourceAttributes().isArchive() ? 1 : 0) != 0);
            this.setArchive((IResource)file, true);
            ResourceAttributeTest.assertTrue((String)"1.4", (boolean)file.getResourceAttributes().isArchive());
            ResourceAttributeTest.assertTrue((String)"2.0", (!project.getResourceAttributes().isArchive() ? 1 : 0) != 0);
            this.setArchive((IResource)project, true);
            ResourceAttributeTest.assertTrue((String)"2.2", (boolean)project.getResourceAttributes().isArchive());
            this.setArchive((IResource)project, false);
            ResourceAttributeTest.assertTrue((String)"2.4", (!project.getResourceAttributes().isArchive() ? 1 : 0) != 0);
        }
        catch (CoreException e1) {
            ResourceAttributeTest.fail((String)"2.99", (Throwable)e1);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            ResourceAttributeTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testAttributeExecutable() {
        if (!this.isAttributeSupported(4)) {
            return;
        }
        IProject project = ResourceAttributeTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("target");
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        try {
            ResourceAttributeTest.assertTrue((String)"1.0", (!file.getResourceAttributes().isExecutable() ? 1 : 0) != 0);
            this.setExecutable((IResource)file, true);
            ResourceAttributeTest.assertTrue((String)"1.2", (boolean)file.getResourceAttributes().isExecutable());
            this.setExecutable((IResource)file, false);
            ResourceAttributeTest.assertTrue((String)"1.4", (!file.getResourceAttributes().isExecutable() ? 1 : 0) != 0);
            ResourceAttributeTest.assertTrue((String)"2.0", (boolean)project.getResourceAttributes().isExecutable());
            this.setExecutable((IResource)project, false);
            ResourceAttributeTest.assertTrue((String)"2.2", (!project.getResourceAttributes().isExecutable() ? 1 : 0) != 0);
            this.setExecutable((IResource)project, true);
            ResourceAttributeTest.assertTrue((String)"2.4", (boolean)project.getResourceAttributes().isExecutable());
        }
        catch (CoreException e1) {
            ResourceAttributeTest.fail((String)"2.99", (Throwable)e1);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            ResourceAttributeTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testAttributeHidden() {
        if (!this.isAttributeSupported(16)) {
            return;
        }
        IProject project = ResourceAttributeTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("target");
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        try {
            ResourceAttributeTest.assertTrue((String)"1.0", (!file.getResourceAttributes().isHidden() ? 1 : 0) != 0);
            this.setHidden((IResource)file, true);
            ResourceAttributeTest.assertTrue((String)"1.2", (boolean)file.getResourceAttributes().isHidden());
            this.setHidden((IResource)file, false);
            ResourceAttributeTest.assertTrue((String)"1.4", (!file.getResourceAttributes().isHidden() ? 1 : 0) != 0);
            ResourceAttributeTest.assertTrue((String)"2.0", (!project.getResourceAttributes().isHidden() ? 1 : 0) != 0);
            this.setHidden((IResource)project, true);
            ResourceAttributeTest.assertTrue((String)"2.2", (boolean)project.getResourceAttributes().isHidden());
            this.setHidden((IResource)project, false);
            ResourceAttributeTest.assertTrue((String)"2.4", (!project.getResourceAttributes().isHidden() ? 1 : 0) != 0);
        }
        catch (CoreException e1) {
            ResourceAttributeTest.fail((String)"2.99", (Throwable)e1);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            ResourceAttributeTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testAttributeReadOnly() {
        if (!this.isAttributeSupported(2)) {
            return;
        }
        IProject project = ResourceAttributeTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("target");
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        ResourceAttributeTest.assertTrue((String)"1.0", (!file.getResourceAttributes().isReadOnly() ? 1 : 0) != 0);
        this.setReadOnly((IResource)file, true);
        ResourceAttributeTest.assertTrue((String)"1.2", (boolean)file.getResourceAttributes().isReadOnly());
        this.setReadOnly((IResource)file, false);
        ResourceAttributeTest.assertTrue((String)"1.4", (!file.getResourceAttributes().isReadOnly() ? 1 : 0) != 0);
        ResourceAttributeTest.assertTrue((String)"2.0", (!project.getResourceAttributes().isReadOnly() ? 1 : 0) != 0);
        this.setReadOnly((IResource)project, true);
        ResourceAttributeTest.assertTrue((String)"2.2", (boolean)project.getResourceAttributes().isReadOnly());
        this.setReadOnly((IResource)project, false);
        ResourceAttributeTest.assertTrue((String)"2.4", (!project.getResourceAttributes().isReadOnly() ? 1 : 0) != 0);
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            ResourceAttributeTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testClosedProject() {
        IProject project = ResourceAttributeTest.getWorkspace().getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            ResourceAttributeTest.fail((String)"0.99", (Throwable)e);
        }
        ResourceAttributeTest.assertNull((String)"1.0", (Object)project.getResourceAttributes());
    }

    public void testNonExistingResource() {
        IProject project = ResourceAttributeTest.getWorkspace().getRoot().getProject("testNonExistingResource");
        IFolder folder = project.getFolder("folder");
        IFile file = project.getFile("file");
        this.ensureDoesNotExistInWorkspace((IResource)project);
        ResourceAttributeTest.assertNull((String)"1.0", (Object)project.getResourceAttributes());
        ResourceAttributeTest.assertNull((String)"1.1", (Object)folder.getResourceAttributes());
        ResourceAttributeTest.assertNull((String)"1.2", (Object)file.getResourceAttributes());
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace((IResource)folder, true);
        this.ensureExistsInWorkspace((IResource)file, true);
        ResourceAttributeTest.assertNotNull((String)"2.0", (Object)project.getResourceAttributes());
        ResourceAttributeTest.assertNotNull((String)"2.1", (Object)folder.getResourceAttributes());
        ResourceAttributeTest.assertNotNull((String)"2.2", (Object)file.getResourceAttributes());
    }

    public void _testRefreshExecutableOnFolder() {
        if ((EFS.getLocalFileSystem().attributes() & 4) == 0) {
            return;
        }
        IProject project = ResourceAttributeTest.getWorkspace().getRoot().getProject("testRefreshExecutableOnFolder");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("file");
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        try {
            ResourceAttributeTest.assertTrue((String)"1.0", (boolean)project.getResourceAttributes().isExecutable());
            ResourceAttributeTest.assertTrue((String)"1.1", (boolean)file.exists());
            this.setExecutable((IResource)folder, false);
            this.waitForRefresh();
            boolean wasExecutable = folder.getResourceAttributes().isExecutable();
            boolean fileExists = file.exists();
            this.setExecutable((IResource)folder, true);
            ResourceAttributeTest.assertTrue((String)"2.1", (!wasExecutable ? 1 : 0) != 0);
            ResourceAttributeTest.assertTrue((String)"2.2", (!fileExists ? 1 : 0) != 0);
        }
        catch (CoreException e1) {
            ResourceAttributeTest.fail((String)"2.99", (Throwable)e1);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            ResourceAttributeTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testAttributeSymlink() {
        if (!this.canCreateSymLinks()) {
            return;
        }
        IProject project = ResourceAttributeTest.getWorkspace().getRoot().getProject("Project");
        IFile link = project.getFile("link");
        this.ensureExistsInWorkspace(link, this.getRandomContents());
        try {
            ResourceAttributeTest.assertTrue((String)"1.0", (!link.getResourceAttributes().isSymbolicLink() ? 1 : 0) != 0);
            this.setSymlink((IResource)link, true);
            ResourceAttributeTest.assertTrue((String)"2.0", (!link.getResourceAttributes().isSymbolicLink() ? 1 : 0) != 0);
            this.setSymlink((IResource)link, false);
            ResourceAttributeTest.assertTrue((String)"3.0", (!link.getResourceAttributes().isSymbolicLink() ? 1 : 0) != 0);
        }
        catch (CoreException e1) {
            ResourceAttributeTest.fail((String)"4.0", (Throwable)e1);
        }
        this.ensureDoesNotExistInWorkspace((IResource)link);
        IFile target = project.getFile("target");
        this.ensureExistsInFileSystem(target);
        this.createSymLink(project.getLocation().toFile(), "link", "target", false);
        this.ensureExistsInWorkspace((IResource)link, true);
        ResourceAttributeTest.assertTrue((String)"5.0", (boolean)link.getResourceAttributes().isSymbolicLink());
        try {
            this.setSymlink((IResource)link, false);
            ResourceAttributeTest.assertTrue((String)"3.0", (boolean)link.getResourceAttributes().isSymbolicLink());
        }
        catch (CoreException e1) {
            ResourceAttributeTest.fail((String)"4.0", (Throwable)e1);
        }
        String s = link.getLocation().toOSString();
        link.getLocation().toFile().delete();
        try {
            new File(s).createNewFile();
            ResourceAttributeTest.assertTrue((String)"3.0", (!link.getResourceAttributes().isSymbolicLink() ? 1 : 0) != 0);
        }
        catch (IOException e) {
            ResourceAttributeTest.fail((String)"4.99", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            ResourceAttributeTest.fail((String)"7.0", (Throwable)e);
        }
    }

    public void testAttributes() {
        int[] attributes = new int[]{0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000};
        IProject project = ResourceAttributeTest.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFile file = project.getFile(this.getUniqueString());
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        try {
            int[] nArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                int attribute = nArray[n2];
                if (this.isAttributeSupported(attribute)) {
                    ResourceAttributes resAttr = file.getResourceAttributes();
                    resAttr.set(attribute, true);
                    file.setResourceAttributes(resAttr);
                    ResourceAttributeTest.assertTrue((String)"1.0", (boolean)file.getResourceAttributes().isSet(attribute));
                    resAttr.set(attribute, false);
                    file.setResourceAttributes(resAttr);
                    ResourceAttributeTest.assertFalse((String)"2.0", (boolean)file.getResourceAttributes().isSet(attribute));
                    resAttr = project.getResourceAttributes();
                    resAttr.set(attribute, true);
                    project.setResourceAttributes(resAttr);
                    ResourceAttributeTest.assertTrue((String)"3.0", (boolean)project.getResourceAttributes().isSet(attribute));
                    resAttr.set(attribute, false);
                    project.setResourceAttributes(resAttr);
                    ResourceAttributeTest.assertFalse((String)"4.0", (boolean)project.getResourceAttributes().isSet(attribute));
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            ResourceAttributeTest.fail((String)"5.0", (Throwable)e);
        }
    }
}

