/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTest;

public class ResourceURLTest
extends ResourceTest {
    private static final String CONTENT = "content";
    protected static IPath[] interestingPaths;
    protected static IResource[] interestingResources;
    static boolean noSideEffects;

    static {
        noSideEffects = false;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(ResourceURLTest.class.getName());
        suite.addTest((Test)new ResourceURLTest("testNonExistantURLs"));
        suite.addTest((Test)new ResourceURLTest("testBasicURLs"));
        suite.addTest((Test)new ResourceURLTest("testExternalURLs"));
        suite.addTest((Test)new ResourceURLTest("testSpaces"));
        suite.addTest((Test)new ResourceURLTest("doCleanup"));
        return suite;
    }

    public ResourceURLTest() {
    }

    public ResourceURLTest(String name) {
        super(name);
    }

    private void checkURL(IResource resource) throws Throwable {
        URL url = this.getURL(resource);
        Path file = new Path(FileLocator.resolve((URL)url).getFile());
        IPath metric = resource.getLocation();
        ResourceURLTest.assertEquals((Object)metric, (Object)file);
    }

    @Override
    public String[] defineHierarchy() {
        return new String[]{"/", "/1/", "/1/1", "/1/2", "/1/3", "/2/", "/2/1", "/2/2", "/2/3", "/3/", "/3/1", "/3/2", "/3/3", "/4/", "/5"};
    }

    public void doCleanup() throws CoreException {
        ResourceURLTest.getWorkspace().getRoot().delete(true, true, null);
    }

    protected IProject getTestProject() {
        return ResourceURLTest.getWorkspace().getRoot().getProject("testProject");
    }

    protected IProject getTestProject2() {
        return ResourceURLTest.getWorkspace().getRoot().getProject("testProject2");
    }

    private URL getURL(IPath path) throws Throwable {
        return new URL("platform:/resource" + path.makeAbsolute().toString());
    }

    private URL getURL(IResource resource) throws Throwable {
        return this.getURL(resource.getFullPath());
    }

    @Override
    protected void tearDown() throws Exception {
    }

    public void testBasicURLs() throws Throwable {
        IResource[] resources = this.buildResources();
        this.ensureExistsInWorkspace(resources, true);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.checkURL(resource);
            ++n2;
        }
    }

    public void testExternalURLs() throws Throwable {
        IProject project = ResourceURLTest.getWorkspace().getRoot().getProject("test");
        IProjectDescription desc = ResourceURLTest.getWorkspace().newProjectDescription("test");
        desc.setLocation(Platform.getLocation().append("../testproject"));
        project.create(desc, null);
        project.open(null);
        IResource[] resources = this.buildResources((IContainer)project, this.defineHierarchy());
        this.ensureExistsInWorkspace(resources, true);
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.checkURL(resource);
            ++n2;
        }
    }

    public void testNonExistantURLs() throws Throwable {
        IResource[] resources = this.buildResources();
        int i = 1;
        while (i < resources.length) {
            try {
                this.checkURL(resources[i]);
                ResourceURLTest.fail((String)"1.0");
            }
            catch (IOException iOException) {}
            ++i;
        }
    }

    public void testSpaces() {
        IProject project = ResourceURLTest.getWorkspace().getRoot().getProject("My Project");
        IFile file = project.getFile("a.txt");
        this.ensureExistsInWorkspace(file, CONTENT);
        try {
            URL url = new URL("platform:/resource/My%20Project/a.txt");
            InputStream stream = url.openStream();
            ResourceURLTest.assertTrue((String)"1.0", (boolean)this.compareContent(stream, this.getContents(CONTENT)));
        }
        catch (MalformedURLException e) {
            ResourceURLTest.fail((String)"0.99", (Throwable)e);
        }
        catch (IOException e) {
            ResourceURLTest.fail((String)"1.99", (Throwable)e);
        }
    }
}

