/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.junit.Assert;

public class TestUtil {
    static Set<Job> runningJobs = new LinkedHashSet<Job>();

    public static void cleanUp(String owner) {
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
        boolean timedOut = TestUtil.waitForJobs(owner, 5L, 5000L);
        if (timedOut) {
            TestUtil.log(1, owner, "Trying to cancel running jobs: " + TestUtil.getRunningOrWaitingJobs(null), new Throwable[0]);
            TestUtil.getRunningOrWaitingJobs(null).forEach(job -> {
                boolean bl = job.cancel();
            });
            TestUtil.waitForJobs(owner, 5L, 1000L);
        }
        Assert.assertFalse((String)"The main thread should not be interrupted at the end of a test", (boolean)Thread.interrupted());
    }

    public static void log(int severity, String owner, String message, Throwable ... optionalError) {
        message = "[" + owner + "] " + message;
        Throwable error = null;
        if (optionalError != null && optionalError.length > 0) {
            error = optionalError[0];
        }
        Status status = new Status(severity, "org.eclipse.core.tests.resources", message, error);
        InternalPlatform.getDefault().getLog(Platform.getBundle((String)"org.eclipse.core.tests.resources")).log((IStatus)status);
    }

    public static boolean waitForJobs(String owner, long minTimeMs, long maxTimeMs) {
        if (maxTimeMs < minTimeMs) {
            throw new IllegalArgumentException("Max time is smaller as min time!");
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start < minTimeMs) {
            try {
                Thread.sleep(Math.min(10L, minTimeMs));
            }
            catch (InterruptedException interruptedException) {}
        }
        while (!Job.getJobManager().isIdle()) {
            List<Job> jobs = TestUtil.getRunningOrWaitingJobs(null);
            if (!Collections.disjoint(runningJobs, jobs)) {
                TestUtil.dumpRunningOrWaitingJobs(owner, jobs);
                return true;
            }
            if (System.currentTimeMillis() - start >= maxTimeMs) {
                TestUtil.dumpRunningOrWaitingJobs(owner, jobs);
                return true;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        runningJobs.clear();
        return false;
    }

    private static void dumpRunningOrWaitingJobs(String owner, List<Job> jobs) {
        String message = "Some job is still running or waiting to run: " + TestUtil.dumpRunningOrWaitingJobs(jobs);
        TestUtil.log(4, owner, message, new Throwable[0]);
    }

    private static String dumpRunningOrWaitingJobs(List<Job> jobs) {
        if (jobs.isEmpty()) {
            return "";
        }
        runningJobs.clear();
        StringBuilder sb = new StringBuilder();
        for (Job job : jobs) {
            runningJobs.add(job);
            sb.append("'").append(job.getName()).append("'/");
            sb.append(job.getClass().getName());
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    private static List<Job> getRunningOrWaitingJobs(Object jobFamily) {
        Job[] jobs;
        ArrayList<Job> running = new ArrayList<Job>();
        Job[] jobArray = jobs = Job.getJobManager().find(jobFamily);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (TestUtil.isRunningOrWaitingJob(job)) {
                running.add(job);
            }
            ++n2;
        }
        return running;
    }

    private static boolean isRunningOrWaitingJob(Job job) {
        int state = job.getState();
        return state == 4 || state == 2;
    }
}

