/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.File;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTest;

public class WorkspaceTest
extends ResourceTest {
    public WorkspaceTest() {
    }

    public WorkspaceTest(String name) {
        super(name);
    }

    public void doCleanup() throws Exception {
        IPath location = WorkspaceTest.getWorkspace().getRoot().getLocation().append("testProject");
        this.deleteOnTearDown(location);
        IPath location2 = WorkspaceTest.getWorkspace().getRoot().getLocation().append("testProject2");
        this.deleteOnTearDown(location2);
        this.cleanup();
        WorkspaceTest.assertTrue((String)(String.valueOf(location.toOSString()) + " has not been deleted"), (!location.toFile().exists() ? 1 : 0) != 0);
        WorkspaceTest.assertTrue((String)(String.valueOf(location2.toOSString()) + " has not been deleted"), (!location2.toFile().exists() ? 1 : 0) != 0);
    }

    @Override
    public String[] defineHierarchy() {
        return new String[]{"/", "/1/", "/1/1", "/1/2", "/1/3", "/2/", "/2/1", "/2/2", "/2/3", "/3/", "/3/1", "/3/2", "/3/3", "/4/", "/5"};
    }

    protected IProject getTestProject() {
        return WorkspaceTest.getWorkspace().getRoot().getProject("testProject");
    }

    protected IProject getTestProject2() {
        return WorkspaceTest.getWorkspace().getRoot().getProject("testProject2");
    }

    public void setGetPersistentProperty(IResource target) throws Throwable {
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        target.setPersistentProperty(name, value);
        WorkspaceTest.assertTrue((String)"get not equal set", (boolean)target.getPersistentProperty(name).equals(value));
        name = new QualifiedName("itp-test", "testNonProperty");
        WorkspaceTest.assertNull((String)"non-existant persistent property not missing", (Object)target.getPersistentProperty(name));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(WorkspaceTest.class.getName());
        suite.addTest((Test)new WorkspaceTest("testProjectCreation"));
        suite.addTest((Test)new WorkspaceTest("testFolderCreation"));
        suite.addTest((Test)new WorkspaceTest("testFileCreation"));
        suite.addTest((Test)new WorkspaceTest("testFileInFolderCreation"));
        suite.addTest((Test)new WorkspaceTest("testSetContents"));
        suite.addTest((Test)new WorkspaceTest("testFileOverFolder"));
        suite.addTest((Test)new WorkspaceTest("testFolderOverFile"));
        suite.addTest((Test)new WorkspaceTest("testProjectCreateOpenCloseDelete"));
        suite.addTest((Test)new WorkspaceTest("testProjectReferences"));
        suite.addTest((Test)new WorkspaceTest("testProjectCloseOpen"));
        suite.addTest((Test)new WorkspaceTest("testSetGetProjectPersistentProperty"));
        suite.addTest((Test)new WorkspaceTest("testSetGetFolderPersistentProperty"));
        suite.addTest((Test)new WorkspaceTest("testSetGetFilePersistentProperty"));
        suite.addTest((Test)new WorkspaceTest("testSimpleMove"));
        suite.addTest((Test)new WorkspaceTest("testFileMove"));
        suite.addTest((Test)new WorkspaceTest("testLeafFolderMove"));
        suite.addTest((Test)new WorkspaceTest("testFolderMove"));
        suite.addTest((Test)new WorkspaceTest("testMultiCreation"));
        suite.addTest((Test)new WorkspaceTest("testFolderDeletion"));
        suite.addTest((Test)new WorkspaceTest("testFileDeletion"));
        suite.addTest((Test)new WorkspaceTest("testFileEmptyDeletion"));
        suite.addTest((Test)new WorkspaceTest("testMultiDeletion"));
        suite.addTest((Test)new WorkspaceTest("testProjectDeletion"));
        suite.addTest((Test)new WorkspaceTest("testWorkingLocationDeletion_bug433061"));
        suite.addTest((Test)new WorkspaceTest("doCleanup"));
        return suite;
    }

    @Override
    protected void tearDown() throws Exception {
    }

    public void testFileCreation() throws Throwable {
        Path path = new Path("/testProject/testFile");
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        target.create(null, true, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.exists());
    }

    public void testFileDeletion() throws Throwable {
        Path path = new Path("/testProject/testFileForDelete");
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        target.create(null, true, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.exists());
        target.delete(true, this.getMonitor());
        WorkspaceTest.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    public void testFileEmptyDeletion() throws Throwable {
        Path path = new Path("/testProject/testFileForDelete2");
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        target.create(this.getContents(""), true, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.exists());
        target.delete(true, this.getMonitor());
        WorkspaceTest.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    public void testFileInFolderCreation() throws Throwable {
        Path path = new Path("/testProject/testFolder/testFile2");
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        target.create(this.getRandomContents(), true, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.exists());
    }

    public void testFileMove() throws Throwable {
        Path path = new Path("/testProject/targetFile");
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        target.create(this.getRandomContents(), true, this.getMonitor());
        IFile destination = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)new Path("/testProject/movedFile"));
        target.move(destination.getFullPath(), true, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)destination.exists());
        WorkspaceTest.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    public void testFileOverFolder() throws Throwable {
        Path path = new Path("/testProject/testFolder");
        IFolder existing = WorkspaceTest.getWorkspace().getRoot().getFolder((IPath)path);
        WorkspaceTest.assertTrue((boolean)existing.exists());
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        try {
            target.create(null, true, this.getMonitor());
        }
        catch (CoreException coreException) {
            WorkspaceTest.assertTrue((boolean)existing.exists());
            return;
        }
        WorkspaceTest.fail((String)"Should not be able to create file over folder");
    }

    public void testFolderCreation() throws Throwable {
        Path path = new Path("/testProject/testFolder");
        IFolder target = WorkspaceTest.getWorkspace().getRoot().getFolder((IPath)path);
        target.create(true, true, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.exists());
    }

    public void testFolderDeletion() throws Throwable {
        IProject project = this.getTestProject();
        IResource[] before = this.buildResources((IContainer)project, new String[]{"c/", "c/b/", "c/x", "c/b/y", "c/b/z"});
        this.ensureExistsInWorkspace(before, true);
        this.assertExistsInWorkspace(before);
        project.getFolder("c").delete(true, this.getMonitor());
        this.assertDoesNotExistInWorkspace(before);
    }

    public void testFolderMove() throws Throwable {
        IProject project = this.getTestProject();
        IResource[] before = this.buildResources((IContainer)project, new String[]{"b/", "b/b/", "b/x", "b/b/y", "b/b/z"});
        IResource[] after = this.buildResources((IContainer)project, new String[]{"a/", "a/b/", "a/x", "a/b/y", "a/b/z"});
        this.ensureExistsInWorkspace(before, true);
        String content = this.getRandomString();
        IFile file = project.getFile((IPath)new Path("b/b/z"));
        file.setContents(this.getContents(content), true, false, this.getMonitor());
        this.assertExistsInWorkspace(before);
        project.getFolder("b").move(project.getFullPath().append("a"), true, this.getMonitor());
        this.assertDoesNotExistInWorkspace(before);
        this.assertExistsInWorkspace(after);
        file = project.getFile((IPath)new Path("a/b/z"));
        WorkspaceTest.assertTrue((String)"get not equal set", (boolean)this.compareContent(this.getContents(content), file.getContents(false)));
    }

    public void testFolderOverFile() throws Throwable {
        Path path = new Path("/testProject/testFile");
        IFile existing = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        WorkspaceTest.assertTrue((boolean)existing.exists());
        IFolder target = WorkspaceTest.getWorkspace().getRoot().getFolder((IPath)path);
        try {
            target.create(true, true, this.getMonitor());
        }
        catch (CoreException coreException) {
            WorkspaceTest.assertTrue((boolean)existing.exists());
            return;
        }
        WorkspaceTest.fail((String)"Should not be able to create folder over a file");
    }

    public void testLeafFolderMove() throws Throwable {
        IProject project = this.getTestProject();
        IFolder source = project.getFolder("testFolder");
        IFolder dest = project.getFolder("movedFolder");
        source.move(dest.getFullPath(), true, this.getMonitor());
        this.assertExistsInWorkspace((IResource)dest);
        this.assertDoesNotExistInWorkspace((IResource)source);
    }

    public void testMultiCreation() throws Throwable {
        IProject project = WorkspaceTest.getWorkspace().getRoot().getProject("bar");
        IResource[] resources = this.buildResources((IContainer)project, new String[]{"a/", "a/b"});
        IWorkspaceRunnable body = monitor -> {
            if (!project.exists()) {
                project.create(null);
            }
            if (!project.isOpen()) {
                project.open(null);
            }
            IResource[] iResourceArray2 = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray2[n2];
                switch (resource.getType()) {
                    case 1: {
                        ((IFile)resource).create(null, false, this.getMonitor());
                        break;
                    }
                    case 2: {
                        ((IFolder)resource).create(false, true, this.getMonitor());
                        break;
                    }
                    case 4: {
                        ((IProject)resource).create(this.getMonitor());
                    }
                }
                ++n2;
            }
        };
        WorkspaceTest.getWorkspace().run(body, this.getMonitor());
        this.assertExistsInWorkspace((IResource)project);
        this.assertExistsInWorkspace(resources);
    }

    public void testMultiDeletion() throws Throwable {
        IProject project = this.getTestProject();
        IResource[] before = this.buildResources((IContainer)project, new String[]{"c/", "c/b/", "c/x", "c/b/y", "c/b/z"});
        this.ensureExistsInWorkspace(before, true);
        this.assertExistsInWorkspace(before);
        WorkspaceTest.getWorkspace().delete(before, true, this.getMonitor());
        this.assertDoesNotExistInWorkspace(before);
    }

    public void testProjectCloseOpen() throws Throwable {
        IProject target = this.getTestProject();
        target.close(this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.exists());
        WorkspaceTest.assertTrue((!target.isOpen() ? 1 : 0) != 0);
        WorkspaceTest.assertTrue((!target.getFolder("testFolder").exists() ? 1 : 0) != 0);
        target.open(this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.isOpen());
        WorkspaceTest.assertTrue((boolean)target.getFolder("testFolder").exists());
    }

    public void testProjectCreateOpenCloseDelete() throws Throwable {
        IProject target = this.getTestProject2();
        target.create(null, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.exists());
        target.open(this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.isOpen());
        target.close(this.getMonitor());
        WorkspaceTest.assertTrue((!target.isOpen() ? 1 : 0) != 0);
        target.delete(true, this.getMonitor());
        WorkspaceTest.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    public void testProjectCreation() throws Throwable {
        IProject target = this.getTestProject();
        target.create(null, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.exists());
        target.open(this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.isOpen());
    }

    public void testProjectDeletion() throws Throwable {
        IProject target = this.getTestProject();
        target.delete(true, this.getMonitor());
        WorkspaceTest.assertTrue((String)"Project Deletion failed", (!target.exists() ? 1 : 0) != 0);
    }

    public void testWorkingLocationDeletion_bug433061() throws Throwable {
        if (!this.canCreateSymLinks()) {
            return;
        }
        IProject project = this.getTestProject();
        project.create(null, this.getMonitor());
        IPath workingLocation = project.getWorkingLocation("org.eclipse.core.tests.resources");
        IPath linkTarget = this.getRandomLocation();
        try {
            linkTarget.toFile().mkdirs();
            File file = linkTarget.append("aFile").toFile();
            WorkspaceTest.assertTrue((boolean)file.createNewFile());
            WorkspaceTest.assertTrue((boolean)file.exists());
            this.createSymLink(workingLocation.toFile(), "link", linkTarget.toOSString(), true);
            project.delete(true, this.getMonitor());
            WorkspaceTest.assertTrue((String)"Project deletion failed", (!project.exists() ? 1 : 0) != 0);
            WorkspaceTest.assertTrue((String)"Working location was not deleted", (!workingLocation.toFile().exists() ? 1 : 0) != 0);
            WorkspaceTest.assertTrue((String)"File inside a symlinked directory got deleted", (boolean)file.exists());
        }
        finally {
            Workspace.clear((File)linkTarget.toFile());
        }
    }

    public void testProjectReferences() throws Throwable {
        IProject target = this.getTestProject2();
        target.create(null, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)target.exists());
        IProject project = this.getTestProject();
        IProjectDescription description = project.getDescription();
        description.setReferencedProjects(new IProject[]{target});
        project.setDescription(description, this.getMonitor());
        WorkspaceTest.assertTrue((target.getReferencingProjects().length == 1 ? 1 : 0) != 0);
        target.delete(true, this.getMonitor());
        WorkspaceTest.assertTrue((!target.exists() ? 1 : 0) != 0);
    }

    public void testSetContents() throws Throwable {
        Path path = new Path("/testProject/testFile");
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        String testString = this.getRandomString();
        target.setContents(this.getContents(testString), true, false, this.getMonitor());
        try (InputStream content = null;){
            content = target.getContents(false);
            WorkspaceTest.assertTrue((String)"get not equal set", (boolean)this.compareContent(content, this.getContents(testString)));
        }
    }

    public void testSetGetFilePersistentProperty() throws Throwable {
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)new Path("/testProject/testFile"));
        this.setGetPersistentProperty((IResource)target);
    }

    public void testSetGetFolderPersistentProperty() throws Throwable {
        IFolder target = WorkspaceTest.getWorkspace().getRoot().getFolder((IPath)new Path("/testProject/testFolder"));
        this.setGetPersistentProperty((IResource)target);
    }

    public void testSetGetProjectPersistentProperty() throws Throwable {
        IProject target = WorkspaceTest.getWorkspace().getRoot().getProject("/testProject");
        this.setGetPersistentProperty((IResource)target);
    }

    public void testSetProperty() throws Throwable {
        Path path = new Path("/testProject/testFile");
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        String value = "this is a test property value";
        QualifiedName name = new QualifiedName("itp-test", "testProperty");
        target.setPersistentProperty(name, value);
        WorkspaceTest.assertTrue((String)"get not equal set", (boolean)target.getPersistentProperty(name).equals(value));
    }

    public void testSimpleMove() throws Throwable {
        Path path = new Path("/testProject/simpleFile");
        IFile target = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)path);
        target.create(this.getRandomContents(), true, this.getMonitor());
        IFile destination = WorkspaceTest.getWorkspace().getRoot().getFile((IPath)new Path("/testProject/newSimpleFile"));
        target.move(destination.getFullPath(), true, this.getMonitor());
        WorkspaceTest.assertTrue((boolean)destination.exists());
        WorkspaceTest.assertTrue((!target.exists() ? 1 : 0) != 0);
    }
}

