/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.content.ContentDescription;
import org.eclipse.core.internal.content.ContentType;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.IContentTypeInfo;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.tests.resources.content.ContentTypeTest;

public class ContentDescriptionTest
extends ContentTypeTest {
    private static final String CT_VOID = "org.eclipse.core.tests.resources.void";
    private static final QualifiedName ZOO_PROPERTY = new QualifiedName("org.eclipse.core.tests.resources", "zoo");
    private static final QualifiedName BAR_PROPERTY = new QualifiedName("org.eclipse.core.tests.resources", "bar");
    private static final QualifiedName FOO_PROPERTY = new QualifiedName("org.eclipse.core.tests.resources", "foo");
    private static final QualifiedName FRED_PROPERTY = new QualifiedName("org.eclipse.core.tests.resources", "fred");

    public ContentDescriptionTest(String name) {
        super(name);
    }

    private ContentType getContentType() {
        return ((ContentTypeHandler)Platform.getContentTypeManager().getContentType(CT_VOID)).getTarget();
    }

    public void testAllProperties() {
        ContentDescription description = new ContentDescription(IContentDescription.ALL, (IContentTypeInfo)this.getContentType());
        ContentDescriptionTest.assertTrue((String)"1.0", (boolean)description.isRequested(FOO_PROPERTY));
        ContentDescriptionTest.assertNull((String)"1.1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1");
        ContentDescriptionTest.assertEquals((String)"1.2", (Object)"value1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1b");
        ContentDescriptionTest.assertEquals((String)"1.3", (Object)"value1b", (Object)description.getProperty(FOO_PROPERTY));
        ContentDescriptionTest.assertTrue((String)"2.0", (boolean)description.isRequested(BAR_PROPERTY));
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        ContentDescriptionTest.assertEquals((String)"2.1", (Object)"value2", (Object)description.getProperty(BAR_PROPERTY));
        description.setProperty(ZOO_PROPERTY, (Object)"value3");
        ContentDescriptionTest.assertEquals((String)"2.2", (Object)"value3", (Object)description.getProperty(ZOO_PROPERTY));
        description.markImmutable();
        try {
            description.setProperty(FOO_PROPERTY, (Object)"value1c");
            ContentDescriptionTest.fail((String)"3.0 - should have failed");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testOneProperty() {
        ContentDescription description = new ContentDescription(new QualifiedName[]{FOO_PROPERTY}, (IContentTypeInfo)this.getContentType());
        ContentDescriptionTest.assertTrue((String)"1.0", (boolean)description.isRequested(FOO_PROPERTY));
        ContentDescriptionTest.assertNull((String)"1.1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1");
        ContentDescriptionTest.assertEquals((String)"1.2", (Object)"value1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1b");
        ContentDescriptionTest.assertEquals((String)"1.3", (Object)"value1b", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        ContentDescriptionTest.assertTrue((String)"2.0", (!description.isRequested(BAR_PROPERTY) ? 1 : 0) != 0);
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        ContentDescriptionTest.assertNull((String)"2.1", (Object)description.getProperty(BAR_PROPERTY));
        description.markImmutable();
        try {
            description.setProperty(FOO_PROPERTY, (Object)"value1c");
            ContentDescriptionTest.fail((String)"3.0 - should have failed");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testZeroProperties() {
        ContentDescription description = new ContentDescription(new QualifiedName[0], (IContentTypeInfo)this.getContentType());
        ContentDescriptionTest.assertTrue((String)"1.0", (!description.isRequested(FOO_PROPERTY) ? 1 : 0) != 0);
        ContentDescriptionTest.assertNull((String)"1.1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1");
        ContentDescriptionTest.assertNull((String)"1.2", (Object)description.getProperty(FOO_PROPERTY));
        description.markImmutable();
        try {
            description.setProperty(FOO_PROPERTY, (Object)"value1b");
            ContentDescriptionTest.fail((String)"2.0 - should have failed");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testMultipleProperties() {
        ContentDescription description = new ContentDescription(new QualifiedName[]{FOO_PROPERTY, BAR_PROPERTY, ZOO_PROPERTY}, (IContentTypeInfo)this.getContentType());
        ContentDescriptionTest.assertTrue((String)"1.0", (boolean)description.isRequested(FOO_PROPERTY));
        ContentDescriptionTest.assertNull((String)"1.1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1");
        ContentDescriptionTest.assertEquals((String)"1.2", (Object)"value1", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(FOO_PROPERTY, (Object)"value1b");
        ContentDescriptionTest.assertEquals((String)"1.3", (Object)"value1b", (Object)description.getProperty(FOO_PROPERTY));
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        ContentDescriptionTest.assertTrue((String)"2.0", (boolean)description.isRequested(BAR_PROPERTY));
        description.setProperty(BAR_PROPERTY, (Object)"value2");
        ContentDescriptionTest.assertEquals((String)"2.1", (Object)"value2", (Object)description.getProperty(BAR_PROPERTY));
        ContentDescriptionTest.assertTrue((String)"2.2", (boolean)description.isRequested(ZOO_PROPERTY));
        description.setProperty(ZOO_PROPERTY, (Object)"value3");
        ContentDescriptionTest.assertEquals((String)"2.3", (Object)"value3", (Object)description.getProperty(ZOO_PROPERTY));
        ContentDescriptionTest.assertTrue((String)"3.0", (!description.isRequested(FRED_PROPERTY) ? 1 : 0) != 0);
        description.setProperty(FRED_PROPERTY, (Object)"value3");
        ContentDescriptionTest.assertNull((String)"3.1", (Object)description.getProperty(FRED_PROPERTY));
        description.markImmutable();
        try {
            description.setProperty(FOO_PROPERTY, (Object)"value1c");
            ContentDescriptionTest.fail((String)"4.0 - should have failed");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public static Test suite() {
        return new TestSuite(ContentDescriptionTest.class);
    }
}

