/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.eclipse.core.internal.content.ContentTypeHandler;
import org.eclipse.core.internal.content.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.content.IContentTypeMatcher;
import org.eclipse.core.runtime.content.XMLContentDescriber;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.core.tests.harness.TestRegistryChangeListener;
import org.eclipse.core.tests.resources.content.ContentTypeTest;
import org.eclipse.core.tests.resources.content.LocalSelectionPolicy;
import org.eclipse.core.tests.resources.content.MyContentDescriber;
import org.eclipse.core.tests.resources.content.SubsetSelectionPolicy;
import org.eclipse.test.OrderedTestSuite;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class IContentTypeManagerTest
extends ContentTypeTest {
    private static final String FAMILY_CHARSET_DELTA = "org.eclipse.core.resources.charsetJobFamily";
    private static final String MINIMAL_XML = "<?xml version=\"1.0\"?><org.eclipse.core.resources.tests.root/>";
    private static final String SAMPLE_BIN1_OFFSET = "12345";
    private static final byte[] SAMPLE_BIN1_SIGNATURE = new byte[]{16, -85, -51, -1};
    private static final String SAMPLE_BIN2_OFFSET = "";
    private static final byte[] SAMPLE_BIN2_SIGNATURE = new byte[]{16, -85, -51, -17};
    private static final String XML_DTD_EXTERNAL_ENTITY = "<?xml version=\"1.0\"?><!DOCTYPE project  SYSTEM \"org.eclipse.core.resources.tests.some.dtd\"  [<!ENTITY someentity SYSTEM \"someentity.xml\">]><org.eclipse.core.resources.tests.root/>";
    private static final String XML_DTD_US_ASCII = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><!DOCTYPE sometype SYSTEM \"org.eclipse.core.resources.tests.some.dtd\"><org.eclipse.core.resources.tests.root/>";
    private static final String XML_ISO_8859_1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_ISO_8859_1_SINGLE_QUOTES = "<?xml version='1.0' encoding='ISO-8859-1'?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_ROOT_ELEMENT_EXTERNAL_ENTITY = "<?xml version=\"1.0\"?><!DOCTYPE project   [<!ENTITY someentity SYSTEM \"someentity.xml\">]><org.eclipse.core.resources.tests.root-element/>";
    private static final String XML_ROOT_ELEMENT_EXTERNAL_ENTITY2 = "<?xml version=\"1.0\"?><!DOCTYPE org.eclipse.core.resources.tests.root-element PUBLIC \"org.eclipse.core.resources.tests.root-elementId\" \"org.eclipse.core.resources.tests.root-element.dtd\" ><org.eclipse.core.resources.tests.root-element/>";
    private static final String XML_ROOT_ELEMENT_ISO_8859_1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><org.eclipse.core.resources.tests.root-element/>";
    private static final String XML_ROOT_ELEMENT_NO_DECL = "<org.eclipse.core.resources.tests.root-element/>";
    private static final String XML_US_ASCII_INVALID = "<?xml version='1.0' encoding='us-ascii'?><!-- Non-ASCII chars: \ufffd\ufffd\ufffd\ufffd\ufffd --><org.eclipse.core.resources.tests.root/>";
    private static final String XML_UTF_16 = "<?xml version=\"1.0\" encoding=\"UTF-16\"?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_UTF_16BE = "<?xml version=\"1.0\" encoding=\"UTF-16BE\"?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_UTF_16LE = "<?xml version=\"1.0\" encoding=\"UTF-16LE\"?><org.eclipse.core.resources.tests.root/>";
    private static final String XML_UTF_8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><org.eclipse.core.resources.tests.root/>";
    public static final String XML_ROOT_ELEMENT_NS_MATCH1 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><prefix:rootElement1 xmlns:prefix='urn:eclipse.core.runtime.ns1'/>";
    private static final String XML_ROOT_ELEMENT_NS_MATCH2 = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><!DOCTYPE rootElement2 SYSTEM \"org.eclipse.core.resources.tests.nothing\"><rootElement2 xmlns='urn:eclipse.core.runtime.ns2'/>";
    private static final String XML_ROOT_ELEMENT_NS_WRONG_ELEM = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><rootElement3 xmlns='urn:eclipse.core.runtime.ns2'/>";
    private static final String XML_ROOT_ELEMENT_NS_WRONG_NS = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><prefix:rootElement1 xmlns='http://example.com/'/>";
    private static final String XML_ROOT_ELEMENT_NS_MIXUP = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><rootElement2 xmlns='urn:eclipse.core.runtime.ns1'/>";
    private static final String XML_ROOT_ELEMENT_NS_WILDCARD = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><weCouldPutAnythingHere xmlns='urn:eclipse.core.runtime.nsWild'/>";
    private static final String XML_ROOT_ELEMENT_NS_WILDCARD2 = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><!DOCTYPE Joker SYSTEM \"org.eclipse.core.resources.tests.some.dtd3\"><Joker/>";
    private static final String XML_ROOT_ELEMENT_EMPTY_NS = "<?xml version=\"1.0\" encoding=\"US-ASCII\"?><!DOCTYPE Joker SYSTEM \"org.eclipse.core.resources.tests.some.dtd3\"><rootElement>";

    public static Test suite() {
        return new OrderedTestSuite(IContentTypeManagerTest.class);
    }

    public IContentTypeManagerTest(String name) {
        super(name);
    }

    private String changeCase(String original) {
        StringBuilder result = new StringBuilder(original);
        int i = result.length() - 1;
        while (i >= 0) {
            char originalChar = original.charAt(i);
            result.setCharAt(i, i % 2 == 0 ? Character.toLowerCase(originalChar) : Character.toUpperCase(originalChar));
            --i;
        }
        return result.toString();
    }

    boolean contains(Object[] array, Object element) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element2 = objectArray[n2];
            if (element2.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private IContentDescription getDescriptionFor(IContentTypeMatcher finder, String contents, Charset encoding, String fileName, QualifiedName[] options, boolean text) throws IOException {
        return text ? finder.getDescriptionFor(this.getReader(contents), fileName, options) : finder.getDescriptionFor(this.getInputStream(contents, encoding), fileName, options);
    }

    public InputStream getInputStream(byte[][] contents) {
        int size = 0;
        byte[][] byArray = contents;
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] content = byArray[n2];
            size += content.length;
            ++n2;
        }
        byte[] full = new byte[size];
        int fullIndex = 0;
        byte[][] byArray2 = contents;
        int n3 = contents.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] content;
            byte[] byArray3 = content = byArray2[n4];
            int n5 = content.length;
            int n6 = 0;
            while (n6 < n5) {
                byte element = byArray3[n6];
                full[fullIndex++] = element;
                ++n6;
            }
            ++n4;
        }
        return new ByteArrayInputStream(full);
    }

    public InputStream getInputStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    public InputStream getInputStream(String contents, Charset encoding) {
        return new ByteArrayInputStream(encoding == null ? contents.getBytes() : contents.getBytes(encoding));
    }

    public Reader getReader(String contents) {
        return new CharArrayReader(contents.toCharArray());
    }

    private boolean isText(IContentTypeManager manager, IContentType candidate) {
        IContentType text = manager.getContentType("org.eclipse.core.runtime.text");
        return candidate.isKindOf(text);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Job.getJobManager().join((Object)FAMILY_CHARSET_DELTA, this.getMonitor());
    }

    public void testAlias() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType alias = contentTypeManager.getContentType("org.eclipse.core.tests.resources.alias");
        IContentTypeManagerTest.assertNotNull((String)"0.7", (Object)alias);
        IContentType derived = contentTypeManager.getContentType("org.eclipse.core.tests.resources.derived-from-alias");
        IContentTypeManagerTest.assertNotNull((String)"0.8", (Object)derived);
        IContentType target = contentTypeManager.getContentType("org.eclipse.bundle02.missing-target");
        IContentTypeManagerTest.assertNull((String)"0.9", (Object)target);
        IContentType[] selected = contentTypeManager.findContentTypesFor("foo.missing-target");
        IContentTypeManagerTest.assertEquals((String)"1.1", (int)2, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"1.2", (Object)alias, (Object)selected[0]);
        IContentTypeManagerTest.assertEquals((String)"1.3", (Object)derived, (Object)selected[1]);
        selected = contentTypeManager.findContentTypesFor(this.getRandomContents(), "foo.missing-target");
        IContentTypeManagerTest.assertEquals((String)"1.4", (int)2, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"1.5", (Object)alias, (Object)selected[0]);
        IContentTypeManagerTest.assertEquals((String)"1.6", (Object)derived, (Object)selected[1]);
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles((String)"2", () -> {
            IContentType alias1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.alias");
            IContentTypeManagerTest.assertNull((String)"2.1.1", (Object)alias1);
            IContentType derived1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.derived-from-alias");
            IContentTypeManagerTest.assertNotNull((String)"2.1.2", (Object)derived1);
            IContentType target1 = contentTypeManager.getContentType("org.eclipse.bundle02.missing-target");
            IContentTypeManagerTest.assertNotNull((String)"2.1.3", (Object)target1);
            IContentType[] selected1 = contentTypeManager.findContentTypesFor("foo.missing-target");
            IContentTypeManagerTest.assertEquals((String)"2.2.1", (int)2, (int)selected1.length);
            IContentTypeManagerTest.assertEquals((String)"2.2.2", (Object)target1, (Object)selected1[0]);
            IContentTypeManagerTest.assertEquals((String)"2.2.3", (Object)derived1, (Object)selected1[1]);
            try {
                selected1 = contentTypeManager.findContentTypesFor(this.getRandomContents(), "foo.missing-target");
            }
            catch (IOException e) {
                IContentTypeManagerTest.fail((String)"2.2.4", (Throwable)e);
            }
            IContentTypeManagerTest.assertEquals((String)"2.2.5", (int)2, (int)selected1.length);
            IContentTypeManagerTest.assertEquals((String)"2.2.6", (Object)target1, (Object)selected1[0]);
            IContentTypeManagerTest.assertEquals((String)"2.2.7", (Object)derived1, (Object)selected1[1]);
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle02"}, (TestRegistryChangeListener)listener);
    }

    public void testAssociationInheritance() throws CoreException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = manager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType text = manager.getContentType("org.eclipse.core.runtime.text");
        IContentType assoc1 = manager.getContentType("org.eclipse.core.tests.resources.assoc1");
        IContentType assoc2 = manager.getContentType("org.eclipse.core.tests.resources.assoc2");
        text.addFileSpec("txt_useradded", 8);
        assoc1.addFileSpec("txt_assoc1useradded", 8);
        assoc2.addFileSpec("txt_assoc2useradded", 8);
        IContentTypeManagerTest.assertTrue((String)"1.1", (boolean)assoc1.isAssociatedWith(this.changeCase("text.txt")));
        IContentTypeManagerTest.assertTrue((String)"1.2", (boolean)assoc1.isAssociatedWith(this.changeCase("text.txt_useradded")));
        IContentTypeManagerTest.assertTrue((String)"1.3", (boolean)assoc1.isAssociatedWith(this.changeCase("text.txt_pluginadded")));
        IContentTypeManagerTest.assertTrue((String)"1.4", (boolean)assoc1.isAssociatedWith(this.changeCase("text.txt_assoc1pluginadded")));
        IContentTypeManagerTest.assertTrue((String)"1.5", (boolean)assoc1.isAssociatedWith(this.changeCase("text.txt_assoc1useradded")));
        IContentTypeManagerTest.assertTrue((String)"2.1", (!assoc2.isAssociatedWith(this.changeCase("text.txt")) ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"2.2", (!assoc2.isAssociatedWith(this.changeCase("text.txt_useradded")) ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"2.3", (!assoc2.isAssociatedWith(this.changeCase("text.txt_pluginadded")) ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"2.4", (boolean)assoc2.isAssociatedWith(this.changeCase("text.txt_assoc2pluginadded")));
        IContentTypeManagerTest.assertTrue((String)"2.5", (boolean)assoc2.isAssociatedWith(this.changeCase("text.txt_assoc2builtin")));
        IContentTypeManagerTest.assertTrue((String)"2.6", (boolean)assoc2.isAssociatedWith(this.changeCase("text.txt_assoc2useradded")));
        IContentType[] selected = finder.findContentTypesFor(this.changeCase("text.txt"));
        IContentTypeManagerTest.assertEquals((String)"3.0", (int)2, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"3.1", (Object)assoc1, (Object)selected[1]);
        IContentTypeManagerTest.assertEquals((String)"3.2", (Object)text, (Object)selected[0]);
        selected = finder.findContentTypesFor(this.changeCase("text.txt_useradded"));
        IContentTypeManagerTest.assertEquals((String)"4.0", (int)2, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"4.1", (Object)assoc1, (Object)selected[1]);
        IContentTypeManagerTest.assertEquals((String)"4.2", (Object)text, (Object)selected[0]);
        selected = finder.findContentTypesFor(this.changeCase("text.txt_pluginadded"));
        IContentTypeManagerTest.assertEquals((String)"5.0", (int)2, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"5.1", (Object)assoc1, (Object)selected[1]);
        IContentTypeManagerTest.assertEquals((String)"5.2", (Object)text, (Object)selected[0]);
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc1pluginadded"));
        IContentTypeManagerTest.assertEquals((String)"6.0", (int)1, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"6.1", (Object)assoc1, (Object)selected[0]);
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc1useradded"));
        IContentTypeManagerTest.assertEquals((String)"7.0", (int)1, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"7.1", (Object)assoc1, (Object)selected[0]);
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc2pluginadded"));
        IContentTypeManagerTest.assertEquals((String)"8.0", (int)1, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"8.1", (Object)assoc2, (Object)selected[0]);
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc2useradded"));
        IContentTypeManagerTest.assertEquals((String)"9.0", (int)1, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"9.1", (Object)assoc2, (Object)selected[0]);
        selected = finder.findContentTypesFor(this.changeCase("text.txt_assoc2builtin"));
        IContentTypeManagerTest.assertEquals((String)"10.0", (int)1, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"10.1", (Object)assoc2, (Object)selected[0]);
    }

    public void testAssociations() throws CoreException {
        IContentType text = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        text.addFileSpec("txt_useradded", 8);
        IContentTypeManagerTest.assertTrue((String)"0.1", (boolean)text.isAssociatedWith(this.changeCase("text.txt")));
        IContentTypeManagerTest.assertTrue((String)"0.2", (boolean)text.isAssociatedWith(this.changeCase("text.txt_useradded")));
        IContentTypeManagerTest.assertTrue((String)"0.3", (boolean)text.isAssociatedWith(this.changeCase("text.txt_pluginadded")));
        Object[] providerDefinedExtensions = text.getFileSpecs(10);
        IContentTypeManagerTest.assertTrue((String)"1.0", (boolean)this.contains(providerDefinedExtensions, "txt"));
        IContentTypeManagerTest.assertTrue((String)"1.1", (!this.contains(providerDefinedExtensions, "txt_useradded") ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"1.2", (boolean)this.contains(providerDefinedExtensions, "txt_pluginadded"));
        Object[] textUserDefinedExtensions = text.getFileSpecs(9);
        IContentTypeManagerTest.assertTrue((String)"2.0", (!this.contains(textUserDefinedExtensions, "txt") ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"2.1", (boolean)this.contains(textUserDefinedExtensions, "txt_useradded"));
        IContentTypeManagerTest.assertTrue((String)"2.2", (!this.contains(textUserDefinedExtensions, "txt_pluginadded") ? 1 : 0) != 0);
        text.removeFileSpec("txt", 8);
        IContentTypeManagerTest.assertTrue((String)"3.0", (boolean)this.contains(text.getFileSpecs(10), "txt"));
        IContentTypeManagerTest.assertTrue((String)"3.1", (boolean)text.isAssociatedWith(this.changeCase("text.txt")));
        IContentTypeManagerTest.assertTrue((String)"3.2", (boolean)text.isAssociatedWith(this.changeCase("text.txt_useradded")));
        IContentTypeManagerTest.assertTrue((String)"3.3", (boolean)text.isAssociatedWith(this.changeCase("text.txt_pluginadded")));
        text.removeFileSpec("txt_useradded", 8);
        IContentTypeManagerTest.assertTrue((String)"4.0", (!this.contains(text.getFileSpecs(9), "ini") ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"4.1", (boolean)text.isAssociatedWith(this.changeCase("text.txt")));
        IContentTypeManagerTest.assertTrue((String)"4.2", (!text.isAssociatedWith(this.changeCase("text.txt_useradded")) ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"4.3", (boolean)text.isAssociatedWith(this.changeCase("text.txt_pluginadded")));
    }

    public void testBinaryTypes() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType sampleBinary1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary1");
        IContentType sampleBinary2 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary2");
        InputStream contents = this.getInputStream(new byte[][]{SAMPLE_BIN1_OFFSET.getBytes(), SAMPLE_BIN1_SIGNATURE, " extra contents".getBytes()});
        IContentDescription description = contentTypeManager.getDescriptionFor(contents, null, IContentDescription.ALL);
        IContentTypeManagerTest.assertNotNull((String)"6.0", (Object)description);
        IContentTypeManagerTest.assertEquals((String)"6.1", (Object)sampleBinary1, (Object)description.getContentType());
        contents = this.getInputStream(new byte[][]{SAMPLE_BIN2_OFFSET.getBytes(), SAMPLE_BIN2_SIGNATURE, " extra contents".getBytes()});
        description = contentTypeManager.getDescriptionFor(contents, null, IContentDescription.ALL);
        IContentTypeManagerTest.assertNotNull((String)"7.0", (Object)description);
        IContentTypeManagerTest.assertEquals((String)"7.1", (Object)sampleBinary2, (Object)description.getContentType());
        IContentType[] selected = contentTypeManager.findContentTypesFor("test.samplebin2");
        IContentTypeManagerTest.assertEquals((String)"8.1", (int)1, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"8.2", (String)sampleBinary2.getId(), (String)selected[0].getId());
        description = contentTypeManager.getDescriptionFor(this.getReader(this.getRandomString()), "test.samplebin2", IContentDescription.ALL);
        IContentTypeManagerTest.assertNull((String)"8.3", (Object)description);
    }

    public void testByteOrderMark() throws IOException {
        IContentType text = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        QualifiedName[] options = new QualifiedName[]{IContentDescription.BYTE_ORDER_MARK};
        String UTF8_BOM = new String(IContentDescription.BOM_UTF_8, StandardCharsets.ISO_8859_1);
        IContentDescription description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((String.valueOf(UTF8_BOM) + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)IContentDescription.BOM_UTF_8, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF16_LE_BOM = new String(IContentDescription.BOM_UTF_16LE, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((String.valueOf(UTF16_LE_BOM) + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNotNull((String)"2.0", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        IContentTypeManagerTest.assertEquals((String)"2.1", (Object)IContentDescription.BOM_UTF_16LE, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF16_BE_BOM = new String(IContentDescription.BOM_UTF_16BE, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((String.valueOf(UTF16_BE_BOM) + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNotNull((String)"3.0", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        IContentTypeManagerTest.assertEquals((String)"3.1", (Object)IContentDescription.BOM_UTF_16BE, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(MINIMAL_XML.getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNull((String)"4.0", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF16_BE_BOM_1byte = new String(new byte[]{-2}, "ISO-8859-1");
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((String.valueOf(UTF16_BE_BOM_1byte) + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNull((String)"5.0", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(UTF16_BE_BOM_1byte.getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNull((String)"5.1", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF16_LE_BOM_1byte = new String(new byte[]{-1}, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((String.valueOf(UTF16_LE_BOM_1byte) + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNull((String)"6.0", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(UTF16_LE_BOM_1byte.getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNull((String)"6.1", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF8_BOM_1byte = new String(new byte[]{-17}, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((String.valueOf(UTF8_BOM_1byte) + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNull((String)"7.0", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(UTF8_BOM_1byte.getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNull((String)"7.1", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        String UTF8_BOM_2bytes = new String(new byte[]{-17, -69}, StandardCharsets.ISO_8859_1);
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream((String.valueOf(UTF8_BOM_2bytes) + MINIMAL_XML).getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNull((String)"8.0", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = text.getDescriptionFor((InputStream)new ByteArrayInputStream(UTF8_BOM_2bytes.getBytes(StandardCharsets.ISO_8859_1)), options);
        IContentTypeManagerTest.assertNull((String)"8.1", (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
    }

    public void testContentAndNameMatching() throws IOException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        byte[][] contents0 = new byte[][]{{10, 11, 14, 16}};
        byte[][] contents1 = new byte[][]{{10, 11, 12, 16}};
        byte[][] contents2 = new byte[][]{{10, 11, 13, 16}};
        byte[][] invalidContents = new byte[][]{new byte[4]};
        IContentType base = manager.getContentType("org.eclipse.core.tests.resources.binary_base");
        IContentType derived1 = manager.getContentType("org.eclipse.core.tests.resources.binary_derived1");
        IContentType derived2 = manager.getContentType("org.eclipse.core.tests.resources.binary_derived2");
        IContentType[] selected = manager.findContentTypesFor(this.getInputStream(contents0), "anything.mybinary");
        IContentTypeManagerTest.assertEquals((String)"1.0", (int)3, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)base, (Object)selected[0]);
        selected = manager.findContentTypesFor(this.getInputStream(contents0), "foo.mybinary");
        IContentTypeManagerTest.assertEquals((String)"2.0", (int)3, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"2.1", (Object)base, (Object)selected[0]);
        IContentTypeManagerTest.assertEquals((String)"2.2", (Object)derived1, (Object)selected[1]);
        selected = manager.findContentTypesFor(this.getInputStream(contents1), "foo.mybinary");
        IContentTypeManagerTest.assertEquals((String)"3.0", (int)3, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"3.1", (Object)derived1, (Object)selected[0]);
        IContentTypeManagerTest.assertEquals((String)"3.2", (Object)base, (Object)selected[1]);
        selected = manager.findContentTypesFor(this.getInputStream(contents2), "foo.mybinary");
        IContentTypeManagerTest.assertEquals((String)"4.0", (int)3, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"4.1", (Object)derived2, (Object)selected[0]);
        IContentTypeManagerTest.assertEquals((String)"4.2", (Object)base, (Object)selected[1]);
        selected = manager.findContentTypesFor(this.getInputStream(invalidContents), "foo.mybinary");
        IContentTypeManagerTest.assertEquals((String)"5.0", (int)3, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"5.1", (Object)derived1, (Object)selected[0]);
        IContentTypeManagerTest.assertEquals((String)"5.2", (Object)base, (Object)selected[1]);
        selected = manager.findContentTypesFor(this.getInputStream(invalidContents), "anything.mybinary");
        IContentTypeManagerTest.assertEquals((String)"6.0", (int)3, (int)selected.length);
        IContentTypeManagerTest.assertEquals((String)"6.1", (Object)base, (Object)selected[0]);
    }

    public void testContentDescription() throws IOException, CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType xmlType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType mytext = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext");
        IContentType mytext1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext1");
        IContentType mytext2 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext2");
        boolean text = false;
        int i = 0;
        while (i < 2) {
            String sufix = text ? "-text" : "-binary";
            IContentDescription description = this.getDescriptionFor(finder, MINIMAL_XML, StandardCharsets.UTF_8, "foo.xml", IContentDescription.ALL, text);
            IContentTypeManagerTest.assertNotNull((String)("1.0" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("1.1" + sufix), (Object)xmlType, (Object)description.getContentType());
            IContentTypeManagerTest.assertSame((String)"1.2", (Object)xmlType.getDefaultDescription(), (Object)description);
            description = this.getDescriptionFor(finder, MINIMAL_XML, StandardCharsets.UTF_8, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
            IContentTypeManagerTest.assertNotNull((String)("2.0" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("2.1" + sufix), (Object)xmlType, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("2.2" + sufix), (Object)"UTF-8", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertSame((String)"2.3", (Object)xmlType.getDefaultDescription(), (Object)description);
            description = this.getDescriptionFor(finder, XML_ISO_8859_1, StandardCharsets.ISO_8859_1, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
            IContentTypeManagerTest.assertNotNull((String)("2.3a" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("2.3b" + sufix), (Object)xmlType, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("2.3c" + sufix), (Object)"ISO-8859-1", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertNotSame((String)"2.3d", (Object)xmlType.getDefaultDescription(), (Object)description);
            description = this.getDescriptionFor(finder, XML_ISO_8859_1_SINGLE_QUOTES, StandardCharsets.ISO_8859_1, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
            IContentTypeManagerTest.assertNotNull((String)("2.3e" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("2.3f" + sufix), (Object)xmlType, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("2.3g" + sufix), (Object)"ISO-8859-1", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertNotSame((String)"2.3h", (Object)xmlType.getDefaultDescription(), (Object)description);
            description = this.getDescriptionFor(finder, XML_UTF_16, StandardCharsets.UTF_16, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK}, text);
            IContentTypeManagerTest.assertNotNull((String)("2.4a" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("2.4b" + sufix), (Object)xmlType, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("2.4c" + sufix), (Object)"UTF-16", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertTrue((String)("2.4d" + sufix), (text || IContentDescription.BOM_UTF_16BE == description.getProperty(IContentDescription.BYTE_ORDER_MARK) ? 1 : 0) != 0);
            IContentTypeManagerTest.assertNotSame((String)"2.4e", (Object)xmlType.getDefaultDescription(), (Object)description);
            description = this.getDescriptionFor(finder, XML_UTF_16BE, StandardCharsets.UTF_8, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
            IContentTypeManagerTest.assertNotNull((String)("2.5a" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("2.5b" + sufix), (Object)xmlType, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("2.5c" + sufix), (Object)"UTF-16BE", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertNotSame((String)"2.5d", (Object)xmlType.getDefaultDescription(), (Object)description);
            description = this.getDescriptionFor(finder, XML_UTF_16LE, StandardCharsets.UTF_8, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
            IContentTypeManagerTest.assertNotNull((String)("2.6a" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("2.6b" + sufix), (Object)xmlType, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("2.6c" + sufix), (Object)"UTF-16LE", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertNotSame((String)"2.6d", (Object)xmlType.getDefaultDescription(), (Object)description);
            description = this.getDescriptionFor(finder, MINIMAL_XML, StandardCharsets.UTF_8, "foo.xml", IContentDescription.ALL, text);
            IContentTypeManagerTest.assertNotNull((String)("4.0" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("4.1" + sufix), (Object)xmlType, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("4.2" + sufix), (Object)"UTF-8", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertNotNull((String)("5.0" + sufix), (Object)mytext);
            IContentTypeManagerTest.assertEquals((String)("5.0b" + sufix), (String)"BAR", (String)mytext.getDefaultCharset());
            IContentTypeManagerTest.assertSame((String)"5.0c", (Object)xmlType.getDefaultDescription(), (Object)description);
            description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt", IContentDescription.ALL, text);
            IContentTypeManagerTest.assertNotNull((String)("5.1" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("5.2" + sufix), (Object)mytext, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("5.3" + sufix), (Object)"BAR", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertSame((String)"5.4", (Object)mytext.getDefaultDescription(), (Object)description);
            mytext.setDefaultCharset("FOO");
            description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt", IContentDescription.ALL, text);
            IContentTypeManagerTest.assertNotNull((String)("5.5" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("5.6" + sufix), (Object)mytext, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("5.7" + sufix), (Object)"FOO", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertSame((String)"5.8", (Object)mytext.getDefaultDescription(), (Object)description);
            mytext.setDefaultCharset(null);
            description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt", IContentDescription.ALL, text);
            IContentTypeManagerTest.assertNotNull((String)("5.10" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("5.11" + sufix), (Object)mytext, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("5.12" + sufix), (Object)"BAR", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertSame((String)"5.13", (Object)mytext.getDefaultDescription(), (Object)description);
            description = this.getDescriptionFor(finder, "<?xml version='1.0' encoding='UTF-8'?><soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:tns=\"http://www.example.org/\" xmlns:ns0=\"http://another.example.org/\"><soapenv:Header /><soapenv:Body><ns0:x /></soapenv:Body></soapenv:Envelope>", StandardCharsets.UTF_8, "foo.xml", new QualifiedName[]{IContentDescription.CHARSET}, text);
            IContentTypeManagerTest.assertNotNull((String)("5.14" + sufix), (Object)description);
            IContentTypeManagerTest.assertEquals((String)("5.15" + sufix), (Object)xmlType, (Object)description.getContentType());
            IContentTypeManagerTest.assertEquals((String)("5.16" + sufix), (Object)"UTF-8", (Object)description.getProperty(IContentDescription.CHARSET));
            IContentTypeManagerTest.assertEquals((String)"5.17", (String)xmlType.getDefaultDescription().getCharset(), (String)description.getCharset());
            ++i;
            boolean bl = text = !text;
        }
        IContentTypeManagerTest.assertNotNull((String)"6.0", (Object)mytext1);
        IContentTypeManagerTest.assertEquals((String)"6.1", (String)"BAR", (String)mytext1.getDefaultCharset());
        IContentTypeManagerTest.assertNotNull((String)"6.2", (Object)mytext2);
        IContentTypeManagerTest.assertEquals((String)"6.3", null, (String)mytext2.getDefaultCharset());
    }

    public void testContentDetection() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType inappropriate = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary1");
        IContentType appropriate = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType appropriateSpecific1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-different-extension");
        IContentType appropriateSpecific1LowPriority = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-different-extension-low-priority");
        IContentType appropriateSpecific2 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-specific-name");
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate}), null);
        IContentTypeManagerTest.assertNull((String)"1.0", (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate, appropriate}), null);
        IContentTypeManagerTest.assertEquals((String)"2.0", (Object)appropriate, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate, appropriate, appropriateSpecific1}), null);
        IContentTypeManagerTest.assertEquals((String)"3.0", (Object)appropriateSpecific1, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate, appropriate, appropriateSpecific2}), null);
        IContentTypeManagerTest.assertEquals((String)"3.1", (Object)appropriateSpecific2, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{inappropriate, appropriate, appropriateSpecific1, appropriateSpecific2}), null);
        IContentType[] selected = finder.findContentTypesFor(this.getInputStream(MINIMAL_XML), null);
        IContentTypeManagerTest.assertEquals((String)"4.0", (int)3, (int)selected.length);
        IContentTypeManagerTest.assertTrue((String)"4.1", (appropriateSpecific1.equals(selected[0]) || appropriateSpecific1.equals(selected[1]) ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"4.2", (appropriateSpecific2.equals(selected[0]) || appropriateSpecific2.equals(selected[1]) ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"4.3", (boolean)appropriate.equals(selected[2]));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{appropriate, appropriateSpecific1LowPriority}), null);
        IContentTypeManagerTest.assertEquals((String)"5.0", (Object)appropriateSpecific1LowPriority, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
        finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new SubsetSelectionPolicy(new IContentType[]{appropriate, appropriateSpecific1, appropriateSpecific1LowPriority}), null);
        IContentTypeManagerTest.assertEquals((String)"5.1", (Object)appropriateSpecific1, (Object)finder.findContentTypeFor(this.getInputStream(MINIMAL_XML), null));
    }

    public void testDefaultProperties() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType mytext = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext");
        IContentType mytext1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext1");
        IContentType mytext2 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext2");
        IContentTypeManagerTest.assertNotNull((String)"0.1", (Object)mytext);
        IContentTypeManagerTest.assertNotNull((String)"0.2", (Object)mytext1);
        IContentTypeManagerTest.assertNotNull((String)"0.3", (Object)mytext2);
        QualifiedName charset = IContentDescription.CHARSET;
        QualifiedName localCharset = new QualifiedName("org.eclipse.core.tests.resources", "charset");
        QualifiedName property1 = new QualifiedName("org.eclipse.core.tests.resources", "property1");
        QualifiedName property2 = new QualifiedName("org.eclipse.core.tests.resources", "property2");
        QualifiedName property3 = new QualifiedName("org.eclipse.core.tests.resources", "property3");
        QualifiedName property4 = new QualifiedName("org.eclipse.core.tests.resources", "property4");
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentDescription description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt", IContentDescription.ALL, true);
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)description);
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)mytext, (Object)description.getContentType());
        IContentTypeManagerTest.assertEquals((String)"1.2", (Object)"value1", (Object)description.getProperty(property1));
        IContentTypeManagerTest.assertNull((String)"1.3", (Object)description.getProperty(property2));
        IContentTypeManagerTest.assertEquals((String)"1.4", (Object)"value3", (Object)description.getProperty(property3));
        IContentTypeManagerTest.assertEquals((String)"1.5", (Object)"BAR", (Object)description.getProperty(charset));
        description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt1", IContentDescription.ALL, true);
        IContentTypeManagerTest.assertNotNull((String)"2.0", (Object)description);
        IContentTypeManagerTest.assertEquals((String)"2.1", (Object)mytext1, (Object)description.getContentType());
        IContentTypeManagerTest.assertEquals((String)"2.2", (Object)"value1", (Object)description.getProperty(property1));
        IContentTypeManagerTest.assertEquals((String)"2.3", (Object)"value2", (Object)description.getProperty(property2));
        IContentTypeManagerTest.assertNull((String)"2.4", (Object)description.getProperty(property3));
        IContentTypeManagerTest.assertEquals((String)"2.5", (Object)"value4", (Object)description.getProperty(property4));
        IContentTypeManagerTest.assertEquals((String)"2.6", (Object)"BAR", (Object)description.getProperty(charset));
        description = this.getDescriptionFor(finder, "some contents", null, "abc.tzt2", IContentDescription.ALL, true);
        IContentTypeManagerTest.assertNotNull((String)"3.0", (Object)description);
        IContentTypeManagerTest.assertEquals((String)"3.1", (Object)mytext2, (Object)description.getContentType());
        IContentTypeManagerTest.assertNull((String)"3.2", (Object)description.getProperty(property1));
        IContentTypeManagerTest.assertNull((String)"3.3", (Object)description.getProperty(property2));
        IContentTypeManagerTest.assertNull((String)"3.4", (Object)description.getProperty(property3));
        IContentTypeManagerTest.assertNull((String)"3.5", (Object)description.getProperty(property4));
        IContentTypeManagerTest.assertNull((String)"3.6", (Object)description.getProperty(charset));
        IContentTypeManagerTest.assertEquals((String)"3.7", (Object)"mytext2", (Object)description.getProperty(localCharset));
    }

    public void testDoubleAssociation() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType fooBarType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.fooBar");
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)fooBarType);
        IContentType subFooBarType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.subFooBar");
        IContentTypeManagerTest.assertNotNull((String)"1.1", (Object)subFooBarType);
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        Object[] fooBarAssociated = finder.findContentTypesFor(this.changeCase("foo.bar"));
        IContentTypeManagerTest.assertEquals((String)"2.1", (int)2, (int)fooBarAssociated.length);
        IContentTypeManagerTest.assertTrue((String)"2.2", (boolean)this.contains(fooBarAssociated, fooBarType));
        IContentTypeManagerTest.assertTrue((String)"2.3", (boolean)this.contains(fooBarAssociated, subFooBarType));
    }

    public void testDynamicChanges() {
        IContentType[] text = new IContentType[4];
        IContentTypeManager manager = Platform.getContentTypeManager();
        text[0] = manager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)text[0]);
        text[1] = manager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeManagerTest.assertNotNull((String)"1.1", (Object)text[1]);
        text[0] = ((ContentTypeHandler)text[0]).getTarget();
        text[1] = ((ContentTypeHandler)text[1]).getTarget();
        IContentTypeManagerTest.assertEquals((String)"2.0", (Object)text[0], (Object)text[1]);
        IContentTypeManagerTest.assertTrue((String)"2.1", (text[0] == text[1] ? 1 : 0) != 0);
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles((String)"3", () -> {
            IContentType missing = manager.getContentType("org.eclipse.bundle01.missing");
            IContentTypeManagerTest.assertNotNull((String)"3.1", (Object)missing);
            iContentTypeArray[2] = manager.getContentType("org.eclipse.core.runtime.text");
            IContentTypeManagerTest.assertNotNull((String)"3.2", (Object)text[2]);
            iContentTypeArray[2] = ((ContentTypeHandler)text[2]).getTarget();
            IContentTypeManagerTest.assertEquals((String)"3.3", (Object)text[0], (Object)text[2]);
            IContentTypeManagerTest.assertTrue((String)"3.4", (text[0] != text[2] ? 1 : 0) != 0);
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle01"}, (TestRegistryChangeListener)listener);
        IContentTypeManagerTest.assertNull((String)"4.0", (Object)manager.getContentType("org.eclipse.bundle01.missing"));
        text[3] = manager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeManagerTest.assertNotNull((String)"5.0", (Object)text[3]);
        text[3] = ((ContentTypeHandler)text[3]).getTarget();
        IContentTypeManagerTest.assertEquals((String)"5.1", (Object)text[0], (Object)text[3]);
        IContentTypeManagerTest.assertEquals((String)"5.2", (Object)text[2], (Object)text[3]);
        IContentTypeManagerTest.assertTrue((String)"5.3", (text[0] != text[3] ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"5.4", (text[2] != text[3] ? 1 : 0) != 0);
    }

    public void testDynamicChangesNewExtension() {
        IContentType[] text = new IContentType[4];
        IContentTypeManager manager = Platform.getContentTypeManager();
        text[0] = manager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)text[0]);
        text[1] = manager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeManagerTest.assertNotNull((String)"1.1", (Object)text[1]);
        text[0] = ((ContentTypeHandler)text[0]).getTarget();
        text[1] = ((ContentTypeHandler)text[1]).getTarget();
        IContentTypeManagerTest.assertEquals((String)"2.0", (Object)text[0], (Object)text[1]);
        IContentTypeManagerTest.assertTrue((String)"2.1", (text[0] == text[1] ? 1 : 0) != 0);
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.contenttype", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles((String)"3", () -> {
            IContentType contentType = manager.getContentType("org.eclipse.bug485227.bug485227_contentType");
            IContentTypeManagerTest.assertNotNull((String)"3.1 Contributed content type not found", (Object)contentType);
            iContentTypeArray[2] = manager.getContentType("org.eclipse.core.runtime.text");
            IContentTypeManagerTest.assertNotNull((String)"3.2 Text content type not modified", (Object)text[2]);
            iContentTypeArray[2] = ((ContentTypeHandler)text[2]).getTarget();
            IContentTypeManagerTest.assertEquals((String)"3.3", (Object)text[0], (Object)text[2]);
            IContentTypeManagerTest.assertTrue((String)"3.4", (text[0] != text[2] ? 1 : 0) != 0);
            IContentTypeManagerTest.assertEquals((String)"3.5 default extension not associated", (Object)contentType, (Object)manager.findContentTypeFor("file.bug485227"));
            IContentTypeManagerTest.assertEquals((String)"3.6 additional extension not associated", (Object)contentType, (Object)manager.findContentTypeFor("file.bug485227_2"));
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bug485227"}, (TestRegistryChangeListener)listener);
        IContentTypeManagerTest.assertNull((String)"4.0 Content type not cleared after bundle uninstall", (Object)manager.getContentType("org.eclipse.bug485227.bug485227_contentType"));
        text[3] = manager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeManagerTest.assertNotNull((String)"5.0", (Object)text[3]);
        text[3] = ((ContentTypeHandler)text[3]).getTarget();
        IContentTypeManagerTest.assertEquals((String)"5.1", (Object)text[0], (Object)text[3]);
        IContentTypeManagerTest.assertEquals((String)"5.2", (Object)text[2], (Object)text[3]);
        IContentTypeManagerTest.assertTrue((String)"5.3", (text[0] != text[3] ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"5.4", (text[2] != text[3] ? 1 : 0) != 0);
    }

    public void testEvents() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType myType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.myContent");
        IContentTypeManagerTest.assertNotNull((String)"0.9", (Object)myType);
        ContentTypeChangeTracer tracer = new ContentTypeChangeTracer();
        contentTypeManager.addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)tracer);
        try {
            myType.addFileSpec("another.file.name", 4);
        }
        catch (CoreException e) {
            IContentTypeManagerTest.fail((String)"1.0", (Throwable)e);
        }
        IContentTypeManagerTest.assertTrue((String)"1.1", (boolean)tracer.isOnlyChange(myType));
        tracer.reset();
        try {
            myType.removeFileSpec("another.file.name", 8);
        }
        catch (CoreException e) {
            IContentTypeManagerTest.fail((String)"2.0", (Throwable)e);
        }
        IContentTypeManagerTest.assertTrue((String)"2.1", (!tracer.isOnlyChange(myType) ? 1 : 0) != 0);
        tracer.reset();
        try {
            myType.addFileSpec("another.file.name", 4);
        }
        catch (CoreException e) {
            IContentTypeManagerTest.fail((String)"3.0", (Throwable)e);
        }
        IContentTypeManagerTest.assertTrue((String)"3.1", (!tracer.isOnlyChange(myType) ? 1 : 0) != 0);
        tracer.reset();
        try {
            myType.removeFileSpec("another.file.name", 4);
        }
        catch (CoreException e) {
            IContentTypeManagerTest.fail((String)"4.0", (Throwable)e);
        }
        IContentTypeManagerTest.assertTrue((String)"4.1", (boolean)tracer.isOnlyChange(myType));
        tracer.reset();
        try {
            myType.setDefaultCharset("FOO");
        }
        catch (CoreException e) {
            IContentTypeManagerTest.fail((String)"5.0", (Throwable)e);
        }
        IContentTypeManagerTest.assertTrue((String)"5.1", (boolean)tracer.isOnlyChange(myType));
        tracer.reset();
        try {
            myType.setDefaultCharset("FOO");
        }
        catch (CoreException e) {
            IContentTypeManagerTest.fail((String)"6.0", (Throwable)e);
        }
        IContentTypeManagerTest.assertTrue((String)"6.1", (!tracer.isOnlyChange(myType) ? 1 : 0) != 0);
        try {
            myType.setDefaultCharset("ABC");
        }
        catch (CoreException e1) {
            IContentTypeManagerTest.fail((String)"7.0", (Throwable)e1);
        }
    }

    public void testFileSpecConflicts() {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType conflict1a = manager.getContentType("org.eclipse.core.tests.resources.base_conflict1");
        IContentType conflict1b = manager.getContentType("org.eclipse.core.tests.resources.sub_conflict1");
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)conflict1a);
        IContentTypeManagerTest.assertNotNull((String)"1.1", (Object)conflict1b);
        IContentType preferredConflict1 = manager.findContentTypeFor("test.conflict1");
        IContentTypeManagerTest.assertNotNull((String)"1.2", (Object)preferredConflict1);
        IContentTypeManagerTest.assertEquals((String)"1.3", (Object)conflict1a, (Object)preferredConflict1);
        IContentType conflict2base = manager.getContentType("org.eclipse.core.tests.resources.base_conflict2");
        IContentType conflict2sub = manager.getContentType("org.eclipse.core.tests.resources.sub_conflict2");
        IContentTypeManagerTest.assertNotNull((String)"2.0", (Object)conflict2base);
        IContentTypeManagerTest.assertNotNull((String)"2.1", (Object)conflict2sub);
        try {
            IContentType[] selectedConflict2 = manager.findContentTypesFor(this.getRandomContents(), "test.conflict2");
            IContentTypeManagerTest.assertEquals((String)"2.2", (int)2, (int)selectedConflict2.length);
            IContentTypeManagerTest.assertEquals((String)"2.3", (Object)selectedConflict2[0], (Object)conflict2base);
            IContentTypeManagerTest.assertEquals((String)"2.4", (Object)selectedConflict2[1], (Object)conflict2sub);
        }
        catch (IOException e) {
            IContentTypeManagerTest.fail((String)"2.5", (Throwable)e);
        }
        IContentType conflict3base = manager.getContentType("org.eclipse.core.tests.resources.base_conflict3");
        IContentType conflict3sub = manager.getContentType("org.eclipse.core.tests.resources.sub_conflict3");
        IContentType conflict3unrelated = manager.getContentType("org.eclipse.core.tests.resources.unrelated_conflict3");
        IContentTypeManagerTest.assertNotNull((String)"3.0.1", (Object)conflict3base);
        IContentTypeManagerTest.assertNotNull((String)"3.0.2", (Object)conflict3sub);
        IContentTypeManagerTest.assertNotNull((String)"3.0.3", (Object)conflict3unrelated);
        try {
            IContentType[] selectedConflict3 = manager.findContentTypesFor(this.getRandomContents(), "test.conflict3");
            IContentTypeManagerTest.assertEquals((String)"4.0", (int)2, (int)selectedConflict3.length);
            IContentTypeManagerTest.assertEquals((String)"4.1", (Object)selectedConflict3[0], (Object)conflict3unrelated);
            IContentTypeManagerTest.assertEquals((String)"4.2", (Object)selectedConflict3[1], (Object)conflict3sub);
        }
        catch (IOException e) {
            IContentTypeManagerTest.fail((String)"4.3", (Throwable)e);
        }
    }

    public void testFindContentType() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType xmlContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType single = finder.findContentTypeFor(this.getInputStream("Just a test"), this.changeCase("file.txt"));
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)single);
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)textContentType, (Object)single);
        single = finder.findContentTypeFor(this.getInputStream(XML_UTF_8, StandardCharsets.UTF_8), this.changeCase("foo.xml"));
        IContentTypeManagerTest.assertNotNull((String)"2.0", (Object)single);
        IContentTypeManagerTest.assertEquals((String)"2.1", (Object)xmlContentType, (Object)single);
        Object[] multiple = finder.findContentTypesFor(this.getInputStream(XML_UTF_8, StandardCharsets.UTF_8), null);
        IContentTypeManagerTest.assertTrue((String)"3.0", (boolean)this.contains(multiple, xmlContentType));
    }

    public void testFindContentTypPredefinedRegexp() throws IOException, CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType targetContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.predefinedContentTypeWithRegexp");
        IContentTypeManagerTest.assertNotNull((String)"Target content-type not found", (Object)targetContentType);
        IContentType single = finder.findContentTypeFor(this.getInputStream("Just a test"), "somepredefinedContentTypeWithRegexpFile");
        IContentTypeManagerTest.assertEquals((Object)targetContentType, (Object)single);
        single = finder.findContentTypeFor(this.getInputStream("Just a test"), "somepredefinedContentTypeWithPatternFile");
        IContentTypeManagerTest.assertEquals((Object)targetContentType, (Object)single);
        single = finder.findContentTypeFor(this.getInputStream("Just a test"), "somepredefinedContentTypeWithWildcardsFile");
        IContentTypeManagerTest.assertEquals((Object)targetContentType, (Object)single);
    }

    public void testFindContentTypeUserRegexp() throws IOException, CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType single = finder.findContentTypeFor(this.getInputStream("Just a test"), "someText.unknown");
        IContentTypeManagerTest.assertNull((String)"File pattern unknown at that point", (Object)single);
        textContentType.addFileSpec("*Text*", 16);
        single = finder.findContentTypeFor(this.getInputStream("Just a test"), "someText.unknown");
        IContentTypeManagerTest.assertEquals((String)"Text content should now match *Text* files", (Object)textContentType, (Object)single);
    }

    public void testImportFileAssociation() throws CoreException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeManagerTest.assertNull((Object)contentTypeManager.findContentTypeFor("*.bug122217"));
        IPreferencesService service = Platform.getPreferencesService();
        String prefs = "file_export_version=3.0\n/instance/org.eclipse.core.runtime/content-types/org.eclipse.core.runtime.xml/file-extensions=bug122217";
        IExportedPreferences exported = service.readPreferences((InputStream)new ByteArrayInputStream(prefs.getBytes()));
        IContentTypeManagerTest.assertTrue((boolean)service.applyPreferences(exported).isOK());
        IContentTypeManagerTest.assertNotNull((Object)contentTypeManager.findContentTypeFor("*.bug122217"));
    }

    public void testInvalidMarkup() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentTypeManagerTest.assertEquals((String)"1.0", (int)0, (int)finder.findContentTypesFor("invalid.missing.identifier").length);
        IContentTypeManagerTest.assertEquals((String)"2.0", (int)0, (int)finder.findContentTypesFor("invalid.missing.name").length);
        IContentTypeManagerTest.assertNull((String)"3.0", (Object)contentTypeManager.getContentType("org.eclipse.core.tests.resources.invalid-missing-name"));
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles((String)"1", () -> {
            IContentTypeManagerTest.assertEquals((String)"1.2", (int)0, (int)contentTypeManager.findContentTypesFor("invalid.missing.identifier").length);
            IContentTypeManagerTest.assertEquals((String)"1.3", (int)0, (int)contentTypeManager.findContentTypesFor("invalid.missing.name").length);
            IContentTypeManagerTest.assertNull((String)"1.4", (Object)contentTypeManager.getContentType("org.eclipse.bundle03.invalid-missing-name"));
            IContentType invalidDescriber = contentTypeManager.getContentType("org.eclipse.bundle03.invalid-describer");
            IContentTypeManagerTest.assertNotNull((String)"1.5", (Object)invalidDescriber);
            IContentTypeManagerTest.assertEquals((String)"1.6", (Object)invalidDescriber, (Object)contentTypeManager.findContentTypeFor("invalid.describer"));
            try {
                IContentTypeManagerTest.assertNull((String)"1.7", (Object)contentTypeManager.findContentTypeFor(this.getRandomContents(), "invalid.describer"));
            }
            catch (IOException e) {
                IContentTypeManagerTest.fail((String)"1.8", (Throwable)e);
            }
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle03"}, (TestRegistryChangeListener)listener);
    }

    public void testIOException() {
        class FakeIOException
        extends IOException {
            private static final long serialVersionUID = 1L;

            FakeIOException() {
            }

            @Override
            public String getMessage() {
                return "This exception was thrown for testing purposes";
            }
        }
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType xml = manager.getContentType("org.eclipse.core.runtime.xml");
        IContentType rootElement = manager.getContentType("org.eclipse.core.tests.resources.root-element");
        Object[] selected = null;
        try {
            selected = manager.findContentTypesFor(this.getInputStream(XML_US_ASCII_INVALID, StandardCharsets.ISO_8859_1), "test.xml");
        }
        catch (IOException ioe) {
            IContentTypeManagerTest.fail((String)"1.0", (Throwable)ioe);
        }
        IContentTypeManagerTest.assertTrue((String)"1.1", (boolean)this.contains(selected, xml));
        IContentTypeManagerTest.assertTrue((String)"1.2", (boolean)this.contains(selected, rootElement));
        try {
            selected = manager.findContentTypesFor(new InputStream(){

                @Override
                public int available() {
                    return Integer.MAX_VALUE;
                }

                @Override
                public int read() throws IOException {
                    throw new FakeIOException();
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    throw new FakeIOException();
                }
            }, "test.xml");
            IContentTypeManagerTest.fail((String)"2.0");
        }
        catch (FakeIOException fakeIOException) {
        }
        catch (IOException iOException) {
            IContentTypeManagerTest.fail((String)"2.1");
        }
    }

    public void testIsKindOf() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentType xmlContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType xmlBasedDifferentExtensionContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-different-extension");
        IContentType xmlBasedSpecificNameContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-specific-name");
        IContentType binaryContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary1");
        IContentTypeManagerTest.assertTrue((String)"1.0", (boolean)textContentType.isKindOf(textContentType));
        IContentTypeManagerTest.assertTrue((String)"2.0", (boolean)xmlContentType.isKindOf(textContentType));
        IContentTypeManagerTest.assertTrue((String)"2.1", (!textContentType.isKindOf(xmlContentType) ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"2.2", (boolean)xmlContentType.isKindOf(xmlContentType));
        IContentTypeManagerTest.assertTrue((String)"3.0", (boolean)xmlBasedDifferentExtensionContentType.isKindOf(textContentType));
        IContentTypeManagerTest.assertTrue((String)"3.1", (boolean)xmlBasedDifferentExtensionContentType.isKindOf(xmlContentType));
        IContentTypeManagerTest.assertTrue((String)"4.0", (!xmlBasedDifferentExtensionContentType.isKindOf(xmlBasedSpecificNameContentType) ? 1 : 0) != 0);
        IContentTypeManagerTest.assertTrue((String)"5.0", (!binaryContentType.isKindOf(textContentType) ? 1 : 0) != 0);
    }

    public void testListParsing() {
        String[] list = Util.parseItems(null);
        IContentTypeManagerTest.assertEquals((String)"0.0", (int)0, (int)list.length);
        list = Util.parseItems((String)SAMPLE_BIN2_OFFSET);
        IContentTypeManagerTest.assertEquals((String)"1.0", (int)1, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"1.1", (String)SAMPLE_BIN2_OFFSET, (String)list[0]);
        list = Util.parseItems((String)"foo");
        IContentTypeManagerTest.assertEquals((String)"2.0", (int)1, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"2.1", (String)"foo", (String)list[0]);
        list = Util.parseItems((String)",");
        IContentTypeManagerTest.assertEquals((String)"3.0", (int)2, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"3.1", (String)SAMPLE_BIN2_OFFSET, (String)list[0]);
        IContentTypeManagerTest.assertEquals((String)"3.2", (String)SAMPLE_BIN2_OFFSET, (String)list[1]);
        list = Util.parseItems((String)",foo,bar");
        IContentTypeManagerTest.assertEquals((String)"4.0", (int)3, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"4.1", (String)SAMPLE_BIN2_OFFSET, (String)list[0]);
        IContentTypeManagerTest.assertEquals((String)"4.2", (String)"foo", (String)list[1]);
        IContentTypeManagerTest.assertEquals((String)"4.3", (String)"bar", (String)list[2]);
        list = Util.parseItems((String)"foo,bar,");
        IContentTypeManagerTest.assertEquals((String)"5.0", (int)3, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"5.1", (String)"foo", (String)list[0]);
        IContentTypeManagerTest.assertEquals((String)"5.2", (String)"bar", (String)list[1]);
        IContentTypeManagerTest.assertEquals((String)"5.3", (String)SAMPLE_BIN2_OFFSET, (String)list[2]);
        list = Util.parseItems((String)"foo,,bar");
        IContentTypeManagerTest.assertEquals((String)"6.0", (int)3, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"6.1", (String)"foo", (String)list[0]);
        IContentTypeManagerTest.assertEquals((String)"6.2", (String)SAMPLE_BIN2_OFFSET, (String)list[1]);
        IContentTypeManagerTest.assertEquals((String)"6.3", (String)"bar", (String)list[2]);
        list = Util.parseItems((String)"foo,,,bar");
        IContentTypeManagerTest.assertEquals((String)"7.0", (int)4, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"7.1", (String)"foo", (String)list[0]);
        IContentTypeManagerTest.assertEquals((String)"7.2", (String)SAMPLE_BIN2_OFFSET, (String)list[1]);
        IContentTypeManagerTest.assertEquals((String)"7.3", (String)SAMPLE_BIN2_OFFSET, (String)list[2]);
        IContentTypeManagerTest.assertEquals((String)"7.4", (String)"bar", (String)list[3]);
        list = Util.parseItems((String)",,foo,bar");
        IContentTypeManagerTest.assertEquals((String)"8.0", (int)4, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"8.1", (String)SAMPLE_BIN2_OFFSET, (String)list[0]);
        IContentTypeManagerTest.assertEquals((String)"8.2", (String)SAMPLE_BIN2_OFFSET, (String)list[1]);
        IContentTypeManagerTest.assertEquals((String)"8.3", (String)"foo", (String)list[2]);
        IContentTypeManagerTest.assertEquals((String)"8.4", (String)"bar", (String)list[3]);
        list = Util.parseItems((String)"foo,bar,,");
        IContentTypeManagerTest.assertEquals((String)"9.0", (int)4, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"9.1", (String)"foo", (String)list[0]);
        IContentTypeManagerTest.assertEquals((String)"9.2", (String)"bar", (String)list[1]);
        IContentTypeManagerTest.assertEquals((String)"9.3", (String)SAMPLE_BIN2_OFFSET, (String)list[2]);
        IContentTypeManagerTest.assertEquals((String)"9.4", (String)SAMPLE_BIN2_OFFSET, (String)list[3]);
        list = Util.parseItems((String)",,,");
        IContentTypeManagerTest.assertEquals((String)"10.0", (int)4, (int)list.length);
        IContentTypeManagerTest.assertEquals((String)"10.1", (String)SAMPLE_BIN2_OFFSET, (String)list[0]);
        IContentTypeManagerTest.assertEquals((String)"10.2", (String)SAMPLE_BIN2_OFFSET, (String)list[1]);
        IContentTypeManagerTest.assertEquals((String)"10.3", (String)SAMPLE_BIN2_OFFSET, (String)list[2]);
        IContentTypeManagerTest.assertEquals((String)"10.4", (String)SAMPLE_BIN2_OFFSET, (String)list[3]);
    }

    public void testMyContentDescriber() throws IOException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType myContent = manager.getContentType("org.eclipse.core.tests.resources.myContent");
        IContentTypeManagerTest.assertNotNull((String)"0.5", (Object)myContent);
        IContentTypeManagerTest.assertEquals((String)"0.6", (Object)myContent, (Object)manager.findContentTypeFor("myContent.mc1"));
        IContentTypeManagerTest.assertEquals((String)"0.7", (Object)myContent, (Object)manager.findContentTypeFor("myContent.mc2"));
        IContentTypeManagerTest.assertEquals((String)"0.8", (Object)myContent, (Object)manager.findContentTypeFor("foo.myContent1"));
        IContentTypeManagerTest.assertEquals((String)"0.9", (Object)myContent, (Object)manager.findContentTypeFor("bar.myContent2"));
        IContentDescription description = manager.getDescriptionFor(this.getInputStream("MY_CONTENTS", StandardCharsets.US_ASCII), "myContent.mc1", IContentDescription.ALL);
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)description);
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)myContent, (Object)description.getContentType());
        IContentTypeManagerTest.assertNotSame((String)"1.2", (Object)myContent.getDefaultDescription(), (Object)description);
        int i = 0;
        while (i < MyContentDescriber.MY_OPTIONS.length) {
            IContentTypeManagerTest.assertEquals((String)("2." + i), (Object)MyContentDescriber.MY_OPTION_VALUES[i], (Object)description.getProperty(MyContentDescriber.MY_OPTIONS[i]));
            ++i;
        }
    }

    public void testNoExtensionAssociation() {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType[] selected = manager.findContentTypesFor("file_with_no_extension");
        IContentTypeManagerTest.assertEquals((String)"0.1", (int)0, (int)selected.length);
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles((String)"1", () -> {
            IContentType empty1 = manager.getContentType("org.eclipse.bundle04.empty_extension1");
            IContentType empty2 = manager.getContentType("org.eclipse.bundle04.empty_extension2");
            IContentType empty3 = manager.getContentType("org.eclipse.bundle04.empty_extension3");
            IContentType empty4 = manager.getContentType("org.eclipse.bundle04.empty_extension4");
            IContentType nonEmpty = manager.getContentType("org.eclipse.bundle04.non_empty_extension");
            IContentTypeManagerTest.assertNotNull((String)"1.1.1", (Object)empty1);
            IContentTypeManagerTest.assertNotNull((String)"1.1.2", (Object)empty2);
            IContentTypeManagerTest.assertNotNull((String)"1.1.3", (Object)empty3);
            IContentTypeManagerTest.assertNotNull((String)"1.1.4", (Object)empty4);
            IContentTypeManagerTest.assertNotNull((String)"1.1.5", (Object)nonEmpty);
            Object[] selected1 = manager.findContentTypesFor("file_with_no_extension");
            IContentTypeManagerTest.assertEquals((String)"1.2.0", (int)4, (int)selected1.length);
            IContentTypeManagerTest.assertTrue((String)"1.2.1", (boolean)this.contains(selected1, empty1));
            IContentTypeManagerTest.assertTrue((String)"1.2.2", (boolean)this.contains(selected1, empty2));
            IContentTypeManagerTest.assertTrue((String)"1.2.3", (boolean)this.contains(selected1, empty3));
            IContentTypeManagerTest.assertTrue((String)"1.2.4", (boolean)this.contains(selected1, empty4));
            selected1 = manager.findContentTypesFor("file_with_extension.non-empty");
            IContentTypeManagerTest.assertEquals((String)"1.2.5", (int)1, (int)selected1.length);
            IContentTypeManagerTest.assertTrue((String)"1.2.6", (boolean)this.contains(selected1, nonEmpty));
            try {
                nonEmpty.addFileSpec(SAMPLE_BIN2_OFFSET, 8);
            }
            catch (CoreException e1) {
                IContentTypeManagerTest.fail((String)"1.3.0", (Throwable)e1);
            }
            try {
                selected1 = manager.findContentTypesFor("file_with_no_extension");
                IContentTypeManagerTest.assertEquals((String)"1.3.1", (int)5, (int)selected1.length);
                IContentTypeManagerTest.assertTrue((String)"1.3.2", (boolean)this.contains(selected1, nonEmpty));
            }
            finally {
                try {
                    nonEmpty.removeFileSpec(SAMPLE_BIN2_OFFSET, 8);
                }
                catch (CoreException e2) {
                    IContentTypeManagerTest.fail((String)"1.3.3", (Throwable)e2);
                }
            }
            selected1 = manager.findContentTypesFor("file_with_no_extension");
            IContentTypeManagerTest.assertEquals((String)"1.4.0", (int)4, (int)selected1.length);
            IContentTypeManagerTest.assertTrue((String)"1.4.1", (!this.contains(selected1, nonEmpty) ? 1 : 0) != 0);
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle04"}, (TestRegistryChangeListener)listener);
    }

    public void testOrderWithEmptyFiles() throws IOException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = manager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType xml = manager.getContentType("org.eclipse.core.runtime.xml");
        manager.getContentType("org.eclipse.core.tests.resources.root-element");
        manager.getContentType("org.eclipse.core.tests.resources.dtd");
        IContentType selected = finder.findContentTypeFor(this.getInputStream(SAMPLE_BIN2_OFFSET), "foo.xml");
        IContentTypeManagerTest.assertEquals((String)"1.0", (Object)xml, (Object)selected);
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)xml, (Object)finder.findContentTypeFor("foo.xml"));
    }

    public void testOrphanContentType() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType orphan = contentTypeManager.getContentType("org.eclipse.core.tests.resources.orphan");
        IContentTypeManagerTest.assertNull((String)"0.8", (Object)orphan);
        IContentType missing = contentTypeManager.getContentType("org.eclipse.bundle01.missing");
        IContentTypeManagerTest.assertNull((String)"0.9", (Object)missing);
        IContentTypeManagerTest.assertEquals((String)"1.1", (int)0, (int)contentTypeManager.findContentTypesFor("foo.orphan").length);
        IContentTypeManagerTest.assertEquals((String)"1.2", (int)0, (int)contentTypeManager.findContentTypesFor("orphan.orphan").length);
        IContentTypeManagerTest.assertEquals((String)"1.3", (int)0, (int)contentTypeManager.findContentTypesFor("foo.orphan2").length);
        TestRegistryChangeListener listener = new TestRegistryChangeListener("org.eclipse.core.runtime", "contentTypes", null, null);
        BundleTestingHelper.runWithBundles((String)"2", () -> {
            IContentType orphan1 = contentTypeManager.getContentType("org.eclipse.core.tests.resources.orphan");
            IContentTypeManagerTest.assertNotNull((String)"2.1", (Object)orphan1);
            IContentType missing1 = contentTypeManager.getContentType("org.eclipse.bundle01.missing");
            IContentTypeManagerTest.assertNotNull((String)"2.2", (Object)missing1);
            IContentTypeManagerTest.assertEquals((String)"2.3", (int)1, (int)contentTypeManager.findContentTypesFor("foo.orphan").length);
            IContentTypeManagerTest.assertEquals((String)"2.4", (Object)orphan1, (Object)contentTypeManager.findContentTypesFor("foo.orphan")[0]);
            IContentTypeManagerTest.assertEquals((String)"2.5", (int)1, (int)contentTypeManager.findContentTypesFor("orphan.orphan").length);
            IContentTypeManagerTest.assertEquals((String)"2.6", (Object)orphan1, (Object)contentTypeManager.findContentTypesFor("foo.orphan")[0]);
            IContentTypeManagerTest.assertEquals((String)"2.7", (int)1, (int)contentTypeManager.findContentTypesFor("foo.orphan2").length);
            IContentTypeManagerTest.assertEquals((String)"2.8", (Object)missing1, (Object)contentTypeManager.findContentTypesFor("foo.orphan2")[0]);
        }, (BundleContext)this.getContext(), (String[])new String[]{"Plugin_Testing/content/bundle01"}, (TestRegistryChangeListener)listener);
    }

    public void testPreferences() throws CoreException, BackingStoreException {
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType text = manager.getContentType("org.eclipse.core.runtime.text");
        Preferences textPrefs = InstanceScope.INSTANCE.getNode("org.eclipse.core.runtime/content-types").node(text.getId());
        IContentTypeManagerTest.assertNotNull((String)"0.1", (Object)text);
        IContentTypeManagerTest.assertNull((String)"1.0", (Object)text.getDefaultCharset());
        IContentTypeManagerTest.assertNull((String)"1.1", (Object)textPrefs.get("charset", null));
        text.setDefaultCharset("UTF-8");
        IContentTypeManagerTest.assertEquals((String)"1.2", (String)"UTF-8", (String)textPrefs.get("charset", null));
        text.setDefaultCharset(null);
        IContentTypeManagerTest.assertNull((String)"1.3", (Object)textPrefs.get("charset", null));
        IContentTypeManagerTest.assertFalse((String)"2.01", (boolean)text.isAssociatedWith("xyz.foo"));
        IContentTypeManagerTest.assertFalse((String)"2.01", (boolean)text.isAssociatedWith("xyz.bar"));
        IContentTypeManagerTest.assertFalse((String)"2.03", (boolean)text.isAssociatedWith("foo.ext"));
        IContentTypeManagerTest.assertFalse((String)"2.04", (boolean)text.isAssociatedWith("bar.ext"));
        textPrefs.remove("file-names");
        textPrefs.remove("file-extensions");
        IContentTypeManagerTest.assertNull((String)"2.0a", (Object)textPrefs.get("file-names", null));
        IContentTypeManagerTest.assertNull((String)"2.0b", (Object)textPrefs.get("file-extensions", null));
        text.addFileSpec("foo.ext", 4);
        IContentTypeManagerTest.assertTrue((String)"2.1", (boolean)text.isAssociatedWith("foo.ext"));
        IContentTypeManagerTest.assertEquals((String)"2.2", (String)"foo.ext", (String)textPrefs.get("file-names", null));
        text.addFileSpec("bar.ext", 4);
        IContentTypeManagerTest.assertTrue((String)"2.3", (boolean)text.isAssociatedWith("bar.ext"));
        IContentTypeManagerTest.assertEquals((String)"2.4", (String)"foo.ext,bar.ext", (String)textPrefs.get("file-names", null));
        text.addFileSpec("foo", 8);
        IContentTypeManagerTest.assertTrue((String)"2.5", (boolean)text.isAssociatedWith("xyz.foo"));
        IContentTypeManagerTest.assertEquals((String)"2.6", (String)"foo", (String)textPrefs.get("file-extensions", null));
        text.addFileSpec("bar", 8);
        IContentTypeManagerTest.assertTrue((String)"2.7", (boolean)text.isAssociatedWith("xyz.bar"));
        IContentTypeManagerTest.assertEquals((String)"2.4", (String)"foo,bar", (String)textPrefs.get("file-extensions", null));
        text.removeFileSpec("foo.ext", 4);
        text.removeFileSpec("bar.ext", 4);
        text.removeFileSpec("foo", 8);
        text.removeFileSpec("bar", 8);
        IContentTypeManagerTest.assertFalse((String)"3.1", (boolean)text.isAssociatedWith("xyz.foo"));
        IContentTypeManagerTest.assertFalse((String)"3.2", (boolean)text.isAssociatedWith("xyz.bar"));
        IContentTypeManagerTest.assertFalse((String)"3.3", (boolean)text.isAssociatedWith("foo.ext"));
        IContentTypeManagerTest.assertFalse((String)"3.4", (boolean)text.isAssociatedWith("bar.ext"));
        try {
            text.addFileSpec("foo.bar", 4);
            textPrefs.sync();
            IContentTypeManagerTest.assertEquals((String)"4.0", (String)"foo.bar", (String)textPrefs.get("file-names", null));
        }
        finally {
            text.removeFileSpec("foo.bar", 4);
        }
    }

    public void testRegistry() {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentTypeMatcher finder = contentTypeManager.getMatcher((IContentTypeManager.ISelectionPolicy)new LocalSelectionPolicy(), null);
        IContentType textContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)textContentType);
        IContentTypeManagerTest.assertTrue((String)"1.1", (boolean)this.isText(contentTypeManager, textContentType));
        IContentTypeManagerTest.assertNotNull((String)"1.2", (Object)((ContentTypeHandler)textContentType).getTarget().getDescriber());
        IContentType xmlContentType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentTypeManagerTest.assertNotNull((String)"2.0", (Object)xmlContentType);
        IContentTypeManagerTest.assertTrue((String)"2.1", (boolean)this.isText(contentTypeManager, xmlContentType));
        IContentTypeManagerTest.assertEquals((String)"2.2", (Object)textContentType, (Object)xmlContentType.getBaseType());
        IContentDescriber xmlDescriber = ((ContentTypeHandler)xmlContentType).getTarget().getDescriber();
        IContentTypeManagerTest.assertNotNull((String)"2.3", (Object)xmlDescriber);
        IContentTypeManagerTest.assertTrue((String)"2.4", (boolean)(xmlDescriber instanceof XMLContentDescriber));
        IContentType xmlBasedDifferentExtensionContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-different-extension");
        IContentTypeManagerTest.assertNotNull((String)"3.0", (Object)xmlBasedDifferentExtensionContentType);
        IContentTypeManagerTest.assertTrue((String)"3.1", (boolean)this.isText(contentTypeManager, xmlBasedDifferentExtensionContentType));
        IContentTypeManagerTest.assertEquals((String)"3.2", (Object)xmlContentType, (Object)xmlBasedDifferentExtensionContentType.getBaseType());
        IContentType xmlBasedSpecificNameContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.xml-based-specific-name");
        IContentTypeManagerTest.assertNotNull((String)"4.0", (Object)xmlBasedSpecificNameContentType);
        IContentTypeManagerTest.assertTrue((String)"4.1", (boolean)this.isText(contentTypeManager, xmlBasedSpecificNameContentType));
        IContentTypeManagerTest.assertEquals((String)"4.2", (Object)xmlContentType, (Object)xmlBasedSpecificNameContentType.getBaseType());
        Object[] xmlTypes = finder.findContentTypesFor(this.changeCase("foo.xml"));
        IContentTypeManagerTest.assertTrue((String)"5.1", (boolean)this.contains(xmlTypes, xmlContentType));
        IContentType binaryContentType = contentTypeManager.getContentType("org.eclipse.core.tests.resources.sample-binary1");
        IContentTypeManagerTest.assertNotNull((String)"6.0", (Object)binaryContentType);
        IContentTypeManagerTest.assertTrue((String)"6.1", (!this.isText(contentTypeManager, binaryContentType) ? 1 : 0) != 0);
        IContentTypeManagerTest.assertNull((String)"6.2", (Object)binaryContentType.getBaseType());
        IContentType[] binaryTypes = finder.findContentTypesFor(this.changeCase("foo.samplebin1"));
        IContentTypeManagerTest.assertEquals((String)"7.0", (int)1, (int)binaryTypes.length);
        IContentTypeManagerTest.assertEquals((String)"7.1", (Object)binaryContentType, (Object)binaryTypes[0]);
        IContentType myText = contentTypeManager.getContentType("org.eclipse.core.tests.resources.mytext");
        IContentTypeManagerTest.assertNotNull((String)"8.0", (Object)myText);
        IContentTypeManagerTest.assertEquals((String)"8.1", (String)"BAR", (String)myText.getDefaultCharset());
        Object[] fooBarTypes = finder.findContentTypesFor(this.changeCase("foo.bar"));
        IContentTypeManagerTest.assertEquals((String)"9.0", (int)2, (int)fooBarTypes.length);
        IContentType fooBar = contentTypeManager.getContentType("org.eclipse.core.tests.resources.fooBar");
        IContentTypeManagerTest.assertNotNull((String)"9.1", (Object)fooBar);
        IContentType subFooBar = contentTypeManager.getContentType("org.eclipse.core.tests.resources.subFooBar");
        IContentTypeManagerTest.assertNotNull((String)"9.2", (Object)subFooBar);
        IContentTypeManagerTest.assertTrue((String)"9.3", (boolean)this.contains(fooBarTypes, fooBar));
        IContentTypeManagerTest.assertTrue((String)"9.4", (boolean)this.contains(fooBarTypes, subFooBar));
    }

    public void testRootElementAndDTDDescriber() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType rootElement = contentTypeManager.getContentType("org.eclipse.core.tests.resources.root-element");
        IContentType dtdElement = contentTypeManager.getContentType("org.eclipse.core.tests.resources.dtd");
        IContentType nsRootElement = contentTypeManager.getContentType("org.eclipse.core.tests.resources.ns-root-element");
        IContentType nsWildcard = contentTypeManager.getContentType("org.eclipse.core.tests.resources.ns-wildcard");
        IContentType emptyNsRootElement = contentTypeManager.getContentType("org.eclipse.core.tests.resources.empty-ns-root-element");
        IContentType xmlType = contentTypeManager.getContentType("org.eclipse.core.runtime.xml");
        IContentType[] contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_ISO_8859_1, StandardCharsets.ISO_8859_1), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"1.0", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)rootElement, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_EXTERNAL_ENTITY, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"2.0", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"2.1", (Object)rootElement, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_EXTERNAL_ENTITY2, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"3.0", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"3.1", (Object)rootElement, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MATCH1, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"4.0", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"4.1", (Object)nsRootElement, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MATCH2, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"4.2", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"4.3", (Object)nsRootElement, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_WRONG_ELEM, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"4.4", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"4.5", (Object)xmlType, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_WRONG_NS, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"4.6", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"4.7", (Object)xmlType, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MIXUP, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"4.8", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"4.9", (Object)xmlType, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_WILDCARD, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"4.10", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"4.11", (Object)nsWildcard, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_WILDCARD2, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"4.12", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"4.13", (Object)nsWildcard, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_EMPTY_NS, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"4.14", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"4.15", (Object)emptyNsRootElement, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_DTD_US_ASCII, StandardCharsets.US_ASCII), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"5.0", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"5.1", (Object)dtdElement, (Object)contentTypes[0]);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_DTD_EXTERNAL_ENTITY, StandardCharsets.UTF_8), "fake.xml");
        IContentTypeManagerTest.assertTrue((String)"5.4", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"5.5", (Object)dtdElement, (Object)contentTypes[0]);
        IContentDescription description = contentTypeManager.getDescriptionFor(this.getInputStream(new byte[][]{IContentDescription.BOM_UTF_16BE, XML_ROOT_ELEMENT_NO_DECL.getBytes("UTF-16BE")}), "fake.xml", IContentDescription.ALL);
        IContentTypeManagerTest.assertTrue((String)"6.0", (description != null ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"6.1", (Object)rootElement, (Object)description.getContentType());
        IContentTypeManagerTest.assertEquals((String)"6.2", (Object)IContentDescription.BOM_UTF_16BE, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        description = contentTypeManager.getDescriptionFor(this.getInputStream(new byte[][]{IContentDescription.BOM_UTF_16LE, XML_ROOT_ELEMENT_NO_DECL.getBytes("UTF-16LE")}), "fake.xml", IContentDescription.ALL);
        IContentTypeManagerTest.assertTrue((String)"7.0", (description != null ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"7.1", (Object)rootElement, (Object)description.getContentType());
        IContentTypeManagerTest.assertEquals((String)"7.2", (Object)IContentDescription.BOM_UTF_16LE, (Object)description.getProperty(IContentDescription.BYTE_ORDER_MARK));
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NO_DECL, StandardCharsets.UTF_8), "test.txt");
        IContentTypeManagerTest.assertTrue((String)"8.0", (contentTypes.length > 0 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"8.1", (Object)contentTypeManager.getContentType("org.eclipse.core.runtime.text"), (Object)contentTypes[0]);
    }

    public void testSignatureBeyondBufferLimit() throws IOException {
        int bufferLimit = 4096;
        StringBuilder comment = new StringBuilder("<!--");
        int i = 0;
        while (i < bufferLimit) {
            comment.append('*');
            ++i;
        }
        comment.append("-->");
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType rootElement = manager.getContentType("org.eclipse.core.tests.resources.root-element");
        IContentType selected = manager.findContentTypeFor(this.getInputStream(comment + XML_ROOT_ELEMENT_NO_DECL, StandardCharsets.US_ASCII), "fake.xml");
        IContentTypeManagerTest.assertNotNull((String)"1.0", (Object)selected);
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)rootElement, (Object)selected);
    }

    public void testUserDefinedAssociations() {
        IContentType result;
        IContentTypeManager manager = Platform.getContentTypeManager();
        IContentType text = manager.getContentType("org.eclipse.core.runtime.text");
        IContentTypeManagerTest.assertNull((String)"0.1", (Object)manager.findContentTypeFor("test.mytext"));
        try {
            text.addFileSpec("mytext", 8);
        }
        catch (CoreException e) {
            IContentTypeManagerTest.fail((String)"1.0", (Throwable)e);
        }
        boolean assertionFailed = false;
        try {
            try {
                result = manager.findContentTypeFor("test.mytext");
                IContentTypeManagerTest.assertNotNull((String)"1.1", (Object)result);
                IContentTypeManagerTest.assertEquals((String)"1.2", (Object)text, (Object)result);
            }
            catch (AssertionFailedError afe) {
                assertionFailed = true;
                throw afe;
            }
        }
        finally {
            block12: {
                try {
                    text.removeFileSpec("mytext", 8);
                }
                catch (CoreException e) {
                    if (assertionFailed) break block12;
                    IContentTypeManagerTest.fail((String)" 2.0", (Throwable)e);
                }
            }
        }
        result = manager.findContentTypeFor("test.mytext");
        IContentTypeManagerTest.assertNull((String)"3.0", (Object)result);
    }

    public void testDescriberInvalidation() throws IOException {
        IContentTypeManager contentTypeManager = Platform.getContentTypeManager();
        IContentType type_bug182337_A = contentTypeManager.getContentType("org.eclipse.core.tests.resources.Bug182337_A");
        IContentType type_bug182337_B = contentTypeManager.getContentType("org.eclipse.core.tests.resources.Bug182337_B");
        IContentType[] contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MATCH2, StandardCharsets.UTF_8), "Bug182337.Bug182337");
        IContentTypeManagerTest.assertTrue((String)"1.0", (contentTypes.length == 2 ? 1 : 0) != 0);
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)type_bug182337_A, (Object)contentTypes[0]);
        IContentTypeManagerTest.assertEquals((String)"1.1", (Object)type_bug182337_B, (Object)contentTypes[1]);
        InputStream is = new InputStream(){

            @Override
            public int read() {
                throw new RuntimeException();
            }
        };
        contentTypes = contentTypeManager.findContentTypesFor(is, "Bug182337.Bug182337");
        IContentTypeManagerTest.assertTrue((String)"1.2", (contentTypes.length == 0 ? 1 : 0) != 0);
        contentTypes = contentTypeManager.findContentTypesFor(this.getInputStream(XML_ROOT_ELEMENT_NS_MATCH2, StandardCharsets.UTF_8), "Bug182337.Bug182337");
        IContentTypeManagerTest.assertTrue((String)"1.3", (contentTypes.length == 0 ? 1 : 0) != 0);
    }

    private static class ContentTypeChangeTracer
    implements IContentTypeManager.IContentTypeChangeListener {
        private final Set<IContentType> changed = new HashSet<IContentType>();

        public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
            this.changed.add(event.getContentType());
        }

        public boolean isOnlyChange(IContentType myType) {
            return this.changed.size() == 1 && this.changed.contains(myType);
        }

        public void reset() {
            this.changed.clear();
        }
    }
}

