/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.content.LazyReader;

public class LazyReaderTest
extends TestCase {
    private static final String DATA = "012345678901234567890123456789";

    public LazyReaderTest(String name) {
        super(name);
    }

    public void testReadSingleChar() throws IOException {
        CharArrayReader underlying = new CharArrayReader(DATA.toCharArray());
        OpenLazyReader stream = new OpenLazyReader(underlying, 7);
        LazyReaderTest.assertEquals((String)"1.0", (int)48, (int)stream.read());
        LazyReaderTest.assertEquals((String)"1.1", (int)49, (int)stream.read());
        stream.skip(10L);
        LazyReaderTest.assertEquals((String)"1.2", (int)50, (int)stream.read());
        LazyReaderTest.assertEquals((String)"1.3", (int)13, (int)stream.getOffset());
        stream.close();
    }

    public void testReadBlock() throws IOException {
        CharArrayReader underlying = new CharArrayReader(DATA.toCharArray());
        OpenLazyReader stream = new OpenLazyReader(underlying, 7);
        stream.skip(4L);
        char[] buffer = new char[7];
        int read = stream.read(buffer);
        LazyReaderTest.assertEquals((String)"1.0", (int)buffer.length, (int)read);
        LazyReaderTest.assertEquals((String)"1.1", (String)DATA.substring(4, 4 + buffer.length), (String)new String(buffer));
        LazyReaderTest.assertEquals((String)"1.2", (int)11, (int)stream.getOffset());
        read = stream.read(buffer, 3, 4);
        LazyReaderTest.assertEquals((String)"2.0", (int)4, (int)read);
        LazyReaderTest.assertEquals((String)"2.1", (String)DATA.substring(11, 11 + read), (String)new String(buffer, 3, read));
        LazyReaderTest.assertEquals((String)"2.2", (int)15, (int)stream.getOffset());
        stream.mark(0);
        buffer = new char[100];
        read = stream.read(buffer);
        LazyReaderTest.assertEquals((String)"3.0", (int)(DATA.length() - 15), (int)read);
        LazyReaderTest.assertEquals((String)"3.1", (String)DATA.substring(15, 15 + read), (String)new String(buffer, 0, read));
        LazyReaderTest.assertFalse((String)"3.2", (boolean)stream.ready());
        stream.reset();
        LazyReaderTest.assertEquals((String)"4.0", (int)15, (int)stream.getOffset());
        read = stream.read(buffer, 10, 14);
        LazyReaderTest.assertEquals((String)"4.1", (int)29, (int)stream.getOffset());
        LazyReaderTest.assertTrue((String)"4.2", (boolean)stream.ready());
        LazyReaderTest.assertEquals((String)"4.3", (int)14, (int)read);
        LazyReaderTest.assertEquals((String)"4.4", (String)DATA.substring(15, 15 + read), (String)new String(buffer, 10, read));
        read = stream.read(buffer);
        LazyReaderTest.assertEquals((String)"5.0", (int)30, (int)stream.getOffset());
        LazyReaderTest.assertFalse((String)"5.1", (boolean)stream.ready());
        LazyReaderTest.assertEquals((String)"5.2", (int)1, (int)read);
        LazyReaderTest.assertEquals((String)"5.3", (int)((byte)DATA.charAt(29)), (int)buffer[0]);
        read = stream.read(buffer);
        LazyReaderTest.assertEquals((String)"6.0", (int)30, (int)stream.getOffset());
        LazyReaderTest.assertFalse((String)"6.1", (boolean)stream.ready());
        LazyReaderTest.assertEquals((String)"6.2", (int)-1, (int)read);
        stream.close();
    }

    public void testMarkAndReset() throws IOException {
        CharArrayReader underlying = new CharArrayReader(DATA.toCharArray());
        OpenLazyReader stream = new OpenLazyReader(underlying, 7);
        LazyReaderTest.assertTrue((String)"0.1", (boolean)stream.ready());
        stream.skip(13L);
        LazyReaderTest.assertTrue((String)"0.2", (boolean)stream.ready());
        stream.mark(0);
        LazyReaderTest.assertEquals((String)"2.0", (int)13, (int)stream.getMark());
        LazyReaderTest.assertEquals((String)"2.1", (int)51, (int)stream.read());
        LazyReaderTest.assertEquals((String)"2.2", (int)52, (int)stream.read());
        LazyReaderTest.assertEquals((String)"2.3", (int)15, (int)stream.getOffset());
        LazyReaderTest.assertTrue((String)"2.4", (boolean)stream.ready());
        stream.reset();
        LazyReaderTest.assertTrue((String)"2.5", (boolean)stream.ready());
        LazyReaderTest.assertEquals((String)"2.6", (int)13, (int)stream.getOffset());
        LazyReaderTest.assertEquals((String)"2.7", (long)17L, (long)stream.skip(1000L));
        LazyReaderTest.assertFalse((String)"2.8", (boolean)stream.ready());
        stream.reset();
        LazyReaderTest.assertTrue((String)"2.9", (boolean)stream.ready());
        LazyReaderTest.assertEquals((String)"2.10", (int)13, (int)stream.getOffset());
        stream.reset();
        LazyReaderTest.assertTrue((String)"2.11", (boolean)stream.ready());
        LazyReaderTest.assertEquals((String)"2.12", (int)13, (int)stream.getOffset());
        stream.rewind();
        LazyReaderTest.assertEquals((String)"3.0", (int)0, (int)stream.getOffset());
        stream.close();
    }

    public static Test suite() {
        return new TestSuite(LazyReaderTest.class);
    }

    private static class OpenLazyReader
    extends LazyReader {
        public OpenLazyReader(Reader in, int blockCapacity) {
            super(in, blockCapacity);
        }

        public int getBlockCount() {
            return super.getBlockCount();
        }

        public int getBufferSize() {
            return super.getBufferSize();
        }

        public int getMark() {
            return super.getMark();
        }

        public int getOffset() {
            return super.getOffset();
        }
    }
}

