/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTest;

public class BenchFileStore
extends ResourceTest {
    private static final int LOOP_SIZE = 5000;
    private static final int REPEATS = 30;
    protected IFileStore existingStore;
    protected IFileStore nonexistingStore;

    public static Test suite() {
        return new TestSuite(BenchFileStore.class);
    }

    public BenchFileStore() {
    }

    public BenchFileStore(String name) {
        super(name);
    }

    protected void createStores() throws CoreException {
        this.existingStore = EFS.getFileSystem((String)"file").getStore(this.getRandomLocation());
        try {
            this.existingStore.openOutputStream(0, null).close();
        }
        catch (IOException e) {
            BenchFileStore.fail((String)"BenchFileStore.createStores", (Throwable)e);
        }
        this.nonexistingStore = EFS.getFileSystem((String)"file").getStore(this.getRandomLocation());
    }

    protected void deleteStores() throws CoreException {
        this.existingStore.delete(0, null);
    }

    public void testStoreExists() {
        new StoreTestRunner(this){

            protected void test() {
                existingStore.fetchInfo().exists();
                nonexistingStore.fetchInfo().exists();
            }
        }.run((TestCase)this, 30, 5000);
    }

    public void testStoreIsReadOnly() {
        StoreTestRunner storeTestRunner = new StoreTestRunner(this){

            protected void test() {
                existingStore.fetchInfo().getAttribute(2);
                nonexistingStore.fetchInfo().getAttribute(2);
            }
        };
        storeTestRunner.setRegressionReason("Performance slowed down because new functionality was added in Windows filessytem natives (see Bug 318170).");
        storeTestRunner.run((TestCase)this, 30, 5000);
    }

    public void testStoreLastModified() {
        StoreTestRunner runner = new StoreTestRunner(this){

            protected void test() {
                existingStore.fetchInfo().getLastModified();
                nonexistingStore.fetchInfo().getLastModified();
            }
        };
        runner.setFingerprintName("Get file last modified time");
        runner.run((TestCase)this, 30, 5000);
    }

    abstract class StoreTestRunner
    extends PerformanceTestRunner {
        StoreTestRunner() {
        }

        protected void setUp() throws CoreException {
            BenchFileStore.this.createStores();
        }

        protected void tearDown() throws CoreException {
            BenchFileStore.this.deleteStores();
        }
    }
}

