/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.harness.FileSystemHelper;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class FileSystemPerformanceTest
extends LocalStoreTest {
    private static final String chars = "abcdefghijklmnopqrstuvwxyz";
    private static final int FILE_COUNT = 100;
    private static final int DIR_COUNT = 25;
    private static final int OUTER = 4;
    private static final int INNER = 1;
    private final Random random = new Random();
    private IFileStore baseStore;

    public String createString(int length) {
        StringBuilder buf = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            buf.append(chars.charAt(this.random.nextInt(chars.length())));
            ++i;
        }
        return buf.toString();
    }

    void createStructure() throws CoreException {
        this.baseStore = EFS.getLocalFileSystem().getStore(FileSystemHelper.getRandomLocation((IPath)this.getTempDir()));
        this.baseStore.mkdir(0, null);
        int i = 0;
        while (i < 25) {
            IFileStore dir = this.baseStore.getChild(this.createString(8));
            dir.mkdir(4, null);
            int j = 0;
            while (j < 100) {
                IFileStore file = dir.getChild(this.createString(16));
                this.createFile(file, this.createString(16));
                ++j;
            }
            ++i;
        }
    }

    void setAttributesOnTree() throws CoreException {
        IFileStore[] dirs;
        IFileStore[] iFileStoreArray = dirs = this.baseStore.childStores(0, null);
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore[] files;
            IFileStore dir = iFileStoreArray[n2];
            IFileStore[] iFileStoreArray2 = files = dir.childStores(0, null);
            int n3 = files.length;
            int n4 = 0;
            while (n4 < n3) {
                IFileInfo fileInfo;
                IFileStore file = iFileStoreArray2[n4];
                boolean clear = (fileInfo = file.fetchInfo()).getAttribute(2);
                fileInfo.setAttribute(6, !clear);
                file.putInfo(fileInfo, 1024, null);
                ++n4;
            }
            ++n2;
        }
    }

    public void testPutFileInfo() throws CoreException {
        this.createStructure();
        PerformanceTestRunner runner = new PerformanceTestRunner(){

            protected void test() {
                try {
                    FileSystemPerformanceTest.this.setAttributesOnTree();
                }
                catch (Exception e) {
                    FileSystemPerformanceTest.fail((String)"Failed to set attributes during performance test", (Throwable)e);
                }
            }
        };
        runner.run((TestCase)this, 4, 1);
        this.baseStore.delete(0, null);
    }

    public static Test suite() {
        return new TestSuite(FileSystemPerformanceTest.class);
    }
}

