/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.internal.localstore.HistoryStoreTest;
import org.eclipse.core.tests.resources.ResourceTest;

public class LocalHistoryPerformanceTest
extends ResourceTest {
    private IWorkspaceDescription original;

    public static Test suite() {
        return new TestSuite(LocalHistoryPerformanceTest.class);
    }

    public LocalHistoryPerformanceTest(String name) {
        super(name);
    }

    void cleanHistory() {
        ((Workspace)LocalHistoryPerformanceTest.getWorkspace()).getFileSystemManager().getHistoryStore().clean(this.getMonitor());
    }

    void createTree(IFolder base, int filesPerFolder, int statesPerFile) {
        IFolder[] folders;
        folders = new IFolder[]{base.getFolder("folder1"), base.getFolder("folder2"), folders[0].getFolder("folder3"), folders[2].getFolder("folder4"), folders[3].getFolder("folder5")};
        IWorkspace workspace = LocalHistoryPerformanceTest.getWorkspace();
        try {
            workspace.run(monitor -> {
                this.ensureExistsInWorkspace((IResource[])folders, true);
                IFolder[] iFolderArray2 = folders;
                int n3 = folders.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFolder folder = iFolderArray2[n4];
                    int j = 0;
                    while (j < filesPerFolder) {
                        IFile file = folder.getFile("file" + j);
                        this.ensureExistsInWorkspace(file, this.getRandomContents());
                        try {
                            int k = 0;
                            while (k < statesPerFile) {
                                file.setContents(this.getRandomContents(), 2, this.getMonitor());
                                ++k;
                            }
                        }
                        catch (CoreException ce) {
                            LocalHistoryPerformanceTest.fail((String)"0.5", (Throwable)ce);
                        }
                        ++j;
                    }
                    ++n4;
                }
            }, workspace.getRuleFactory().modifyRule((IResource)workspace.getRoot()), 1, this.getMonitor());
        }
        catch (CoreException e) {
            LocalHistoryPerformanceTest.fail((String)("#createTree at : " + base.getFullPath()), (Throwable)e);
        }
    }

    IWorkspaceDescription setMaxFileStates(String failureMessage, int maxFileStates) {
        IWorkspaceDescription currentDescription = LocalHistoryPerformanceTest.getWorkspace().getDescription();
        IWorkspaceDescription testDescription = LocalHistoryPerformanceTest.getWorkspace().getDescription();
        testDescription.setMaxFileStates(maxFileStates);
        try {
            LocalHistoryPerformanceTest.getWorkspace().setDescription(testDescription);
        }
        catch (CoreException e) {
            LocalHistoryPerformanceTest.fail((String)failureMessage, (Throwable)e);
        }
        return currentDescription;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.original = LocalHistoryPerformanceTest.getWorkspace().getDescription();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalHistoryPerformanceTest.getWorkspace().setDescription(this.original);
        super.tearDown();
        HistoryStoreTest.wipeHistoryStore(this.getMonitor());
    }

    public void testAddState() {
        this.setMaxFileStates("0.01", 100);
        final IFile file = LocalHistoryPerformanceTest.getWorkspace().getRoot().getProject("proj1").getFile("file.txt");
        new PerformanceTestRunner(){

            protected void setUp() {
                LocalHistoryPerformanceTest.this.ensureExistsInWorkspace(file, LocalHistoryPerformanceTest.this.getRandomContents());
            }

            protected void tearDown() {
                try {
                    file.clearHistory(LocalHistoryPerformanceTest.this.getMonitor());
                    file.delete(1, LocalHistoryPerformanceTest.this.getMonitor());
                }
                catch (CoreException e) {
                    LocalHistoryPerformanceTest.fail((String)"1.0", (Throwable)e);
                }
            }

            protected void test() {
                try {
                    file.setContents(LocalHistoryPerformanceTest.this.getRandomContents(), 2, LocalHistoryPerformanceTest.this.getMonitor());
                }
                catch (CoreException e) {
                    LocalHistoryPerformanceTest.fail((String)"", (Throwable)e);
                }
            }
        }.run((TestCase)this, 10, 30);
    }

    public void testBug28603() {
        final IProject project = LocalHistoryPerformanceTest.getWorkspace().getRoot().getProject("myproject");
        final IFolder folder1 = project.getFolder("myfolder1");
        final IFolder folder2 = project.getFolder("myfolder2");
        final IFile file1 = folder1.getFile("myfile.txt");
        final IFile file2 = folder2.getFile(file1.getName());
        new PerformanceTestRunner(){

            protected void setUp() {
                LocalHistoryPerformanceTest.this.ensureExistsInWorkspace(new IResource[]{project, folder1, folder2}, true);
                try {
                    file1.create(LocalHistoryPerformanceTest.this.getRandomContents(), 1, LocalHistoryPerformanceTest.this.getMonitor());
                    file1.setContents(LocalHistoryPerformanceTest.this.getRandomContents(), 3, LocalHistoryPerformanceTest.this.getMonitor());
                    file1.setContents(LocalHistoryPerformanceTest.this.getRandomContents(), 3, LocalHistoryPerformanceTest.this.getMonitor());
                    file1.setContents(LocalHistoryPerformanceTest.this.getRandomContents(), 3, LocalHistoryPerformanceTest.this.getMonitor());
                }
                catch (CoreException e) {
                    LocalHistoryPerformanceTest.fail((String)"0.0", (Throwable)e);
                }
            }

            protected void tearDown() {
                try {
                    LocalHistoryPerformanceTest.this.ensureDoesNotExistInWorkspace((IResource)LocalHistoryPerformanceTest.getWorkspace().getRoot());
                    IHistoryStore store = ((Workspace)LocalHistoryPerformanceTest.getWorkspace()).getFileSystemManager().getHistoryStore();
                    store.remove((IPath)Path.ROOT, LocalHistoryPerformanceTest.this.getMonitor());
                    store.removeGarbage();
                }
                catch (Exception e) {
                    LocalHistoryPerformanceTest.fail((String)"2.0", (Throwable)e);
                }
            }

            protected void test() {
                try {
                    file1.move(file2.getFullPath(), true, true, LocalHistoryPerformanceTest.this.getMonitor());
                    file2.move(file1.getFullPath(), true, true, LocalHistoryPerformanceTest.this.getMonitor());
                }
                catch (CoreException e) {
                    LocalHistoryPerformanceTest.fail((String)"1.0", (Throwable)e);
                }
            }
        }.run((TestCase)this, 10, 5);
    }

    private void testClearHistory(final int filesPerFolder, final int statesPerFile) {
        IProject project = LocalHistoryPerformanceTest.getWorkspace().getRoot().getProject("proj1");
        final IFolder base = project.getFolder("base");
        this.ensureDoesNotExistInWorkspace((IResource)base);
        new PerformanceTestRunner(){
            private IWorkspaceDescription original;

            protected void setUp() {
                this.original = LocalHistoryPerformanceTest.this.setMaxFileStates("0.1", 1);
                LocalHistoryPerformanceTest.this.cleanHistory();
                LocalHistoryPerformanceTest.this.createTree(base, filesPerFolder, statesPerFile);
                LocalHistoryPerformanceTest.this.ensureDoesNotExistInWorkspace((IResource)base);
            }

            protected void tearDown() throws CoreException {
                if (this.original != null) {
                    LocalHistoryPerformanceTest.getWorkspace().setDescription(this.original);
                }
            }

            protected void test() {
                try {
                    base.clearHistory(LocalHistoryPerformanceTest.this.getMonitor());
                }
                catch (CoreException e) {
                    LocalHistoryPerformanceTest.fail((String)"", (Throwable)e);
                }
            }
        }.run((TestCase)this, 4, 3);
    }

    public void testClearHistory100x4() {
        this.testClearHistory(100, 4);
    }

    public void testClearHistory20x20() {
        this.testClearHistory(20, 20);
    }

    public void testClearHistory4x100() {
        this.testClearHistory(4, 100);
    }

    private void testCopyHistory(int filesPerFolder, int statesPerFile) {
        IProject project = LocalHistoryPerformanceTest.getWorkspace().getRoot().getProject("proj1");
        IFolder base = project.getFolder("base");
        this.createTree(base, filesPerFolder, statesPerFile);
        final IProject[] tmpProject = new IProject[]{project};
        new PerformanceTestRunner(){

            protected void test() {
                try {
                    String newProjectName = LocalHistoryPerformanceTest.this.getUniqueString();
                    IProject newProject = LocalHistoryPerformanceTest.getWorkspace().getRoot().getProject(newProjectName);
                    tmpProject[0].copy(newProject.getFullPath(), true, LocalHistoryPerformanceTest.this.getMonitor());
                    tmpProject[0] = newProject;
                }
                catch (CoreException e) {
                    LocalHistoryPerformanceTest.fail((String)"", (Throwable)e);
                }
            }
        }.run((TestCase)this, 10, 1);
    }

    public void testCopyHistory100x4() {
        this.testCopyHistory(100, 4);
    }

    public void testCopyHistory20x20() {
        this.testCopyHistory(20, 20);
    }

    public void testCopyHistory4x100() {
        this.testCopyHistory(4, 100);
    }

    private void testGetDeletedMembers(int filesPerFolder, int statesPerFile) {
        IProject project = LocalHistoryPerformanceTest.getWorkspace().getRoot().getProject("proj1");
        IFolder base = project.getFolder("base");
        this.createTree(base, filesPerFolder, statesPerFile);
        this.ensureDoesNotExistInWorkspace((IResource)base);
        final IProject tmpProject = project;
        new PerformanceTestRunner(){

            protected void test() {
                try {
                    tmpProject.findDeletedMembersWithHistory(2, LocalHistoryPerformanceTest.this.getMonitor());
                }
                catch (CoreException e) {
                    LocalHistoryPerformanceTest.fail((String)"", (Throwable)e);
                }
            }
        }.run((TestCase)this, 2, 5);
    }

    public void testGetDeletedMembers100x4() {
        this.testGetDeletedMembers(100, 4);
    }

    public void testGetDeletedMembers20x20() {
        this.testGetDeletedMembers(20, 20);
    }

    public void testGetDeletedMembers4x100() {
        this.testGetDeletedMembers(4, 100);
    }

    public void testGetHistory() {
        IProject project = LocalHistoryPerformanceTest.getWorkspace().getRoot().getProject("proj1");
        final IFile file = project.getFile("file.txt");
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        try {
            int i = 0;
            while (i < 100) {
                file.setContents(this.getRandomContents(), 2, this.getMonitor());
                ++i;
            }
        }
        catch (CoreException ce) {
            LocalHistoryPerformanceTest.fail((String)"0.5", (Throwable)ce);
        }
        new PerformanceTestRunner(){

            protected void test() {
                try {
                    file.getHistory(LocalHistoryPerformanceTest.this.getMonitor());
                }
                catch (CoreException e) {
                    LocalHistoryPerformanceTest.fail((String)"", (Throwable)e);
                }
            }
        }.run((TestCase)this, 1, 150);
    }

    private void testHistoryCleanUp(final int filesPerFolder, final int statesPerFile) {
        IProject project = LocalHistoryPerformanceTest.getWorkspace().getRoot().getProject("proj1");
        final IFolder base = project.getFolder("base");
        this.ensureDoesNotExistInWorkspace((IResource)base);
        new PerformanceTestRunner(){
            private IWorkspaceDescription original;

            protected void setUp() {
                this.original = LocalHistoryPerformanceTest.this.setMaxFileStates("0.1", 1);
                LocalHistoryPerformanceTest.this.cleanHistory();
                LocalHistoryPerformanceTest.this.createTree(base, filesPerFolder, statesPerFile);
                LocalHistoryPerformanceTest.this.ensureDoesNotExistInWorkspace((IResource)base);
            }

            protected void tearDown() throws CoreException {
                if (this.original != null) {
                    LocalHistoryPerformanceTest.getWorkspace().setDescription(this.original);
                }
            }

            protected void test() {
                LocalHistoryPerformanceTest.this.cleanHistory();
            }
        }.run((TestCase)this, 5, 1);
    }

    public void testHistoryCleanUp100x4() {
        this.testHistoryCleanUp(100, 4);
    }

    public void testHistoryCleanUp20x20() {
        this.testHistoryCleanUp(20, 20);
    }
}

