/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.ClearMarkersBuilder;

public class Bug_147232
extends AbstractBuilderTest
implements IResourceChangeListener {
    int deltaSeenCount;
    IFile file;
    IProject project;

    public static Test suite() {
        return new TestSuite(Bug_147232.class);
    }

    public Bug_147232(String name) {
        super(name);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta delta = event.getDelta().findMember(this.file.getFullPath());
        if (delta != null && delta.getKind() == 1) {
            ++this.deltaSeenCount;
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        ClearMarkersBuilder.pauseAfterBuild = true;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Bug_147232.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        ClearMarkersBuilder.pauseAfterBuild = false;
    }

    public void testBug() {
        this.project = Bug_147232.getWorkspace().getRoot().getProject("Bug_147232");
        this.file = this.project.getFile("file.txt");
        Bug_147232.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 25);
        try {
            this.setAutoBuilding(false);
            this.project.create(this.getMonitor());
            this.project.open(this.getMonitor());
            this.addBuilder(this.project, "org.eclipse.core.tests.resources.clearmarkersbuilder");
            this.setAutoBuilding(true);
            this.waitForBuild();
        }
        catch (CoreException e) {
            Bug_147232.fail((String)"0.99", (Throwable)e);
        }
        try {
            this.create((IResource)this.file, true);
        }
        catch (CoreException e) {
            Bug_147232.fail((String)"1.99", (Throwable)e);
        }
        this.waitForBuild();
        Bug_147232.assertEquals((String)"2.0", (int)1, (int)this.deltaSeenCount);
    }
}

