/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_165892
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(Bug_165892.class);
    }

    public Bug_165892() {
    }

    public Bug_165892(String name) {
        super(name);
    }

    public void testCopyFile() {
        IProject source = Bug_165892.getWorkspace().getRoot().getProject("project");
        IFolder sourceFolder = source.getFolder("folder");
        IFile sourceFile = sourceFolder.getFile("source");
        IFile destinationFile = sourceFolder.getFile("destination");
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        QualifiedName name = new QualifiedName("Bug_165892", "Property");
        try {
            sourceFile.setPersistentProperty(name, "SourceValue");
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"0.99", (Throwable)e);
        }
        try {
            sourceFile.copy(destinationFile.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"1.99", (Throwable)e);
        }
        try {
            Bug_165892.assertEquals((String)"2.0", (String)"SourceValue", (String)sourceFile.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.1", (String)"SourceValue", (String)destinationFile.getPersistentProperty(name));
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"2.98", (Throwable)e);
        }
        try {
            destinationFile.setPersistentProperty(name, "DestinationValue");
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"2.99", (Throwable)e);
        }
        try {
            Bug_165892.assertEquals((String)"3.0", (String)"SourceValue", (String)sourceFile.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.1", (String)"DestinationValue", (String)destinationFile.getPersistentProperty(name));
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"3.99", (Throwable)e);
        }
    }

    public void testCopyFileHistory() {
        IProject source = Bug_165892.getWorkspace().getRoot().getProject("project");
        IFolder sourceFolder = source.getFolder("folder");
        IFile sourceFile = sourceFolder.getFile("source");
        IFile destinationFile = sourceFolder.getFile("destination");
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        try {
            sourceFile.setContents(this.getRandomContents(), 2, this.getMonitor());
            Bug_165892.assertEquals((String)"1.0", (int)1, (int)sourceFile.getHistory(this.getMonitor()).length);
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"0.99", (Throwable)e);
        }
        try {
            sourceFile.copy(destinationFile.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"1.99", (Throwable)e);
        }
        try {
            Bug_165892.assertEquals((String)"2.0", (int)1, (int)sourceFile.getHistory(this.getMonitor()).length);
            Bug_165892.assertEquals((String)"2.1", (int)1, (int)destinationFile.getHistory(this.getMonitor()).length);
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"2.98", (Throwable)e);
        }
        try {
            destinationFile.setContents(this.getRandomContents(), 2, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"2.99", (Throwable)e);
        }
        try {
            Bug_165892.assertEquals((String)"2.0", (int)1, (int)sourceFile.getHistory(this.getMonitor()).length);
            Bug_165892.assertEquals((String)"2.1", (int)2, (int)destinationFile.getHistory(this.getMonitor()).length);
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"3.99", (Throwable)e);
        }
    }

    public void testCopyFolder() {
        IProject source = Bug_165892.getWorkspace().getRoot().getProject("project");
        IFolder sourceFolder = source.getFolder("source");
        IFile sourceFile = sourceFolder.getFile("Important.txt");
        IFolder destinationFolder = source.getFolder("destination");
        IFile destinationFile = destinationFolder.getFile(sourceFile.getName());
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        QualifiedName name = new QualifiedName("Bug_165892", "Property");
        try {
            source.setPersistentProperty(name, "SourceValue");
            sourceFolder.setPersistentProperty(name, "SourceValue");
            sourceFile.setPersistentProperty(name, "SourceValue");
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"0.99", (Throwable)e);
        }
        try {
            sourceFolder.copy(destinationFolder.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"1.99", (Throwable)e);
        }
        try {
            Bug_165892.assertEquals((String)"2.0", (String)"SourceValue", (String)source.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.1", (String)"SourceValue", (String)sourceFolder.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.2", (String)"SourceValue", (String)sourceFile.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.3", (String)"SourceValue", (String)destinationFolder.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.4", (String)"SourceValue", (String)destinationFile.getPersistentProperty(name));
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"2.98", (Throwable)e);
        }
        try {
            destinationFolder.setPersistentProperty(name, "DestinationValue");
            destinationFile.setPersistentProperty(name, "DestinationValue");
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"2.99", (Throwable)e);
        }
        try {
            Bug_165892.assertEquals((String)"3.0", (String)"SourceValue", (String)source.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.1", (String)"SourceValue", (String)sourceFolder.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.2", (String)"SourceValue", (String)sourceFile.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.3", (String)"DestinationValue", (String)destinationFolder.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.4", (String)"DestinationValue", (String)destinationFile.getPersistentProperty(name));
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"3.99", (Throwable)e);
        }
    }

    public void testCopyProject() {
        IProject source = Bug_165892.getWorkspace().getRoot().getProject("source");
        IFolder sourceFolder = source.getFolder("folder");
        IFile sourceFile = sourceFolder.getFile("Important.txt");
        IProject destination = Bug_165892.getWorkspace().getRoot().getProject("destination");
        IFolder destinationFolder = destination.getFolder(sourceFolder.getName());
        IFile destinationFile = destinationFolder.getFile(sourceFile.getName());
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        QualifiedName name = new QualifiedName("Bug_165892", "Property");
        try {
            source.setPersistentProperty(name, "SourceValue");
            sourceFolder.setPersistentProperty(name, "SourceValue");
            sourceFile.setPersistentProperty(name, "SourceValue");
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"0.99", (Throwable)e);
        }
        try {
            source.copy(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"1.99", (Throwable)e);
        }
        try {
            Bug_165892.assertEquals((String)"2.0", (String)"SourceValue", (String)source.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.1", (String)"SourceValue", (String)sourceFolder.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.2", (String)"SourceValue", (String)sourceFile.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.3", (String)"SourceValue", (String)destination.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.4", (String)"SourceValue", (String)destinationFolder.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"2.5", (String)"SourceValue", (String)destinationFile.getPersistentProperty(name));
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"2.98", (Throwable)e);
        }
        try {
            destination.setPersistentProperty(name, "DestinationValue");
            destinationFolder.setPersistentProperty(name, "DestinationValue");
            destinationFile.setPersistentProperty(name, "DestinationValue");
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"2.99", (Throwable)e);
        }
        try {
            Bug_165892.assertEquals((String)"3.0", (String)"SourceValue", (String)source.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.1", (String)"SourceValue", (String)sourceFolder.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.2", (String)"SourceValue", (String)sourceFile.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.3", (String)"DestinationValue", (String)destination.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.4", (String)"DestinationValue", (String)destinationFolder.getPersistentProperty(name));
            Bug_165892.assertEquals((String)"3.5", (String)"DestinationValue", (String)destinationFile.getPersistentProperty(name));
        }
        catch (CoreException e) {
            Bug_165892.fail((String)"3.99", (Throwable)e);
        }
    }
}

