/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_303517
extends ResourceTest {
    String[] resources = new String[]{"/", "/Bug303517/", "/Bug303517/Folder/", "/Bug303517/Folder/Resource"};

    public static Test suite() {
        return new TestSuite(Bug_303517.class);
    }

    @Override
    public String[] defineHierarchy() {
        return this.resources;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putBoolean("refresh.lightweight.enabled", true);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        InstanceScope.INSTANCE.getNode("org.eclipse.core.resources").putBoolean("refresh.lightweight.enabled", false);
    }

    public void testExists() throws Exception {
        this.createHierarchy();
        IFile f = Bug_303517.getWorkspace().getRoot().getFile((IPath)new Path(this.resources[this.resources.length - 1]));
        Bug_303517.assertTrue((String)"1.0", (boolean)f.exists());
        Bug_303517.assertTrue((String)"1.1", (boolean)f.isSynchronized(1));
        f.getLocation().toFile().delete();
        Bug_303517.assertTrue((String)"1.2", (boolean)f.exists());
        try {
            InputStream in = f.getContents();
            in.close();
            Bug_303517.assertTrue((String)"1.3", (boolean)false);
        }
        catch (CoreException coreException) {}
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, this.getMonitor());
        Bug_303517.assertFalse((String)"1.4", (boolean)f.exists());
    }

    public void testGetContents() throws Exception {
        InputStream in;
        this.createHierarchy();
        IFile f = Bug_303517.getWorkspace().getRoot().getFile((IPath)new Path(this.resources[this.resources.length - 1]));
        Bug_303517.assertTrue((String)"1.0", (boolean)f.exists());
        Bug_303517.assertTrue((String)"1.1", (boolean)f.isSynchronized(1));
        this.touchInFilesystem((IResource)f);
        try {
            in = f.getContents(false);
            in.close();
            Bug_303517.assertTrue((String)"2.0", (boolean)false);
        }
        catch (CoreException e) {
            Bug_303517.assertEquals((String)"2.1", (int)274, (int)e.getStatus().getCode());
        }
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, this.getMonitor());
        try {
            in = f.getContents(false);
            in.close();
        }
        catch (CoreException e) {
            Bug_303517.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testGetContentsTrue() throws Exception {
        Throwable e2;
        InputStream in;
        Object var3_7;
        this.createHierarchy();
        IFile f = Bug_303517.getWorkspace().getRoot().getFile((IPath)new Path(this.resources[this.resources.length - 1]));
        Bug_303517.assertTrue((String)"1.0", (boolean)f.exists());
        Bug_303517.assertTrue((String)"1.1", (boolean)f.isSynchronized(1));
        this.touchInFilesystem((IResource)f);
        try {
            Throwable throwable = null;
            var3_7 = null;
            try {
                in = f.getContents(true);
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e2) {
            Bug_303517.fail((String)"1.2", (Throwable)e2);
        }
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, this.getMonitor());
        try {
            e2 = null;
            var3_7 = null;
            try {
                in = f.getContents();
                if (in != null) {
                    in.close();
                }
            }
            catch (Throwable throwable) {
                if (e2 == null) {
                    e2 = throwable;
                } else if (e2 != throwable) {
                    e2.addSuppressed(throwable);
                }
                throw e2;
            }
        }
        catch (CoreException e3) {
            Bug_303517.fail((String)"1.3", (Throwable)e3);
        }
        f.getLocation().toFile().delete();
        try {
            e2 = null;
            var3_7 = null;
            try {
                in = f.getContents(true);
                try {
                    Bug_303517.fail((String)"2.0");
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable) {
                if (e2 == null) {
                    e2 = throwable;
                } else if (e2 != throwable) {
                    e2.addSuppressed(throwable);
                }
                throw e2;
            }
        }
        catch (CoreException e4) {
            Bug_303517.assertEquals((String)"2.1", (int)368, (int)e4.getStatus().getCode());
        }
    }

    public void testIsSynchronized() throws Exception {
        this.createHierarchy();
        IFile f = Bug_303517.getWorkspace().getRoot().getFile((IPath)new Path(this.resources[this.resources.length - 1]));
        Bug_303517.assertTrue((String)"1.0", (boolean)f.exists());
        Bug_303517.assertTrue((String)"1.1", (boolean)f.isSynchronized(1));
        this.touchInFilesystem((IResource)f);
        Bug_303517.assertFalse((String)"1.2", (boolean)f.isSynchronized(1));
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, this.getMonitor());
        Bug_303517.assertTrue((String)"1.3", (boolean)f.isSynchronized(1));
    }

    public void testChangeResourceGender() throws Exception {
        this.createHierarchy();
        IFile f = Bug_303517.getWorkspace().getRoot().getFile((IPath)new Path(this.resources[this.resources.length - 1]));
        Bug_303517.assertTrue((String)"1.0", (boolean)f.exists());
        Bug_303517.assertTrue((String)"1.1", (boolean)f.isSynchronized(1));
        File osResource = f.getLocation().toFile();
        osResource.delete();
        osResource.mkdir();
        Bug_303517.assertTrue((boolean)osResource.exists());
        File osChild = new File(osResource, "child");
        osChild.createNewFile();
        Bug_303517.assertTrue((boolean)osChild.exists());
        Bug_303517.assertFalse((String)"1.2", (boolean)f.isSynchronized(1));
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, this.getMonitor());
        Bug_303517.assertFalse((String)"1.3", (boolean)f.exists());
        Bug_303517.assertFalse((String)"1.4", (boolean)f.isSynchronized(1));
        f = Bug_303517.getWorkspace().getRoot().getFolder((IPath)new Path(this.resources[this.resources.length - 1]));
        Bug_303517.assertTrue((String)"1.5", (boolean)f.exists());
        Bug_303517.assertTrue((String)"1.6", (boolean)f.isSynchronized(2));
    }
}

