/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.filesystem.local.LocalFileNativesManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTest;
import org.junit.Assert;

public class Bug_530868
extends ResourceTest {
    private IProject testProject;
    private IFile testFile;

    public static Test suite() {
        return new TestSuite(Bug_530868.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testProject = Bug_530868.getWorkspace().getRoot().getProject(Bug_530868.class + "TestProject");
        this.testProject.create(this.getMonitor());
        this.testProject.open(this.getMonitor());
        this.testFile = this.testProject.getFile(this.getName());
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.testProject.delete(true, this.getMonitor());
        }
        finally {
            super.tearDown();
        }
    }

    public void testMillisecondResolution() throws Exception {
        Bug_530868.assertTrue((String)"can only run if native provider is used", (boolean)LocalFileNativesManager.isUsingNatives());
        if ("macosx".equals(Platform.getOS())) {
            return;
        }
        long timestamp1 = this.modifyTestFileAndFetchTimestamp("some contents 1");
        Thread.sleep(50L);
        long timestamp2 = this.modifyTestFileAndFetchTimestamp("some contents 2");
        Thread.sleep(50L);
        long timestamp3 = this.modifyTestFileAndFetchTimestamp("some contents 3");
        String failMessage = "expected different timestamps for modifications in quick succession";
        Assert.assertNotEquals((String)failMessage, (long)timestamp1, (long)timestamp2);
        Assert.assertNotEquals((String)failMessage, (long)timestamp2, (long)timestamp3);
    }

    private long modifyTestFileAndFetchTimestamp(String contents) throws Exception {
        this.setTestFileContents(contents);
        long timestamp = this.getLastModificationTimestamp();
        return timestamp;
    }

    private void setTestFileContents(String contents) throws Exception {
        ByteArrayInputStream contentsStream = new ByteArrayInputStream(String.valueOf(contents).getBytes());
        if (this.testFile.exists()) {
            this.testFile.delete(true, this.getMonitor());
        }
        this.testFile.create((InputStream)contentsStream, true, this.getMonitor());
    }

    private long getLastModificationTimestamp() {
        IPath testFileLocation = this.testFile.getLocation();
        String filePath = testFileLocation.toOSString();
        FileInfo testFileInfo = LocalFileNativesManager.fetchFileInfo((String)filePath);
        return testFileInfo.getLastModified();
    }
}

