/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTest;

public class IFileTest
extends ResourceTest {
    private boolean DISABLED = true;

    public IFileTest() {
    }

    public IFileTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(IFileTest.class);
    }

    public void testBug25658() {
        if (this.DISABLED) {
            return;
        }
        if (!this.isReadOnlySupported()) {
            return;
        }
        if (IFileTest.isWindows()) {
            return;
        }
        IProject project = IFileTest.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        this.ensureExistsInWorkspace(new IResource[]{project, folder}, true);
        IFile file = folder.getFile("file.txt");
        try {
            folder.setReadOnly(true);
            IFileTest.assertTrue((String)"0.0", (boolean)folder.isReadOnly());
            try {
                file.create(this.getRandomContents(), true, this.getMonitor());
                IFileTest.fail((String)"0.1");
            }
            catch (CoreException e) {
                IFileTest.assertEquals((String)"0.2", (int)272, (int)e.getStatus().getCode());
            }
        }
        finally {
            folder.setReadOnly(false);
        }
    }

    public void testBug25662() {
        if (!this.isReadOnlySupported()) {
            return;
        }
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        IProject project = IFileTest.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        this.ensureExistsInWorkspace(new IResource[]{project, folder}, true);
        IFile file = folder.getFile("file.txt");
        try {
            folder.setReadOnly(true);
            IFileTest.assertTrue((String)"0.0", (boolean)folder.isReadOnly());
            try {
                file.create(this.getRandomContents(), true, this.getMonitor());
                IFileTest.fail((String)"0.1");
            }
            catch (CoreException e) {
                IFileTest.assertEquals((String)"0.2", (int)277, (int)e.getStatus().getCode());
            }
        }
        finally {
            folder.setReadOnly(false);
        }
    }

    public void testBug43936() {
        IProject project = IFileTest.getWorkspace().getRoot().getProject("MyProject");
        IFile descFile = project.getFile(".project");
        this.ensureExistsInWorkspace((IResource)project, true);
        IFileTest.assertTrue((String)"1.0", (boolean)descFile.exists());
        IProjectDescription desc = null;
        try {
            desc = project.getDescription();
        }
        catch (CoreException e) {
            IFileTest.fail((String)"1.99", (Throwable)e);
        }
        long newTime = System.currentTimeMillis() + 10000L;
        try {
            descFile.setLocalTimeStamp(newTime);
        }
        catch (CoreException e1) {
            IFileTest.fail((String)"2.99", (Throwable)e1);
        }
        IFileTest.assertTrue((String)"2.0", (boolean)descFile.isSynchronized(0));
        try {
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e2) {
            IFileTest.fail((String)"3.99", (Throwable)e2);
        }
    }
}

