/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.resources.ResourceTest;

public class IResourceTest
extends ResourceTest {
    private boolean DISABLED = true;

    public static Test suite() {
        return new TestSuite(IResourceTest.class);
    }

    public IResourceTest() {
    }

    public IResourceTest(String name) {
        super(name);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        IResourceTest.getWorkspace().getRoot().delete(true, null);
    }

    public void testAppendContents_1G9RBH5() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(null);
            project.open(null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"0.0", (Throwable)e);
        }
        IFile target = project.getFile("file1");
        try {
            target.create(this.getContents("abc"), false, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            target.appendContents(this.getContents("def"), false, true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"2.0", (Throwable)e);
        }
        InputStream content = null;
        try {
            content = target.getContents(false);
            IResourceTest.assertTrue((String)"3.0", (boolean)this.compareContent(content, this.getContents("abcdef")));
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.1", (Throwable)e);
        }
        try {
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testBug25686() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        IFolder outputFolder = project.getFolder("bin");
        IFile description = project.getFile(".project");
        IFile destination = outputFolder.getFile(".project");
        this.ensureExistsInWorkspace(new IResource[]{project, outputFolder}, true);
        IResourceTest.assertTrue((String)"0.0", (boolean)description.exists());
        try {
            description.copy(destination.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"0.99", (Throwable)e);
        }
        IResourceTest.assertTrue((String)"0.1", (boolean)destination.exists());
    }

    public void testBug28790() {
        if (!this.isAttributeSupported(8)) {
            return;
        }
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("a.txt");
        this.ensureExistsInWorkspace(file, this.getRandomString());
        try {
            ResourceAttributes attributes = file.getResourceAttributes();
            attributes.setArchive(false);
            file.setResourceAttributes(attributes);
            IResourceTest.assertTrue((String)"1.0", (!file.getResourceAttributes().isArchive() ? 1 : 0) != 0);
            file.setContents(this.getRandomContents(), 2, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.99", (Throwable)e);
        }
        IResourceTest.assertTrue((String)"2.0", (boolean)file.getResourceAttributes().isArchive());
    }

    public void testBug31750() {
        IResourceProxyVisitor visitor = proxy -> {
            throw new OperationCanceledException();
        };
        try {
            IResourceTest.getWorkspace().getRoot().accept(visitor, 0);
            IResourceTest.fail((String)"1.0");
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"2.0", (Throwable)e);
        }
    }

    public void testBug35991() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("file1");
        this.ensureExistsInWorkspace((IResource)project, true);
        QualifiedName name = new QualifiedName("test", "testBug35991");
        IResourceTest.getWorkspace().getSynchronizer().add(name);
        try {
            IResourceTest.getWorkspace().getSynchronizer().setSyncInfo(name, (IResource)file, new byte[]{1});
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.99", (Throwable)e);
        }
        boolean[] seen = new boolean[1];
        boolean[] phantomSeen = new boolean[1];
        IResourceChangeListener listener = event -> {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            try {
                class DeltaVisitor
                implements IResourceDeltaVisitor {
                    private boolean[] mySeen;
                    private final /* synthetic */ IFile val$file;

                    DeltaVisitor(boolean[] mySeen, IFile iFile) {
                        this.val$file = iFile;
                        this.mySeen = mySeen;
                    }

                    public boolean visit(IResourceDelta aDelta) {
                        if (aDelta.getResource().equals((Object)this.val$file)) {
                            this.mySeen[0] = true;
                        }
                        return true;
                    }
                }
                delta.accept((IResourceDeltaVisitor)new DeltaVisitor(seen, file));
                delta.accept((IResourceDeltaVisitor)new DeltaVisitor(phantomSeen, file), true);
            }
            catch (CoreException e) {
                IResourceTest.fail((String)"1.99", (Throwable)e);
            }
        };
        try {
            IResourceTest.getWorkspace().addResourceChangeListener(listener, 1);
            try {
                IResourceTest.getWorkspace().run(monitor -> {
                    ISynchronizer synchronizer = IResourceTest.getWorkspace().getSynchronizer();
                    synchronizer.flushSyncInfo(name, (IResource)file, 2);
                    synchronizer.setSyncInfo(name, (IResource)file, new byte[]{1});
                }, null, 1, this.getMonitor());
                IResourceTest.assertTrue((String)"1.0", (!seen[0] ? 1 : 0) != 0);
                IResourceTest.assertTrue((String)"1.0", (boolean)phantomSeen[0]);
            }
            catch (CoreException e) {
                IResourceTest.fail((String)"2.99", (Throwable)e);
            }
        }
        finally {
            IResourceTest.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    public void testBug83777() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("testBug83777");
        IFolder folder = project.getFolder("f");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace((IResource)folder, true);
        try {
            folder.setLocal(false, 0, this.getMonitor());
            IResourceTest.assertTrue((String)"1.0", (!project.isSynchronized(2) ? 1 : 0) != 0);
        }
        catch (RuntimeException e) {
            IResourceTest.fail((String)"1.99", (Throwable)e);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"2.99", (Throwable)e);
        }
    }

    public void testBug111821() {
        if (!IResourceTest.isWindows()) {
            return;
        }
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("testBug111821");
        IFolder folder = project.getFolder((IPath)new Path(null, "c:"));
        this.ensureExistsInWorkspace((IResource)project, true);
        QualifiedName partner = new QualifiedName("HowdyThere", "Partner");
        ISynchronizer sync = IResourceTest.getWorkspace().getSynchronizer();
        sync.add(partner);
        try {
            sync.setSyncInfo(partner, (IResource)folder, new byte[]{1});
            IResourceTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
    }

    public void testCopy_1GA6QJP() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        IFile source = project.getFile("file1");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            source.create(this.getContents("abc"), true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"0.0", (Throwable)e);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            IResourceTest.fail((String)"0.99", (Throwable)e);
        }
        Path destinationPath = new Path("copy of file");
        try {
            source.copy((IPath)destinationPath, true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        IFile destination = project.getFile((IPath)destinationPath);
        IResourceTest.assertEquals((String)"2.0", (long)source.getLocation().toFile().lastModified(), (long)destination.getLocation().toFile().lastModified());
        try {
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testCreate_1FW87XF() {
        IProject project;
        block18: {
            IFile anotherFile;
            boolean caseSensitive;
            block17: {
                block16: {
                    String os = Platform.getOS();
                    if (!os.equals("linux")) {
                        IResourceTest.debug((String)"Skipping testCreate_1FW87XF because it is still not supported by the platform.");
                        return;
                    }
                    caseSensitive = new File("abc").compareTo(new File("ABC")) != 0;
                    project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
                    IFile file = project.getFile("file");
                    try {
                        project.create(null);
                        project.open(null);
                        file.create(this.getRandomContents(), true, null);
                    }
                    catch (CoreException e) {
                        IResourceTest.fail((String)"1.0", (Throwable)e);
                    }
                    IResourceTest.assertTrue((String)"2.0", (boolean)file.exists());
                    anotherFile = project.getFile("File");
                    try {
                        anotherFile.create(this.getRandomContents(), true, null);
                        if (!caseSensitive) {
                            IResourceTest.fail((String)"2.1");
                        }
                    }
                    catch (CoreException e) {
                        if (!caseSensitive) break block16;
                        IResourceTest.fail((String)"2.2", (Throwable)e);
                    }
                }
                try {
                    anotherFile.delete(true, false, null);
                }
                catch (CoreException e) {
                    IResourceTest.fail((String)"3.0", (Throwable)e);
                }
                try {
                    anotherFile.create(this.getRandomContents(), false, null);
                    if (!caseSensitive) {
                        IResourceTest.fail((String)"4.0");
                    }
                }
                catch (CoreException e) {
                    if (!caseSensitive) break block17;
                    IResourceTest.fail((String)"4.1", (Throwable)e);
                }
            }
            try {
                anotherFile.refreshLocal(0, this.getMonitor());
                if (!caseSensitive) {
                    IResourceTest.fail((String)"5.0");
                }
            }
            catch (CoreException e) {
                if (!caseSensitive) break block18;
                IResourceTest.fail((String)"5.1", (Throwable)e);
            }
        }
        try {
            project.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"6.0", (Throwable)e);
        }
    }

    public void testCreate_1FWYTKT() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(null);
            project.open(null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < 260) {
            sb.append('a');
            ++i;
        }
        sb.append('b');
        IFolder folder = project.getFolder(sb.toString());
        try {
            folder.create(true, true, null);
            IResourceTest.fail((String)"2.1");
        }
        catch (CoreException coreException) {}
        IResourceTest.assertTrue((String)"2.2", (!folder.exists() ? 1 : 0) != 0);
        IFile file = project.getFile(sb.toString());
        try {
            file.create(this.getRandomContents(), true, null);
            IResourceTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
        IResourceTest.assertTrue((String)"3.1", (!file.exists() ? 1 : 0) != 0);
        try {
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.0", (Throwable)e);
        }
        project = IResourceTest.getWorkspace().getRoot().getProject(sb.toString());
        try {
            project.create(null);
            IResourceTest.fail((String)"4.0");
        }
        catch (CoreException coreException) {}
        IResourceTest.assertTrue((String)"4.1", (!project.exists() ? 1 : 0) != 0);
    }

    public void testCreate_1GD7CSU() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(null);
            project.open(null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        IFile file = project.getFile("MyFile");
        this.ensureExistsInFileSystem(file);
        try {
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"2.0", (Throwable)e);
        }
    }

    public void testDelete_1GD3ZUZ() {
        if (this.DISABLED) {
            return;
        }
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("MyFile");
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        ResourceAttributes attributes = file.getResourceAttributes();
        attributes.setReadOnly(true);
        try {
            file.setResourceAttributes(attributes);
        }
        catch (CoreException e1) {
            IResourceTest.fail((String)"1.99", (Throwable)e1);
        }
        IResourceTest.assertTrue((String)"2.0", (boolean)file.isReadOnly());
        try {
            file.delete(false, this.getMonitor());
            IResourceTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
        attributes = file.getResourceAttributes();
        attributes.setReadOnly(false);
        try {
            file.setResourceAttributes(attributes);
        }
        catch (CoreException e1) {
            IResourceTest.fail((String)"3.99", (Throwable)e1);
        }
        IResourceTest.assertTrue((String)"4.0", (!file.isReadOnly() ? 1 : 0) != 0);
        this.ensureDoesNotExistInWorkspace(new IResource[]{project, file});
    }

    public void testDelete_Bug8754() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        IFile file = project.getFile("MyFile");
        this.ensureExistsInWorkspace(new IResource[]{project, file}, true);
        this.ensureOutOfSync(file);
        try {
            file.delete(false, this.getMonitor());
            IResourceTest.fail((String)"1.0");
        }
        catch (CoreException e) {
            IStatus status = e.getStatus();
            if (status.isMultiStatus()) {
                IStatus[] children = status.getChildren();
                IResourceTest.assertEquals((String)"1.1", (int)1, (int)children.length);
                status = children[0];
            }
            IResourceTest.assertEquals((String)"1.2", (int)274, (int)status.getCode());
        }
        this.ensureDoesNotExistInWorkspace(new IResource[]{project, file});
    }

    public void testEquals_1FUOU25() {
        IFolder folderResource;
        IFile fileResource = IResourceTest.getWorkspace().getRoot().getFile((IPath)new Path("a/b/c/d"));
        IResourceTest.assertTrue((String)"1FUOU25: ITPCORE:ALL - Bug in Resource.equals()", (!fileResource.equals((Object)(folderResource = IResourceTest.getWorkspace().getRoot().getFolder((IPath)new Path("a/b/c/d")))) ? 1 : 0) != 0);
    }

    public void testExists_1FUP8U6() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        try {
            project.create(null);
            project.open(null);
            folder.create(true, true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        IFile file = project.getFile("folder");
        IResourceTest.assertTrue((String)"2.0", (!file.exists() ? 1 : 0) != 0);
        try {
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testFindMember_1GA6QYV() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        IFolder folder1 = project.getFolder("Folder1");
        IFolder folder2 = folder1.getFolder("Folder2");
        IFolder folder3 = folder2.getFolder("Folder3");
        try {
            folder1.create(true, true, this.getMonitor());
            folder2.create(true, true, this.getMonitor());
            folder3.create(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"2.0", (Throwable)e);
        }
        Path targetPath = new Path("Folder2/Folder3");
        IFolder target = (IFolder)folder1.findMember((IPath)targetPath);
        IResourceTest.assertTrue((String)"3.0", (boolean)folder3.equals((Object)target));
        targetPath = new Path("/Folder2/Folder3");
        target = (IFolder)folder1.findMember((IPath)targetPath);
        IResourceTest.assertTrue((String)"4.0", (boolean)folder3.equals((Object)target));
        try {
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testGetContents_1GBZD4S() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(null);
            project.open(null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"0.0", (Throwable)e);
        }
        IFile target = project.getFile("file1");
        String contents = "some random contents";
        try {
            target.create(this.getContents(contents), false, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            InputStream is = target.getContents(false);
            IResourceTest.assertTrue((String)"2.0", (boolean)this.compareContent(this.getContents(contents), is));
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"2.1", (Throwable)e);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            IResourceTest.fail((String)"3.99", (Throwable)e);
        }
        this.createFileInFileSystem(target.getLocation(), this.getContents("some other contents"));
        boolean[] failed = new boolean[1];
        IResourceChangeListener listener = event -> {
            try {
                blArray[0] = true;
                InputStream is = target.getContents(true);
                IResourceTest.assertTrue((String)"4.0", (boolean)this.compareContent(this.getContents("some other contents"), is));
                blArray[0] = false;
            }
            catch (CoreException e) {
                IResourceTest.fail((String)"4.1", (Throwable)e);
            }
        };
        IResourceTest.getWorkspace().addResourceChangeListener(listener);
        try {
            project.touch(null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"4.5", (Throwable)e);
        }
        IResourceTest.getWorkspace().removeResourceChangeListener(listener);
        IResourceTest.assertTrue((String)"4.6", (!failed[0] ? 1 : 0) != 0);
        try {
            target.getContents(false);
            IResourceTest.fail((String)"5.0");
        }
        catch (CoreException e) {
            IResourceTest.assertEquals((String)"5.1", (int)274, (int)e.getStatus().getCode());
        }
        try {
            InputStream is = target.getContents(true);
            IResourceTest.assertTrue((String)"6.0", (boolean)this.compareContent(this.getContents("some other contents"), is));
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"6.1", (Throwable)e);
        }
        try {
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testRefreshLocal_1G60AFG() {
        IProject project = IResourceTest.getWorkspace().getRoot().getProject("MyProject");
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("file");
        try {
            project.create(null);
            project.open(null);
            folder.create(true, true, null);
            file.create(this.getRandomContents(), true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"1.0", (Throwable)e);
        }
        IResourceTest.assertTrue((String)"2.0", (boolean)file.exists());
        try {
            folder.refreshLocal(0, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"2.1", (Throwable)e);
        }
        IResourceTest.assertTrue((String)"2.2", (boolean)file.exists());
        try {
            project.delete(true, true, null);
        }
        catch (CoreException e) {
            IResourceTest.fail((String)"3.0", (Throwable)e);
        }
    }
}

