/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.SortBuilder;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestMultipleBuildersOfSameType
extends WorkspaceSessionTest {
    private IProject project1;
    private IFolder sorted1;
    private IFolder unsorted1;
    private IFile unsortedFile1;

    public TestMultipleBuildersOfSameType() {
    }

    public TestMultipleBuildersOfSameType(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        IWorkspaceRoot root = TestMultipleBuildersOfSameType.getWorkspace().getRoot();
        this.project1 = root.getProject("Project1");
        this.unsorted1 = this.project1.getFolder(SortBuilder.UNSORTED_FOLDER);
        this.sorted1 = this.project1.getFolder(SortBuilder.SORTED_FOLDER);
        this.unsortedFile1 = this.unsorted1.getFile("File1");
    }

    public void test1() {
        IResource[] resources = new IResource[]{this.project1, this.unsorted1, this.sorted1, this.unsortedFile1};
        this.ensureExistsInWorkspace(resources, true);
        try {
            this.unsortedFile1.setContents((InputStream)new ByteArrayInputStream(new byte[]{1, 4, 3}), true, true, null);
            IWorkspace workspace = TestMultipleBuildersOfSameType.getWorkspace();
            IWorkspaceDescription desc = workspace.getDescription();
            desc.setAutoBuilding(false);
            workspace.setDescription(desc);
            IProjectDescription description = this.project1.getDescription();
            description.setBuildSpec(new ICommand[]{this.createCommand(description, "Project1Build1"), this.createCommand(description, "Project1Build2")});
            this.project1.setDescription(description, this.getMonitor());
            workspace.build(10, this.getMonitor());
            TestMultipleBuildersOfSameType.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestMultipleBuildersOfSameType.fail((String)"2.0", (Throwable)e);
        }
    }

    protected ICommand createCommand(IProjectDescription description, String builderId) {
        ICommand command = description.newCommand();
        Map args = command.getArguments();
        args.put("BuildID", builderId);
        command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
        command.setArguments(args);
        return command;
    }

    public void test2() {
        try {
            TestMultipleBuildersOfSameType.getWorkspace().build(10, this.getMonitor());
        }
        catch (CoreException e) {
            TestMultipleBuildersOfSameType.fail((String)"1.99", (Throwable)e);
        }
        SortBuilder[] builders = SortBuilder.allInstances();
        TestMultipleBuildersOfSameType.assertEquals((String)"1.0", (int)2, (int)builders.length);
        TestMultipleBuildersOfSameType.assertTrue((String)"1.1", (boolean)builders[0].wasBuilt());
        TestMultipleBuildersOfSameType.assertTrue((String)"1.2", (boolean)builders[0].wasIncrementalBuild());
        TestMultipleBuildersOfSameType.assertTrue((String)"1.3", (!builders[1].wasBuilt() ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestMultipleBuildersOfSameType.class);
    }
}

