/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class Bug_266907
extends WorkspaceSessionTest {
    private static final String PROJECT_NAME = "Project";
    private static final String FILE_NAME = "File";
    private static final String MARKER_ATTRIBUTE_NAME = "AttributeName";
    private static final String MARKER_ATTRIBUTE = "Attribute";

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", Bug_266907.class);
    }

    public Bug_266907(String name) {
        super(name);
    }

    public void test1stSession() {
        IWorkspace workspace = Bug_266907.getWorkspace();
        IProject project = workspace.getRoot().getProject(PROJECT_NAME);
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e1) {
            Bug_266907.fail((String)"1.0", (Throwable)e1);
        }
        IFile f = project.getFile(FILE_NAME);
        try {
            f.create(this.getContents("content"), true, this.getMonitor());
        }
        catch (CoreException e1) {
            Bug_266907.fail((String)"2.0", (Throwable)e1);
        }
        try {
            IMarker marker = f.createMarker("org.eclipse.core.resources.bookmark");
            marker.setAttribute(MARKER_ATTRIBUTE_NAME, (Object)MARKER_ATTRIBUTE);
        }
        catch (CoreException e2) {
            Bug_266907.fail((String)"3.0", (Throwable)e2);
        }
        File dotProject = project.getFile(".project").getLocation().toFile();
        try {
            workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_266907.fail((String)"4.0", (Throwable)e);
        }
        File dotProjectCopy = this.getTempDir().append("dotProjectCopy").toFile();
        try {
            dotProjectCopy.createNewFile();
            Bug_266907.transferStreams(new FileInputStream(dotProject), new FileOutputStream(dotProjectCopy), null, (IProgressMonitor)new NullProgressMonitor());
            dotProject.delete();
        }
        catch (FileNotFoundException e) {
            Bug_266907.fail((String)"5.0", (Throwable)e);
        }
        catch (IOException e) {
            Bug_266907.fail((String)"5.1", (Throwable)e);
        }
    }

    public void test2ndSession() {
        IWorkspace workspace = Bug_266907.getWorkspace();
        IProject project = workspace.getRoot().getProject(PROJECT_NAME);
        Bug_266907.assertTrue((String)"1.0", (!project.isAccessible() ? 1 : 0) != 0);
        File dotProject = project.getFile(".project").getLocation().toFile();
        File dotProjectCopy = this.getTempDir().append("dotProjectCopy").toFile();
        try {
            dotProject.createNewFile();
            Bug_266907.transferStreams(new FileInputStream(dotProjectCopy), new FileOutputStream(dotProject), null, (IProgressMonitor)new NullProgressMonitor());
            dotProjectCopy.delete();
        }
        catch (IOException e1) {
            Bug_266907.fail((String)"2.0", (Throwable)e1);
        }
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            Bug_266907.fail((String)"3.0", (Throwable)e);
        }
        Bug_266907.assertTrue((String)"4.0", (boolean)project.isAccessible());
        IFile file = project.getFile(FILE_NAME);
        IMarker[] markers = null;
        try {
            markers = file.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
        }
        catch (CoreException e) {
            Bug_266907.fail((String)"5.0", (Throwable)e);
        }
        Bug_266907.assertNotNull((String)"6.0", (Object)markers);
        Bug_266907.assertEquals((String)"6.1", (int)markers.length, (int)1);
        Object attribute = null;
        try {
            attribute = markers[0].getAttribute(MARKER_ATTRIBUTE_NAME);
        }
        catch (CoreException e) {
            Bug_266907.fail((String)"7.0", (Throwable)e);
        }
        Bug_266907.assertEquals((String)"8.0", (Object)attribute, (Object)MARKER_ATTRIBUTE);
    }
}

