/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.File;
import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestBug208833
extends WorkspaceSessionTest {
    public void test1() {
        IWorkspace workspace = TestBug208833.getWorkspace();
        IProject project = workspace.getRoot().getProject("Project1");
        IFile file = project.getFile("file1.txt");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        try {
            workspace.save(true, null);
        }
        catch (CoreException e) {
            TestBug208833.fail((String)"1.0", (Throwable)e);
        }
        TestBug208833.assertTrue((String)"2.0", (boolean)project.getLocation().toFile().renameTo(new File(String.valueOf(project.getLocation().toFile().getAbsolutePath()) + "_temp")));
    }

    public void test2() {
        IWorkspace workspace = TestBug208833.getWorkspace();
        IProject p1 = workspace.getRoot().getProject("Project1");
        TestBug208833.assertTrue((String)"1.0", (boolean)p1.exists());
        TestBug208833.assertTrue((String)"2.0", (!p1.isOpen() ? 1 : 0) != 0);
        TestBug208833.assertTrue((String)"3.0", (boolean)new File(String.valueOf(p1.getLocation().toFile().getAbsolutePath()) + "_temp").renameTo(p1.getLocation().toFile()));
        try {
            p1.open(null);
        }
        catch (CoreException e) {
            TestBug208833.fail((String)"4.0", (Throwable)e);
        }
        TestBug208833.assertTrue((String)"5.0", (boolean)p1.isOpen());
        IFile file1 = p1.getFile("file1.txt");
        TestBug208833.assertTrue((String)"6.0", (boolean)file1.exists());
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestBug208833.class);
    }
}

