/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ContentDescriptionManagerTest;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestBug93473
extends WorkspaceSessionTest {
    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestBug93473.class);
    }

    public TestBug93473(String name) {
        super(name);
    }

    public void test1stSession() {
        IWorkspace workspace = TestBug93473.getWorkspace();
        ContentDescriptionManagerTest.waitForCacheFlush();
        TestBug93473.assertEquals((String)"0.0", (byte)3, (byte)((Workspace)workspace).getContentDescriptionManager().getCacheState());
        IProject project = workspace.getRoot().getProject("proj1");
        this.assertDoesNotExistInWorkspace("0.1", (IResource)project);
        Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        IFile file = project.getFile("foo.txt");
        this.assertDoesNotExistInWorkspace("0.2", (IResource)file);
        this.ensureExistsInWorkspace(file, this.getRandomContents());
        try {
            file.getContentDescription();
        }
        catch (CoreException e) {
            TestBug93473.fail((String)"1.0", (Throwable)e);
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        TestBug93473.assertEquals((String)"2.0", (byte)1, (byte)((Workspace)workspace).getContentDescriptionManager().getCacheState());
        try {
            file.getContentDescription();
        }
        catch (CoreException e) {
            TestBug93473.fail((String)"3.0", (Throwable)e);
        }
        ContentDescriptionManagerTest.waitForCacheFlush();
        TestBug93473.assertEquals((String)"4.0", (byte)2, (byte)((Workspace)workspace).getContentDescriptionManager().getCacheState());
        try {
            workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBug93473.fail((String)"5.0", (Throwable)e);
        }
    }

    public void test2ndSession() {
        TestBug93473.assertEquals((String)"1.0", (byte)2, (byte)((Workspace)TestBug93473.getWorkspace()).getContentDescriptionManager().getCacheState());
    }
}

