/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import junit.framework.Test;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.SortBuilder;
import org.eclipse.core.tests.resources.session.WorkspaceSerializationTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestBuilderDeltaSerialization
extends WorkspaceSerializationTest {
    private IProject project1;
    private IProject project2;
    private IFolder sorted1;
    private IFolder sorted2;
    private IFolder unsorted1;
    private IFolder unsorted2;
    private IFile unsortedFile1;
    private IFile unsortedFile2;

    public TestBuilderDeltaSerialization() {
    }

    public TestBuilderDeltaSerialization(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceRoot root = TestBuilderDeltaSerialization.getWorkspace().getRoot();
        this.project1 = root.getProject("Project1");
        this.unsorted1 = this.project1.getFolder(SortBuilder.UNSORTED_FOLDER);
        this.sorted1 = this.project1.getFolder(SortBuilder.SORTED_FOLDER);
        this.unsortedFile1 = this.unsorted1.getFile("File1");
        this.project2 = root.getProject("Project2");
        this.unsorted2 = this.project2.getFolder(SortBuilder.UNSORTED_FOLDER);
        this.sorted2 = this.project2.getFolder(SortBuilder.SORTED_FOLDER);
        this.unsortedFile2 = this.unsorted2.getFile("File2");
    }

    public void test1() {
        IResource[] resources = new IResource[]{this.project1, this.project2, this.unsorted1, this.unsorted2, this.sorted1, this.sorted2, this.unsortedFile1, this.unsortedFile2};
        this.ensureExistsInWorkspace(resources, true);
        try {
            this.unsortedFile1.setContents((InputStream)new ByteArrayInputStream(new byte[]{1, 4, 3}), true, true, null);
            this.unsortedFile2.setContents((InputStream)new ByteArrayInputStream(new byte[]{1, 4, 3}), true, true, null);
            IWorkspaceDescription desc = this.workspace.getDescription();
            desc.setAutoBuilding(false);
            desc.setBuildOrder(new String[]{this.project1.getName(), this.project2.getName()});
            this.workspace.setDescription(desc);
            IProjectDescription description = this.project1.getDescription();
            ICommand command = description.newCommand();
            Map args = command.getArguments();
            args.put("BuildID", "Project1Build1");
            args.put("InterestingProject", this.project2.getName());
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            command.setArguments(args);
            description.setBuildSpec(new ICommand[]{command});
            this.project1.setDescription(description, this.getMonitor());
            description = this.project1.getDescription();
            command = description.newCommand();
            args = command.getArguments();
            args.put("BuildID", "Project2Build1");
            args.put("InterestingProject", this.project1.getName());
            command.setBuilderName("org.eclipse.core.tests.resources.sortbuilder");
            command.setArguments(args);
            description.setBuildSpec(new ICommand[]{command});
            this.project2.setDescription(description, this.getMonitor());
            this.workspace.build(10, this.getMonitor());
            TestBuilderDeltaSerialization.getWorkspace().save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestBuilderDeltaSerialization.fail((String)"2.0", (Throwable)e);
        }
    }

    public void test2() {
        try {
            TestBuilderDeltaSerialization.getWorkspace().build(10, this.getMonitor());
        }
        catch (CoreException e) {
            TestBuilderDeltaSerialization.fail((String)"1.99", (Throwable)e);
        }
        SortBuilder[] builders = SortBuilder.allInstances();
        TestBuilderDeltaSerialization.assertEquals((String)"1.0", (int)2, (int)builders.length);
        TestBuilderDeltaSerialization.assertTrue((String)"1.1", (boolean)builders[0].wasBuilt());
        TestBuilderDeltaSerialization.assertTrue((String)"1.2", (boolean)builders[0].wasIncrementalBuild());
        TestBuilderDeltaSerialization.assertTrue((String)"1.3", (!builders[1].wasBuilt() ? 1 : 0) != 0);
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestBuilderDeltaSerialization.class);
    }
}

