/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.session.WorkspaceSerializationTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestCloseNoSave
extends WorkspaceSerializationTest {
    public TestCloseNoSave() {
    }

    public TestCloseNoSave(String name) {
        super(name);
    }

    public void test1() throws CoreException {
        IProject project = this.workspace.getRoot().getProject("CrashProject");
        project.create(this.getMonitor());
        project.open(this.getMonitor());
        IFolder folder = project.getFolder("CrashFolder");
        folder.create(true, true, this.getMonitor());
        IFile file = folder.getFile("CrashFile");
        file.create(this.getRandomContents(), true, this.getMonitor());
    }

    public void test2() throws CoreException {
        IResource[] members = this.workspace.getRoot().members();
        TestCloseNoSave.assertEquals((String)"1.0", (int)1, (int)members.length);
        TestCloseNoSave.assertTrue((String)"1.1", (members[0].getType() == 4 ? 1 : 0) != 0);
        IProject project = (IProject)members[0];
        TestCloseNoSave.assertTrue((String)"1.2", (boolean)project.exists());
        IFolder folder = project.getFolder("CrashFolder");
        IFile file = folder.getFile("CrashFile");
        if (!project.isOpen()) {
            project.open(null);
        }
        TestCloseNoSave.assertEquals((String)"2.0", (int)2, (int)project.members().length);
        TestCloseNoSave.assertTrue((String)"2.1", (boolean)folder.exists());
        TestCloseNoSave.assertTrue((String)"2.2", (boolean)file.exists());
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestCloseNoSave.class);
    }
}

