/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.session.WorkspaceSerializationTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestCreateLinkedResourceInHiddenProject
extends WorkspaceSerializationTest {
    public TestCreateLinkedResourceInHiddenProject() {
    }

    public TestCreateLinkedResourceInHiddenProject(String name) {
        super(name);
    }

    public void test1() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("CrashProject");
        try {
            ProjectDescription desc = new ProjectDescription();
            desc.setName("CrashProject");
            project.create((IProjectDescription)desc, 4096, this.getMonitor());
            project.open(this.getMonitor());
            this.workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            TestCreateLinkedResourceInHiddenProject.fail((String)"1.0", (Throwable)e);
        }
    }

    public void test2() {
        IPath path = this.getTempDir().addTrailingSeparator().append(this.getUniqueString());
        path.toFile().mkdir();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("CrashProject");
        IFolder folder = project.getFolder(this.getUniqueString());
        try {
            folder.createLink(path, 0, this.getMonitor());
        }
        catch (CoreException e) {
            TestCreateLinkedResourceInHiddenProject.fail((String)"2.0", (Throwable)e);
        }
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestCreateLinkedResourceInHiddenProject.class);
    }
}

