/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.session.WorkspaceSerializationTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class TestSaveCreateProject
extends WorkspaceSerializationTest {
    public TestSaveCreateProject() {
    }

    public TestSaveCreateProject(String name) {
        super(name);
    }

    public void test1() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("CrashProject");
        try {
            this.workspace.save(true, this.getMonitor());
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            TestSaveCreateProject.fail((String)"1.0", (Throwable)e);
        }
    }

    public void test2() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        TestSaveCreateProject.assertTrue((String)"1.0", (boolean)root.exists());
        try {
            IResource[] children = root.members();
            TestSaveCreateProject.assertEquals((String)"1.2", (int)1, (int)children.length);
            IProject project = (IProject)children[0];
            TestSaveCreateProject.assertTrue((String)"1.3", (boolean)project.exists());
            TestSaveCreateProject.assertEquals((String)"1.4", (String)"CrashProject", (String)project.getName());
        }
        catch (CoreException e) {
            TestSaveCreateProject.fail((String)"1.99", (Throwable)e);
        }
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", TestSaveCreateProject.class);
    }
}

