/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.session;

import junit.framework.Test;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.WorkspaceSessionTest;
import org.eclipse.core.tests.session.WorkspaceSessionTestSuite;

public class WorkspaceDescriptionTest
extends WorkspaceSessionTest {
    private static final String[] BUILD_ORDER = new String[]{"Foo"};
    private static final boolean APPLY_POLICY = false;
    private static final int STATE_LONGEVITY = 123456;
    private static final int MAX_STATES = 244;
    private static final long MAX_FILE_SIZE = 54272L;
    private static final long SNAPSHOT_INTERVAL = 4321L;

    public WorkspaceDescriptionTest() {
    }

    public WorkspaceDescriptionTest(String name) {
        super(name);
    }

    public void test1() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        desc.setAutoBuilding(false);
        desc.setBuildOrder(BUILD_ORDER);
        desc.setApplyFileStatePolicy(false);
        desc.setFileStateLongevity(123456L);
        desc.setMaxFileStates(244);
        desc.setMaxFileStateSize(54272L);
        desc.setSnapshotInterval(4321L);
        try {
            workspace.setDescription(desc);
            workspace.save(true, this.getMonitor());
        }
        catch (CoreException e) {
            WorkspaceDescriptionTest.fail((String)"1.0", (Throwable)e);
        }
    }

    public void test2() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        WorkspaceDescriptionTest.assertTrue((String)"2.0", (!desc.isAutoBuilding() ? 1 : 0) != 0);
        this.assertEquals("2.1", BUILD_ORDER, desc.getBuildOrder());
        WorkspaceDescriptionTest.assertEquals((String)"2.2", (boolean)false, (boolean)desc.isApplyFileStatePolicy());
        WorkspaceDescriptionTest.assertEquals((String)"2.3", (long)123456L, (long)desc.getFileStateLongevity());
        WorkspaceDescriptionTest.assertEquals((String)"2.4", (int)244, (int)desc.getMaxFileStates());
        WorkspaceDescriptionTest.assertEquals((String)"2.5", (long)54272L, (long)desc.getMaxFileStateSize());
        WorkspaceDescriptionTest.assertEquals((String)"2.6", (long)4321L, (long)desc.getSnapshotInterval());
    }

    public static Test suite() {
        return new WorkspaceSessionTestSuite("org.eclipse.core.tests.resources", WorkspaceDescriptionTest.class);
    }
}

