/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.usecase.IResourceTest;

public class IFolderTest
extends IResourceTest {
    public IFolderTest() {
        super(null);
    }

    public IFolderTest(String name) {
        super(name);
    }

    protected void nonexistentFolderFailureTests(IFolder folder, IContainer parent, IWorkspace wb) {
        String method = "nonexistentFolderFailureTests(IFolder,IWorkspace)";
        this.commonFailureTestsForResource((IResource)folder, false);
        IFolderTest.assertTrue((String)(String.valueOf(method) + "4.0"), (parent.findMember(folder.getName()) == null ? 1 : 0) != 0);
        try {
            IResource[] members = parent.members();
            int i = 0;
            while (i < members.length) {
                IFolderTest.assertTrue((String)("4.1: i=" + i), (!members[i].getName().equals(folder.getName()) ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (CoreException coreException) {
            IFolderTest.assertTrue((String)(String.valueOf(method) + "4.2"), (boolean)false);
        }
        IFolderTest.assertTrue((String)(String.valueOf(method) + "5"), (!wb.getRoot().exists(folder.getFullPath()) ? 1 : 0) != 0);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(IFolderTest.class.getName());
        suite.addTest((Test)new IFolderTest("testFolder"));
        return suite;
    }

    public void testFolder() {
        Path path;
        IProgressMonitor monitor = null;
        IWorkspace workspace = IFolderTest.getWorkspace();
        IProject proj = workspace.getRoot().getProject(PROJECT);
        IFolder folder = proj.getFolder((IPath)(path = new Path(FOLDER)));
        IFolderTest.assertTrue((String)"2.1", (!folder.exists() ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"2.2", (boolean)folder.getWorkspace().equals(workspace));
        IFolderTest.assertTrue((String)"2.4", (boolean)folder.getProject().equals((Object)proj));
        IFolderTest.assertTrue((String)"2.5", (folder.getType() == 2 ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"2.6", (boolean)folder.getFullPath().equals((Object)new Path("/" + PROJECT + "/" + FOLDER)));
        IFolderTest.assertTrue((String)"2.7", (boolean)folder.getName().equals(FOLDER));
        IFolderTest.assertTrue((String)"2.8", (boolean)workspace.getRoot().getFolder(folder.getFullPath()).equals((Object)folder));
        IFolderTest.assertTrue((String)"2.10", (boolean)proj.getFolder((IPath)path).equals((Object)folder));
        IFolderTest.assertTrue((String)"2.11", (boolean)folder.getParent().equals((Object)proj));
        IFolderTest.assertTrue((String)"2.13", (boolean)folder.getProjectRelativePath().equals((Object)new Path(FOLDER)));
        try {
            proj.create(monitor);
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"3", (Throwable)e);
        }
        this.unopenedProjectFailureTests(folder, (IContainer)proj, workspace);
        try {
            proj.open(monitor);
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"4", (Throwable)e);
        }
        this.nonexistentFolderFailureTests(folder, (IContainer)proj, workspace);
        Path absolutePath = new Path(String.valueOf(proj.getLocation().toOSString()) + "/" + FOLDER);
        IFolderTest.assertTrue((String)"5", (boolean)folder.getLocation().equals((Object)absolutePath));
        try {
            folder.create(false, true, monitor);
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"6", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"7.0", (boolean)folder.exists());
        IFolderTest.assertTrue((String)"7.1", (boolean)workspace.getRoot().findMember(folder.getFullPath()).exists());
        IFolderTest.assertTrue((String)"7.3", (boolean)workspace.getRoot().findMember(folder.getFullPath()).equals((Object)folder));
        IFolderTest.assertTrue((String)"7.4", (boolean)workspace.getRoot().exists(folder.getFullPath()));
        IFolderTest.assertTrue((String)"7.5", (boolean)folder.getLocation().equals((Object)absolutePath));
        try {
            IFolderTest.assertTrue((String)"8.0", (folder.getSessionProperty(Q_NAME_SESSION) == null ? 1 : 0) != 0);
        }
        catch (CoreException coreException) {
            IFolderTest.fail((String)"8.1");
        }
        try {
            folder.setSessionProperty(Q_NAME_SESSION, (Object)STRING_VALUE);
        }
        catch (CoreException coreException) {
            IFolderTest.fail((String)"8.2");
        }
        try {
            IFolderTest.assertTrue((String)"8.3", (boolean)folder.getSessionProperty(Q_NAME_SESSION).equals(STRING_VALUE));
        }
        catch (CoreException coreException) {
            IFolderTest.fail((String)"8.4");
        }
        try {
            folder.setSessionProperty(Q_NAME_SESSION, null);
        }
        catch (CoreException coreException) {
            IFolderTest.fail((String)"8.5");
        }
        try {
            IFolderTest.assertTrue((String)"8.6", (folder.getSessionProperty(Q_NAME_SESSION) == null ? 1 : 0) != 0);
        }
        catch (CoreException coreException) {
            IFolderTest.fail((String)"8.7");
        }
        IFolderTest.assertTrue((String)"9.1", (boolean)folder.isLocal(0));
        IFolderTest.assertTrue((String)"9.2", (boolean)folder.isLocal(1));
        IFolderTest.assertTrue((String)"9.3", (boolean)folder.isLocal(2));
        IFolderTest.assertTrue((String)"9.4", (boolean)proj.isLocal(1));
        IFolderTest.assertTrue((String)"9.5", (boolean)proj.isLocal(2));
        IFolder nestedFolder = IFolderTest.getWorkspace().getRoot().getFolder(folder.getFullPath().append(FOLDER));
        IFolderTest.assertTrue((String)"10.0", (!nestedFolder.exists() ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"10.1", (boolean)nestedFolder.getWorkspace().equals(workspace));
        IFolderTest.assertTrue((String)"10.3", (boolean)nestedFolder.getProject().equals((Object)proj));
        IFolderTest.assertTrue((String)"10.4", (nestedFolder.getType() == 2 ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"10.5", (boolean)nestedFolder.getFullPath().equals((Object)new Path("/" + PROJECT + "/" + FOLDER + "/" + FOLDER)));
        IFolderTest.assertTrue((String)"10.6", (boolean)nestedFolder.getName().equals(FOLDER));
        IFolderTest.assertTrue((String)"10.7", (boolean)workspace.getRoot().getFolder(nestedFolder.getFullPath()).equals((Object)nestedFolder));
        Path projRelativePath = new Path(String.valueOf(FOLDER) + "/" + FOLDER);
        IFolderTest.assertTrue((String)"10.9", (boolean)proj.getFolder((IPath)projRelativePath).equals((Object)nestedFolder));
        IFolderTest.assertTrue((String)"10.10", (boolean)nestedFolder.getParent().equals((Object)folder));
        IFolderTest.assertTrue((String)"10.11", (boolean)nestedFolder.getProjectRelativePath().equals((Object)new Path(String.valueOf(FOLDER) + "/" + FOLDER)));
        IFolderTest.assertTrue((String)"10.12", (boolean)folder.isLocal(1));
        IFolderTest.assertTrue((String)"10.13", (boolean)folder.isLocal(2));
        this.nonexistentFolderFailureTests(nestedFolder, (IContainer)folder, workspace);
        try {
            nestedFolder.create(false, true, monitor);
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"11", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"12.0", (boolean)workspace.getRoot().exists(nestedFolder.getFullPath()));
        IFolderTest.assertTrue((String)"12.1", (boolean)nestedFolder.exists());
        IFolderTest.assertTrue((String)"12.2", (boolean)folder.findMember(nestedFolder.getName()).exists());
        IFolderTest.assertTrue((String)"12.4", (boolean)workspace.getRoot().findMember(nestedFolder.getFullPath()).equals((Object)nestedFolder));
        IFolderTest.assertTrue((String)"12.5", (boolean)workspace.getRoot().exists(nestedFolder.getFullPath()));
        IFolderTest.assertTrue((String)"12.6", (boolean)nestedFolder.getLocation().equals((Object)absolutePath.append(FOLDER)));
        try {
            nestedFolder.delete(false, monitor);
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"13.0", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"13.1", (!nestedFolder.exists() ? 1 : 0) != 0);
        try {
            IFolderTest.assertTrue((String)"13.2", (folder.members().length == 0 ? 1 : 0) != 0);
        }
        catch (CoreException coreException) {
            IFolderTest.fail((String)"13.3");
        }
        IFolderTest.assertTrue((String)"13.4", (workspace.getRoot().findMember(nestedFolder.getFullPath()) == null ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"13.5", (!workspace.getRoot().exists(nestedFolder.getFullPath()) ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"13.6", (boolean)nestedFolder.getLocation().equals((Object)absolutePath.append(FOLDER)));
        this.nonexistentFolderFailureTests(nestedFolder, (IContainer)folder, workspace);
        IFolderTest.assertTrue((String)"14.0", (boolean)folder.exists());
        IFolderTest.assertTrue((String)"14.1", (boolean)workspace.getRoot().findMember(folder.getFullPath()).exists());
        IFolderTest.assertTrue((String)"14.3", (boolean)workspace.getRoot().findMember(folder.getFullPath()).equals((Object)folder));
        IFolderTest.assertTrue((String)"14.4", (boolean)workspace.getRoot().exists(folder.getFullPath()));
        IFolderTest.assertTrue((String)"14.5", (boolean)folder.getLocation().equals((Object)absolutePath));
        try {
            folder.delete(false, monitor);
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"15.0", (Throwable)e);
        }
        IFolderTest.assertTrue((String)"15.1", (!folder.exists() ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"15.4", (workspace.getRoot().findMember(folder.getFullPath()) == null ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"15.5", (!workspace.getRoot().exists(folder.getFullPath()) ? 1 : 0) != 0);
        IFolderTest.assertTrue((String)"15.6", (boolean)folder.getLocation().equals((Object)absolutePath));
        this.nonexistentFolderFailureTests(folder, (IContainer)proj, workspace);
        try {
            proj.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            IFolderTest.fail((String)"20.0", (Throwable)e);
        }
    }

    protected void unopenedProjectFailureTests(IFolder folder, IContainer parent, IWorkspace wb) {
        String method = "unopenedProjectFailureTests(IFolder,IWorkspace)";
        IProgressMonitor monitor = null;
        try {
            folder.create(false, true, monitor);
            IFolderTest.fail((String)(String.valueOf(method) + "1"));
        }
        catch (CoreException coreException) {}
        IFolderTest.assertTrue((String)(String.valueOf(method) + "2"), (!wb.getRoot().exists(folder.getFullPath()) ? 1 : 0) != 0);
    }
}

