/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.usecase.SignaledBuilder;

public class IWorkspaceRunnableUseCaseTest
extends ResourceTest {
    public IWorkspaceRunnableUseCaseTest() {
    }

    public IWorkspaceRunnableUseCaseTest(String name) {
        super(name);
    }

    protected IWorkspaceRunnable createRunnable(IProject project, IWorkspaceRunnable nestedOperation, boolean triggerBuild, Exception exceptionToThrow) {
        return monitor -> {
            if (exceptionToThrow != null) {
                if (exceptionToThrow instanceof CoreException) {
                    throw (CoreException)((Object)((Object)exceptionToThrow));
                }
                if (exceptionToThrow instanceof RuntimeException) {
                    throw (RuntimeException)exceptionToThrow;
                }
                throw new IllegalArgumentException(exceptionToThrow);
            }
            if (triggerBuild) {
                project.touch(this.getMonitor());
            }
            if (nestedOperation != null) {
                IWorkspaceRunnableUseCaseTest.getWorkspace().run(nestedOperation, this.getMonitor());
            }
        };
    }

    public static Test suite() {
        return new TestSuite(IWorkspaceRunnableUseCaseTest.class);
    }

    public void testNestedOperationsAndBuilds() {
        IWorkspaceDescription original = IWorkspaceRunnableUseCaseTest.getWorkspace().getDescription();
        IProject project = IWorkspaceRunnableUseCaseTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            IWorkspaceDescription description = IWorkspaceRunnableUseCaseTest.getWorkspace().getDescription();
            description.setAutoBuilding(true);
            IWorkspaceRunnableUseCaseTest.getWorkspace().setDescription(description);
            IProjectDescription prjDescription = IWorkspaceRunnableUseCaseTest.getWorkspace().newProjectDescription("MyProject");
            ICommand command = prjDescription.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.sigbuilder");
            prjDescription.setBuildSpec(new ICommand[]{command});
            project.create(prjDescription, this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"0.0", (Throwable)e);
        }
        this.waitForBuild();
        SignaledBuilder builder = SignaledBuilder.getInstance(project);
        IWorkspaceRunnable op1 = this.createRunnable(project, null, true, null);
        IWorkspaceRunnable op2 = this.createRunnable(project, op1, false, null);
        IWorkspaceRunnable op3 = this.createRunnable(project, op2, false, null);
        builder.reset();
        try {
            IWorkspaceRunnableUseCaseTest.getWorkspace().run(op3, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"1.0", (Throwable)e);
        }
        this.waitForBuild();
        IWorkspaceRunnableUseCaseTest.assertTrue((String)"1.1", (boolean)builder.wasExecuted());
        op1 = this.createRunnable(project, null, true, (Exception)((Object)new OperationCanceledException()));
        op2 = this.createRunnable(project, op1, true, null);
        op3 = this.createRunnable(project, op2, true, null);
        builder.reset();
        try {
            IWorkspaceRunnableUseCaseTest.getWorkspace().run(op3, this.getMonitor());
            IWorkspaceRunnableUseCaseTest.fail((String)"2.0");
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"2.1", (Throwable)e);
        }
        catch (OperationCanceledException operationCanceledException) {}
        IWorkspaceRunnableUseCaseTest.assertTrue((String)"2.2", (!builder.wasExecuted() ? 1 : 0) != 0);
        op1 = this.createRunnable(project, null, true, (Exception)((Object)new CoreException(Status.CANCEL_STATUS)));
        op2 = this.createRunnable(project, op1, true, null);
        op3 = this.createRunnable(project, op2, true, null);
        builder.reset();
        try {
            IWorkspaceRunnableUseCaseTest.getWorkspace().run(op3, this.getMonitor());
            IWorkspaceRunnableUseCaseTest.fail((String)"3.0");
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.assertEquals((Object)Status.CANCEL_STATUS, (Object)e.getStatus());
        }
        IWorkspaceRunnableUseCaseTest.assertTrue((String)"3.1", (!builder.wasExecuted() ? 1 : 0) != 0);
        op1 = this.createRunnable(project, null, false, null);
        op2 = this.createRunnable(project, op1, false, null);
        op3 = this.createRunnable(project, op2, false, null);
        builder.reset();
        try {
            IWorkspaceRunnableUseCaseTest.getWorkspace().run(op3, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"4.0", (Throwable)e);
        }
        IWorkspaceRunnableUseCaseTest.assertTrue((String)"4.1", (!builder.wasExecuted() ? 1 : 0) != 0);
        try {
            project.delete(true, this.getMonitor());
            IWorkspaceRunnableUseCaseTest.getWorkspace().setDescription(original);
        }
        catch (CoreException e) {
            IWorkspaceRunnableUseCaseTest.fail((String)"20.0", (Throwable)e);
        }
    }
}

