/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.usecase.SnapshotTest;

public class Snapshot1Test
extends SnapshotTest {
    public Snapshot1Test() {
    }

    public Snapshot1Test(String name) {
        super(name);
    }

    protected static String[] defineHierarchy1() {
        return new String[]{"/folder110/", "/folder110/folder120/", "/folder110/folder120/folder130/", "/folder110/folder120/folder130/folder140/", "/folder110/folder120/folder130/folder140/folder150/", "/folder110/folder120/folder130/folder140/folder150/file160", "/folder110/folder120/folder130/folder140/file150", "/folder110/folder121/", "/folder110/folder121/folder131/", "/folder110/folder120/folder130/folder141/"};
    }

    protected static String[] defineHierarchy2() {
        return new String[]{"/file110", "/folder110/", "/folder110/file120", "/folder111/", "/folder111/folder120/", "/folder111/file121"};
    }

    public void testCreateMyProject() {
        IProject project = Snapshot1Test.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(null);
            project.open(null);
        }
        catch (CoreException e) {
            Snapshot1Test.fail((String)"0.0", (Throwable)e);
        }
        Snapshot1Test.assertTrue((String)"0.1", (boolean)project.exists());
        Snapshot1Test.assertTrue((String)"0.2", (boolean)project.isOpen());
        IResource[] resources = this.buildResources((IContainer)project, Snapshot1Test.defineHierarchy1());
        this.ensureExistsInWorkspace(resources, true);
        this.assertExistsInFileSystem("1.1", resources);
        this.assertExistsInWorkspace("1.2", resources);
        try {
            project.close(null);
        }
        catch (CoreException e) {
            Snapshot1Test.fail((String)"2.0", (Throwable)e);
        }
        Snapshot1Test.assertTrue((String)"2.1", (boolean)project.exists());
        Snapshot1Test.assertTrue((String)"2.2", (!project.isOpen() ? 1 : 0) != 0);
    }

    public void testCreateProject2() {
        IProject project = Snapshot1Test.getWorkspace().getRoot().getProject("Project2");
        try {
            project.create(null);
            project.open(null);
        }
        catch (CoreException e) {
            Snapshot1Test.fail((String)"0.0", (Throwable)e);
        }
        Snapshot1Test.assertTrue((String)"0.1", (boolean)project.exists());
        Snapshot1Test.assertTrue((String)"0.2", (boolean)project.isOpen());
        IResource[] resources = this.buildResources((IContainer)project, Snapshot1Test.defineHierarchy2());
        this.ensureExistsInWorkspace(resources, true);
        this.assertExistsInFileSystem("3.1", resources);
        this.assertExistsInWorkspace("3.2", resources);
    }

    public void testSnapshotWorkspace() {
        try {
            Snapshot1Test.getWorkspace().save(false, null);
        }
        catch (CoreException e) {
            Snapshot1Test.fail((String)"1.0", (Throwable)e);
        }
    }
}

