/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.usecase;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.usecase.Snapshot4Test;
import org.eclipse.core.tests.resources.usecase.SnapshotTest;

public class Snapshot5Test
extends SnapshotTest {
    public Snapshot5Test() {
    }

    public Snapshot5Test(String name) {
        super(name);
    }

    public void testVerifyPreviousSession() {
        IProject project = Snapshot5Test.getWorkspace().getRoot().getProject("MyProject");
        Snapshot5Test.assertTrue((String)"0.0", (boolean)project.exists());
        Snapshot5Test.assertTrue((String)"0.1", (boolean)project.isOpen());
        IResource[] resources = this.buildResources((IContainer)project, Snapshot4Test.defineHierarchy1());
        this.assertExistsInFileSystem("2.1", resources);
        this.assertExistsInWorkspace("2.2", resources);
        IFile file = project.getFile("added file");
        this.assertDoesNotExistInFileSystem("2.3", (IResource)file);
        this.assertDoesNotExistInWorkspace("2.4", (IResource)file);
        file = project.getFile("yet another file");
        this.assertDoesNotExistInFileSystem("2.5", (IResource)file);
        this.assertDoesNotExistInWorkspace("2.6", (IResource)file);
        IFolder folder = project.getFolder("a folder");
        this.assertDoesNotExistInFileSystem("2.7", (IResource)folder);
        this.assertDoesNotExistInWorkspace("2.8", (IResource)folder);
        project = Snapshot5Test.getWorkspace().getRoot().getProject("Project2");
        Snapshot5Test.assertTrue((String)"3.0", (!project.exists() ? 1 : 0) != 0);
    }

    public void cleanUp() {
        try {
            this.ensureDoesNotExistInWorkspace((IResource)Snapshot5Test.getWorkspace().getRoot());
            Snapshot5Test.getWorkspace().save(true, null);
        }
        catch (CoreException e) {
            Snapshot5Test.fail((String)"1.0", (Throwable)e);
        }
    }
}

