/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.launcher;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.examples.ui.pda.DebugUIPlugin;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class MidiMainTab
extends AbstractLaunchConfigurationTab {
    private Text fFileText;
    private Button fFileButton;
    private Button fExceptions;
    private Button fHandled;
    private Button fUnhandled;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createVerticalSpacer(comp, 3);
        Label programLabel = new Label(comp, 0);
        programLabel.setText("&Midi File:");
        GridData gd = new GridData(1);
        programLabel.setLayoutData((Object)gd);
        programLabel.setFont(font);
        this.fFileText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fFileText.setLayoutData((Object)gd);
        this.fFileText.setFont(font);
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MidiMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fFileButton = this.createPushButton(comp, "&Browse...", null);
        this.fFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidiMainTab.this.browseMidiFiles();
            }
        });
        new Label(comp, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        Group test = new Group(comp, 0);
        test.setText("Exceptions");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        test.setLayoutData((Object)gd);
        test.setLayout((Layout)new GridLayout());
        this.fExceptions = new Button((Composite)test, 32);
        this.fExceptions.setText("&Throw an exception during launch for testing purposes");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.fExceptions.setLayoutData((Object)gd);
        this.fExceptions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidiMainTab.this.fHandled.setEnabled(MidiMainTab.this.fExceptions.getSelection());
                MidiMainTab.this.fUnhandled.setEnabled(MidiMainTab.this.fExceptions.getSelection());
                MidiMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fHandled = new Button((Composite)test, 16);
        this.fHandled.setText("Throw a handled e&xception during launch to re-open launch dialog");
        SelectionAdapter sa = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidiMainTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.fHandled.addSelectionListener((SelectionListener)sa);
        this.fUnhandled = new Button((Composite)test, 16);
        this.fUnhandled.setText("Throw an &unhandled exception during launch to open error dialog");
        this.fUnhandled.addSelectionListener((SelectionListener)sa);
    }

    protected void browseMidiFiles() {
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle("MIDI File");
        dialog.setMessage("Select MIDI File");
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            IFile file = (IFile)files[0];
            this.fFileText.setText(file.getFullPath().toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String excep;
            String file = null;
            file = configuration.getAttribute("midi.file", null);
            if (file != null) {
                this.fFileText.setText(file);
            }
            this.fExceptions.setSelection((excep = configuration.getAttribute("throw.exception", null)) != null);
            this.fHandled.setEnabled(excep != null);
            this.fUnhandled.setEnabled(excep != null);
            if (excep != null) {
                this.fHandled.setSelection(excep.equals("HANDLED"));
                this.fUnhandled.setSelection(excep.equals("UNHANDLED"));
            } else {
                this.fHandled.setSelection(true);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String file = this.fFileText.getText().trim();
        if (file.length() == 0) {
            file = null;
        }
        IResource[] resources = null;
        if (file != null) {
            Path path = new Path(file);
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res != null) {
                resources = new IResource[]{res};
            }
        }
        configuration.setAttribute("midi.file", file);
        configuration.setMappedResources(resources);
        if (this.fExceptions.getSelection()) {
            if (this.fHandled.getSelection()) {
                configuration.setAttribute("throw.exception", "HANDLED");
            } else {
                configuration.setAttribute("throw.exception", "UNHANDLED");
            }
        } else {
            configuration.removeAttribute("throw.exception");
        }
    }

    public String getName() {
        return "Main";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String text = this.fFileText.getText();
        if (text.length() > 0) {
            Path path = new Path(text);
            if (ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path) == null) {
                this.setErrorMessage("File does not exist");
                return false;
            }
        } else {
            this.setMessage("Select a MIDI file");
        }
        return true;
    }

    public Image getImage() {
        return DebugUIPlugin.getDefault().getImageRegistry().get("IMB_OBJ_MIDI");
    }
}

