/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.pda.breakpoints;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.examples.ui.pda.breakpoints.PDAToggleWatchpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class PDAToggleWatchpointsTargetFactory
implements IToggleBreakpointsTargetFactory {
    private static final String TOGGLE_WATCHPOINT_TARGET_ACCESS = "org.eclipse.debug.examples.ui.pda.watchpoint_access";
    private static final String TOGGLE_WATCHPOINT_TARGET_MODIFICATION = "org.eclipse.debug.examples.ui.pda.watchpoint_modification";
    private static final String TOGGLE_WATCHPOINT_TARGET_BOTH = "org.eclipse.debug.examples.ui.pda.watchpoint_both";
    private static Set<String> TOGGLE_WATCHPOINTS_TARGETS = new LinkedHashSet<String>();
    private final Map<String, IToggleBreakpointsTarget> fToggleWatchpointTargets = new HashMap<String, IToggleBreakpointsTarget>(3);

    static {
        TOGGLE_WATCHPOINTS_TARGETS.add(TOGGLE_WATCHPOINT_TARGET_BOTH);
        TOGGLE_WATCHPOINTS_TARGETS.add(TOGGLE_WATCHPOINT_TARGET_ACCESS);
        TOGGLE_WATCHPOINTS_TARGETS.add(TOGGLE_WATCHPOINT_TARGET_MODIFICATION);
    }

    public IToggleBreakpointsTarget createToggleTarget(String targetID) {
        Object target = this.fToggleWatchpointTargets.get(targetID);
        if (target == null) {
            if (TOGGLE_WATCHPOINT_TARGET_BOTH.equals(targetID)) {
                target = new PDAToggleWatchpointsTarget(true, true);
            } else if (TOGGLE_WATCHPOINT_TARGET_ACCESS.equals(targetID)) {
                target = new PDAToggleWatchpointsTarget(true, false);
            } else if (TOGGLE_WATCHPOINT_TARGET_MODIFICATION.equals(targetID)) {
                target = new PDAToggleWatchpointsTarget(false, true);
            } else {
                return null;
            }
            this.fToggleWatchpointTargets.put(targetID, (IToggleBreakpointsTarget)target);
        }
        return target;
    }

    public String getDefaultToggleTarget(IWorkbenchPart part, ISelection selection) {
        return TOGGLE_WATCHPOINT_TARGET_BOTH;
    }

    public Set<String> getToggleTargets(IWorkbenchPart part, ISelection selection) {
        return TOGGLE_WATCHPOINTS_TARGETS;
    }

    public String getToggleTargetName(String targetID) {
        if (TOGGLE_WATCHPOINT_TARGET_BOTH.equals(targetID)) {
            return "Watchpoints (Read/Write)";
        }
        if (TOGGLE_WATCHPOINT_TARGET_ACCESS.equals(targetID)) {
            return "Watchpoints (Read)";
        }
        if (TOGGLE_WATCHPOINT_TARGET_MODIFICATION.equals(targetID)) {
            return "Watchpoints (Write)";
        }
        return null;
    }

    public String getToggleTargetDescription(String targetID) {
        return this.getToggleTargetName(targetID);
    }
}

