/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.tests.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchManager;
import org.eclipse.debug.tests.launching.AbstractLaunchTest;
import org.eclipse.debug.tests.launching.CancellingLaunchDelegate;

public class LaunchManagerTests
extends AbstractLaunchTest {
    public LaunchManagerTests(String name) {
        super(name);
    }

    public void testGenereateConfigName() {
        String configname = "launch_configuration";
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertTrue((String)("the name nust be '" + configname + "'"), (boolean)name.equals(configname));
    }

    public void testGenereateConfigNameBadChar() {
        String configname = "config:name";
        String name = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configname);
        LaunchManagerTests.assertEquals((String)("config name should be '" + configname + "'"), (String)configname, (String)name);
    }

    public void testGenerateValidName() {
        String configname = "thisisavalidname";
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)"Should be the same as the seed", (String)configname, (String)name);
    }

    public void testGenerateConfigNameReservedName() {
        if ("win32".equals(Platform.getOS())) {
            String configname = "aux";
            String name = this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(configname);
            LaunchManagerTests.assertEquals((String)"config name should be 'aux'", (String)configname, (String)name);
        }
    }

    public void testGenerateBadConfigName() {
        String configname = "config:name";
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)"config name should be 'config_name'", (String)"config_name", (String)name);
    }

    public void testGenerateConflictingName() {
        if ("win32".equals(Platform.getOS())) {
            String configname = "aux";
            String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
            LaunchManagerTests.assertEquals((String)"config name should be 'launch_configuration'", (String)"launch_configuration", (String)name);
        }
    }

    public void testGenerateBadCharConflict() throws Exception {
        String configname = "config:name";
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)"config name should be 'config_name'", (String)"config_name", (String)name);
        this.getLaunchConfiguration(name);
        name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)"config name should be 'config_name (1)'", (String)"config_name (1)", (String)name);
        ILaunchConfiguration config = this.getLaunchConfiguration("config_name");
        config.delete();
    }

    public void testGenerateBadNameConflict() throws Exception {
        if ("win32".equals(Platform.getOS())) {
            String configname = "com2";
            String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
            LaunchManagerTests.assertEquals((String)"config name should be 'launch_configuration'", (String)"launch_configuration", (String)name);
            this.getLaunchConfiguration(name);
            name = this.getLaunchManager().generateLaunchConfigurationName(configname);
            LaunchManagerTests.assertEquals((String)"config name should be 'launch_configuration (1)'", (String)"launch_configuration (1)", (String)name);
            ILaunchConfiguration config = this.getLaunchConfiguration("launch_configuration");
            config.delete();
        }
    }

    public void testValidateConfigGoodName() {
        String configname = "configname";
        try {
            this.getLaunchManager().isValidLaunchConfigurationName(configname);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LaunchManagerTests.fail((String)"the config name should not have thrown an exception during validation");
        }
    }

    public void testValidateConfigBadCharName() {
        String configname = "config:name";
        try {
            this.getLaunchManager().isValidLaunchConfigurationName(configname);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        LaunchManagerTests.fail((String)"the config name should have thrown an exception during validation");
    }

    public void testValidateConfigBadName() {
        if ("win32".equals(Platform.getOS())) {
            String configname = "com1";
            try {
                this.getLaunchManager().isValidLaunchConfigurationName(configname);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            LaunchManagerTests.fail((String)"the config name should have thrown an exception during validation");
        }
    }

    public void testGenerateNameExistingConfig() throws Exception {
        String configname = "x.y.z.configname";
        this.getLaunchConfiguration(configname);
        String name = this.getLaunchManager().generateLaunchConfigurationName(configname);
        LaunchManagerTests.assertEquals((String)("the configuration name should have been " + configname + " (1)"), (String)(String.valueOf(configname) + " (1)"), (String)name);
        this.getLaunchConfiguration(name);
        name = this.getLaunchManager().generateLaunchConfigurationName(name);
        LaunchManagerTests.assertEquals((String)("the configuration name should have been " + configname + " (2)"), (String)(String.valueOf(configname) + " (2)"), (String)name);
        ILaunchConfiguration config = this.getLaunchConfiguration(configname);
        if (config != null) {
            config.delete();
        }
        if ((config = this.getLaunchConfiguration(String.valueOf(configname) + " (1)")) != null) {
            config.delete();
        }
    }

    public void testRemoveAcc() {
        String text = "&Remove";
        String label = LaunchManager.removeAccelerators((String)text);
        LaunchManagerTests.assertEquals((String)"the label should be 'Remove'", (String)"Remove", (String)label);
        text = "Remo&ve";
        label = LaunchManager.removeAccelerators((String)text);
        LaunchManagerTests.assertEquals((String)"the label should be 'Remove'", (String)"Remove", (String)label);
    }

    ILaunchConfiguration getCancellingConfiguration(boolean pre, boolean fin, boolean build) throws Exception {
        ILaunchConfigurationType type = this.getLaunchManager().getLaunchConfigurationType("cancelling.type");
        if (type != null) {
            ILaunchConfigurationWorkingCopy copy = type.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName("cancelling"));
            copy.setAttribute("cancel.preLaunchCheck", !pre);
            copy.setAttribute("cancel.finalLaunchCheck", !fin);
            copy.setAttribute("cancel.buildForLaunch", !build);
            return copy.doSave();
        }
        return null;
    }

    void hasCancellingLaunches(int count) {
        ILaunch[] launches = this.getLaunchManager().getLaunches();
        int num = 0;
        int i = 0;
        while (i < launches.length) {
            if (launches[i] instanceof CancellingLaunchDelegate.CancellingLaunch) {
                ++num;
            }
            ++i;
        }
        LaunchManagerTests.assertEquals((String)"The number of expected launches is wrong", (int)count, (int)num);
    }

    /*
     * Unable to fully structure code
     */
    public void testCancelledPreLaunchCheck() throws Exception {
        config = this.getCancellingConfiguration(true, false, false);
        LaunchManagerTests.assertNotNull((String)"The cancelling config should have been created", (Object)config);
        try {
            this.hasCancellingLaunches(0);
            config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            this.hasCancellingLaunches(0);
        }
        finally {
            launches = this.getLaunchManager().getLaunches();
            i = 0;
            ** while (i < launches.length)
        }
lbl-1000:
        // 1 sources

        {
            this.getLaunchManager().removeLaunch(launches[i]);
            ++i;
            continue;
        }
lbl16:
        // 1 sources

        config.delete();
    }

    /*
     * Unable to fully structure code
     */
    public void testCancelledFinalLaunchCheck() throws Exception {
        config = this.getCancellingConfiguration(false, true, false);
        LaunchManagerTests.assertNotNull((String)"The cancelling config should have been created", (Object)config);
        try {
            this.hasCancellingLaunches(0);
            config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            this.hasCancellingLaunches(0);
        }
        finally {
            launches = this.getLaunchManager().getLaunches();
            i = 0;
            ** while (i < launches.length)
        }
lbl-1000:
        // 1 sources

        {
            this.getLaunchManager().removeLaunch(launches[i]);
            ++i;
            continue;
        }
lbl16:
        // 1 sources

        config.delete();
    }

    /*
     * Unable to fully structure code
     */
    public void testCancelledBuildForLaunch() throws Exception {
        config = this.getCancellingConfiguration(false, false, true);
        LaunchManagerTests.assertNotNull((String)"The cancelling config should have been created", (Object)config);
        try {
            this.hasCancellingLaunches(0);
            config.launch("run", (IProgressMonitor)new NullProgressMonitor());
            this.hasCancellingLaunches(1);
        }
        finally {
            launches = this.getLaunchManager().getLaunches();
            i = 0;
            ** while (i < launches.length)
        }
lbl-1000:
        // 1 sources

        {
            this.getLaunchManager().removeLaunch(launches[i]);
            ++i;
            continue;
        }
lbl16:
        // 1 sources

        config.delete();
    }

    public void testNPE_Bug484882() throws Exception {
        final boolean[] stop = new boolean[1];
        final Throwable[] exception = new Throwable[1];
        Thread thread = new Thread(){

            @Override
            public void run() {
                ILaunchConfiguration[] config = new ILaunchConfiguration[10000];
                try {
                    int i = 0;
                    while (i < config.length && !stop[0]) {
                        config[i] = LaunchManagerTests.this.getLaunchConfiguration("Name" + i);
                        ++i;
                    }
                    i = 0;
                    while (i < config.length) {
                        if (config[i] != null) {
                            config[i].delete();
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    exception[0] = e;
                }
            }
        };
        thread.start();
        try {
            ILaunchManager launchManager = this.getLaunchManager();
            while (thread.isAlive()) {
                launchManager.isExistingLaunchConfigurationName("Name");
            }
        }
        finally {
            stop[0] = true;
            thread.join(1000L);
            LaunchManagerTests.assertFalse((boolean)thread.isAlive());
            if (exception[0] != null) {
                throw new Exception("Exception in Thread", exception[0]);
            }
        }
    }
}

