/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.tests;

import java.util.HashMap;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class DefineCommandsTest {
    private static final String TEST_ID2 = "test.id2";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_ID1_WITH_PARAMETERS = "test.id1.with.parameters";
    private static final String TEST_CAT1 = "test.cat1";
    private IEclipseContext workbenchContext;

    @Before
    public void setUp() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        IEclipseContext globalContext = serviceContext.createChild();
        this.workbenchContext = globalContext.createChild("workbenchContext");
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.workbenchContext);
    }

    @After
    public void tearDown() {
        this.workbenchContext.dispose();
    }

    @Test
    public void testCreateCommands() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        Assert.assertNotNull((Object)cs);
        Assert.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        Assert.assertNotNull((String)"need category", (Object)category);
        Assert.assertNotNull((String)"command1", (Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null));
        Assert.assertNotNull((String)"command2", (Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null));
        Command cmd1 = cs.getCommand(TEST_ID1);
        Assert.assertNotNull((String)"get command1", (Object)cmd1);
        try {
            Assert.assertEquals((Object)"ID1", (Object)cmd1.getName());
        }
        catch (NotDefinedException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((String)"get command2", (Object)cs.getCommand(TEST_ID2));
        Assert.assertNotNull((String)"parameterized command", (Object)cs.createCommand(TEST_ID1, null));
    }

    @Test
    public void testParamizedCommandsSimple() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        IParameter[] parms = new IParameter[]{new IParameter(){

            public String getId() {
                return "viewId";
            }

            public String getName() {
                return "View Id";
            }

            public IParameterValues getValues() {
                return null;
            }

            public boolean isOptional() {
                return false;
            }
        }};
        Category defineCategory = cs.defineCategory(TEST_CAT1, "CAT1", null);
        Command command = cs.defineCommand(TEST_ID1_WITH_PARAMETERS, "TEST_ID1_WITH_PARAMETERS", null, defineCategory, parms);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("viewId", "Testing");
        ParameterizedCommand createdParamizedCommand = cs.createCommand(TEST_ID1_WITH_PARAMETERS, parameters);
        Assert.assertNotNull((Object)command);
        Assert.assertNotNull((Object)createdParamizedCommand);
        Command cmd1 = cs.getCommand(TEST_ID1_WITH_PARAMETERS);
        Assert.assertNotNull((String)"get command1", (Object)cmd1);
    }

    @Test
    public void testCreateWithSecondContexts() {
        IEclipseContext localContext = this.workbenchContext.createChild();
        ECommandService cs = (ECommandService)localContext.get(ECommandService.class);
        Assert.assertNotNull((Object)cs);
        Assert.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        Assert.assertNotNull((String)"need category", (Object)category);
        Assert.assertNotNull((String)"command1", (Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null));
        Assert.assertNotNull((String)"command2", (Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null));
        Command cmd1 = cs.getCommand(TEST_ID1);
        Assert.assertNotNull((String)"get command1", (Object)cmd1);
        try {
            Assert.assertEquals((Object)"ID1", (Object)cmd1.getName());
        }
        catch (NotDefinedException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((String)"get command2", (Object)cs.getCommand(TEST_ID2));
    }

    @Test
    public void testCreateWithTwoContexts() {
        IEclipseContext localContext = this.workbenchContext.createChild("Level1");
        ECommandService cs = (ECommandService)localContext.get(ECommandService.class);
        Assert.assertNotNull((Object)cs);
        Assert.assertNotNull((Object)cs.defineCategory(TEST_CAT1, "CAT1", null));
        Category category = cs.getCategory(TEST_CAT1);
        Assert.assertNotNull((String)"need category", (Object)category);
        Assert.assertNotNull((String)"command1", (Object)cs.defineCommand(TEST_ID1, "ID1", null, category, null));
        Assert.assertNotNull((String)"command2", (Object)cs.defineCommand(TEST_ID2, "ID2", null, category, null));
        cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        Command cmd1 = cs.getCommand(TEST_ID1);
        Assert.assertNotNull((String)"get command1", (Object)cmd1);
        try {
            Assert.assertEquals((Object)"ID1", (Object)cmd1.getName());
        }
        catch (NotDefinedException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertNotNull((String)"get command2", (Object)cs.getCommand(TEST_ID2));
    }
}

