/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.tests;

import java.util.Collections;
import java.util.Map;
import javax.inject.Named;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.IParameterValues;
import org.eclipse.core.commands.ParameterValuesException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.CommandServiceAddon;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class HandlerTest {
    private static final String ACTIVE_INFO_ID = "activeInfo";
    private static final String TEST_ID3 = "test.id3";
    private static final String TEST_ID2 = "test.id2";
    private static final String TEST_ID1 = "test.id1";
    private static final String TEST_CAT1 = "test.cat1";
    private IEclipseContext workbenchContext;

    @Before
    public void setUp() {
        IEclipseContext serviceContext = EclipseContextFactory.getServiceContext((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext());
        IEclipseContext globalContext = serviceContext.createChild();
        this.workbenchContext = globalContext.createChild("workbenchContext");
        ContextInjectionFactory.make(CommandServiceAddon.class, (IEclipseContext)this.workbenchContext);
        this.defineCommands(this.workbenchContext);
    }

    @After
    public void tearDown() {
        this.workbenchContext.dispose();
    }

    @Test
    public void testCallHandler() throws Exception {
        EHandlerService hs = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        CallHandler handler = new CallHandler();
        hs.activateHandler(TEST_ID1, (Object)handler);
        Assert.assertFalse((boolean)handler.q1);
        Assert.assertFalse((boolean)handler.q2);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        Assert.assertTrue((boolean)hs.canExecute(cmd));
        Assert.assertFalse((boolean)handler.q2);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)hs.executeHandler(cmd));
        Assert.assertTrue((boolean)handler.q1);
        Assert.assertTrue((boolean)handler.q2);
    }

    @Test
    public void testDeactivateHandler() throws Exception {
        EHandlerService hs = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        CallHandler handler = new CallHandler();
        hs.activateHandler(TEST_ID1, (Object)handler);
        Assert.assertFalse((boolean)handler.q1);
        Assert.assertFalse((boolean)handler.q2);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        Assert.assertTrue((boolean)hs.canExecute(cmd));
        Assert.assertFalse((boolean)handler.q2);
        hs.deactivateHandler(TEST_ID1, (Object)handler);
        Assert.assertNull((Object)hs.executeHandler(cmd));
        Assert.assertTrue((boolean)handler.q1);
        Assert.assertFalse((boolean)handler.q2);
    }

    @Test
    public void testActiveHandlerExecuteWorkbench() throws Exception {
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class);
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        ECommandService cs = (ECommandService)c1.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        Assert.assertTrue((boolean)h1.canExecute(cmd));
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        Assert.assertTrue((boolean)wHS.canExecute(cmd));
    }

    @Test
    public void testQueryTwoHandlers() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class);
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EHandlerService h2 = (EHandlerService)c2.get(EHandlerService.class);
        CallHandler handler2 = new CallHandler();
        h2.activateHandler(TEST_ID1, (Object)handler2);
        Assert.assertFalse((boolean)handler1.q1);
        Assert.assertFalse((boolean)handler2.q1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        Assert.assertTrue((boolean)handler1.q1);
        Assert.assertTrue((boolean)handler1.q2);
        Assert.assertFalse((boolean)handler2.q1);
        Assert.assertFalse((boolean)handler2.q2);
    }

    @Test
    public void testExecuteTwoActiveHandlers() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class);
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EHandlerService h2 = (EHandlerService)c2.get(EHandlerService.class);
        CallHandler handler2 = new CallHandler();
        h2.activateHandler(TEST_ID1, (Object)handler2);
        Assert.assertTrue((boolean)h1.canExecute(cmd));
        Assert.assertTrue((boolean)handler1.q1);
        Assert.assertFalse((boolean)handler2.q1);
        Assert.assertTrue((boolean)h2.canExecute(cmd));
        Assert.assertTrue((boolean)handler2.q1);
        Assert.assertFalse((boolean)handler1.q2);
        Assert.assertFalse((boolean)handler2.q2);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        Assert.assertTrue((boolean)handler1.q2);
        Assert.assertFalse((boolean)handler2.q2);
    }

    @Test
    public void testSwitchActivationTwoHandlers() throws Exception {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        IEclipseContext c1 = this.workbenchContext.createChild("c1");
        c1.activate();
        EHandlerService h1 = (EHandlerService)c1.get(EHandlerService.class);
        CallHandler handler1 = new CallHandler();
        h1.activateHandler(TEST_ID1, (Object)handler1);
        IEclipseContext c2 = this.workbenchContext.createChild("c2");
        EHandlerService h2 = (EHandlerService)c2.get(EHandlerService.class);
        CallHandler handler2 = new CallHandler();
        h2.activateHandler(TEST_ID1, (Object)handler2);
        Assert.assertFalse((boolean)handler1.q1);
        Assert.assertFalse((boolean)handler2.q1);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        Assert.assertTrue((boolean)handler1.q1);
        Assert.assertTrue((boolean)handler1.q2);
        Assert.assertFalse((boolean)handler2.q1);
        Assert.assertFalse((boolean)handler2.q2);
        handler1.q1 = false;
        handler1.q2 = false;
        c2.activate();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)wHS.executeHandler(cmd));
        Assert.assertTrue((boolean)handler2.q1);
        Assert.assertTrue((boolean)handler2.q2);
        Assert.assertFalse((boolean)handler1.q1);
        Assert.assertFalse((boolean)handler1.q2);
    }

    @Test
    public void testMethodInfo() throws Exception {
        Info helloInfo = new Info("Hello");
        this.workbenchContext.set(Info.class, (Object)helloInfo);
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        HandlerWithInfo handler = new HandlerWithInfo();
        wHS.activateHandler(TEST_ID1, (Object)handler);
        Assert.assertEquals((Object)helloInfo, (Object)wHS.executeHandler(cmd));
    }

    @Test
    public void testMethodWithAnnocation() throws Exception {
        Info helloInfo = new Info("Hello");
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        ParameterizedCommand cmd = cs.createCommand(TEST_ID1, null);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        HandlerWithAnnotations handler = new HandlerWithAnnotations();
        wHS.activateHandler(TEST_ID1, (Object)handler);
        this.workbenchContext.set(Info.class, (Object)helloInfo);
        Assert.assertNull((Object)wHS.executeHandler(cmd));
        this.workbenchContext.remove(Info.class);
        Assert.assertNull((Object)wHS.executeHandler(cmd));
        this.workbenchContext.set(ACTIVE_INFO_ID, (Object)helloInfo);
        Assert.assertEquals((Object)helloInfo, (Object)wHS.executeHandler(cmd));
        this.workbenchContext.remove(ACTIVE_INFO_ID);
        Assert.assertNull((Object)wHS.executeHandler(cmd));
    }

    @Test
    public void testBug314847() {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        EHandlerService wHS = (EHandlerService)this.workbenchContext.get(EHandlerService.class);
        ParameterizedCommand nonparameterizedCmd = cs.createCommand(TEST_ID3, null);
        ParameterizedCommand parameterizedCmd = cs.createCommand(TEST_ID3, Collections.singletonMap(ACTIVE_INFO_ID, "param"));
        HandlerWithParams handler = new HandlerWithParams();
        wHS.activateHandler(TEST_ID3, (Object)handler);
        Assert.assertEquals((Object)true, (Object)wHS.canExecute(parameterizedCmd));
        Assert.assertEquals((Object)"param", (Object)wHS.executeHandler(parameterizedCmd));
        Assert.assertEquals((Object)true, (Object)wHS.canExecute(nonparameterizedCmd));
        Assert.assertEquals(null, (Object)wHS.executeHandler(nonparameterizedCmd));
    }

    private void defineCommands(IEclipseContext context) {
        ECommandService cs = (ECommandService)this.workbenchContext.get(ECommandService.class);
        Category category = cs.defineCategory(TEST_CAT1, "CAT1", null);
        cs.defineCommand(TEST_ID1, "ID1", null, category, null);
        cs.defineCommand(TEST_ID2, "ID2", null, category, null);
        cs.defineCommand(TEST_ID3, "ID3", null, category, new IParameter[]{new IParameter(){

            public boolean isOptional() {
                return true;
            }

            public IParameterValues getValues() throws ParameterValuesException {
                return new IParameterValues(){

                    public Map<?, ?> getParameterValues() {
                        return Collections.EMPTY_MAP;
                    }
                };
            }

            public String getName() {
                return HandlerTest.ACTIVE_INFO_ID;
            }

            public String getId() {
                return HandlerTest.ACTIVE_INFO_ID;
            }
        }});
    }

    static class CallHandler {
        public boolean q1;
        public boolean q2;

        CallHandler() {
        }

        @CanExecute
        public boolean canExecute() {
            this.q1 = true;
            return true;
        }

        @Execute
        public Object execute() {
            this.q2 = true;
            if (this.q1) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    static class HandlerWithAnnotations {
        HandlerWithAnnotations() {
        }

        @CanExecute
        public boolean canExecute(@Named(value="activeInfo") Info h) {
            return h.name.equals("Hello");
        }

        @Execute
        public Object execute(@Named(value="activeInfo") Info h) {
            return h.name.equals("Hello") ? h : null;
        }
    }

    static class HandlerWithInfo {
        HandlerWithInfo() {
        }

        @CanExecute
        public boolean canExecute(Info h) {
            return h.name.equals("Hello");
        }

        @Execute
        public Object execute(Info h) {
            return h.name.equals("Hello") ? h : null;
        }
    }

    static class HandlerWithParams {
        HandlerWithParams() {
        }

        @CanExecute
        public boolean canExecute(@Optional @Named(value="activeInfo") String param) {
            return true;
        }

        @Execute
        public Object execute(@Optional @Named(value="activeInfo") String param) {
            return param;
        }
    }

    static class Info {
        public String name;

        public Info(String name) {
            this.name = name;
        }
    }
}

