/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.Active;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.Assert;
import org.junit.Test;

public class ActivationInjectionTest {
    @Test
    public void testContextActivation() {
        IEclipseContext rootContext = EclipseContextFactory.create((String)"root");
        rootContext.set("testRAT", (Object)new TestRAT());
        IEclipseContext child1 = rootContext.createChild("child1");
        IEclipseContext child11 = child1.createChild("child11");
        IEclipseContext child12 = child1.createChild("child12");
        IEclipseContext child2 = rootContext.createChild("child2");
        IEclipseContext child21 = child2.createChild("child21");
        IEclipseContext child22 = child2.createChild("child22");
        TestObject testObject = (TestObject)ContextInjectionFactory.make(TestObject.class, (IEclipseContext)rootContext);
        child12.activateBranch();
        Assert.assertEquals((Object)child12, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child12_", (Object)testObject.name);
        child21.activateBranch();
        Assert.assertEquals((Object)child21, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child21_", (Object)testObject.name);
        child21.deactivate();
        Assert.assertEquals((Object)child2, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child2_", (Object)testObject.name);
        child22.activateBranch();
        Assert.assertEquals((Object)child22, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child22_", (Object)testObject.name);
        child11.activateBranch();
        Assert.assertEquals((Object)child11, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child11_", (Object)testObject.name);
        child11.deactivate();
        Assert.assertEquals((Object)child1, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child1_", (Object)testObject.name);
        child1.dispose();
        child2.activateBranch();
        Assert.assertEquals((Object)child22, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child22_", (Object)testObject.name);
    }

    @Test
    public void testActivationInjection() {
        IEclipseContext rootContext = EclipseContextFactory.create((String)"root");
        IEclipseContext child1 = rootContext.createChild("child1");
        IEclipseContext child11 = child1.createChild("child11");
        IEclipseContext child12 = child1.createChild("child12");
        IEclipseContext child2 = rootContext.createChild("child2");
        IEclipseContext child21 = child2.createChild("child21");
        IEclipseContext child22 = child2.createChild("child22");
        TestObjectInject testObject = (TestObjectInject)ContextInjectionFactory.make(TestObjectInject.class, (IEclipseContext)rootContext);
        child12.activateBranch();
        Assert.assertEquals((Object)child12, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child12_", (Object)testObject.name);
        child21.activateBranch();
        Assert.assertEquals((Object)child21, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child21_", (Object)testObject.name);
        child21.deactivate();
        Assert.assertEquals((Object)child2, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child2_", (Object)testObject.name);
        child22.activateBranch();
        Assert.assertEquals((Object)child22, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child22_", (Object)testObject.name);
        child11.activateBranch();
        Assert.assertEquals((Object)child11, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child11_", (Object)testObject.name);
        child11.deactivate();
        Assert.assertEquals((Object)child1, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child1_", (Object)testObject.name);
        child1.dispose();
        child2.activateBranch();
        Assert.assertEquals((Object)child22, (Object)rootContext.getActiveLeaf());
        Assert.assertEquals((Object)"_child22_", (Object)testObject.name);
    }

    @Test
    public void testInjection() {
        IEclipseContext rootContext = EclipseContextFactory.create((String)"root");
        IEclipseContext child1 = rootContext.createChild("child1");
        child1.set(Integer.class, (Object)1);
        IEclipseContext child11 = child1.createChild("child11");
        child11.set(Integer.class, (Object)2);
        IEclipseContext child12 = child1.createChild("child12");
        child12.set(Integer.class, (Object)3);
        IEclipseContext child2 = rootContext.createChild("child2");
        child2.set(Integer.class, (Object)4);
        IEclipseContext child21 = child2.createChild("child21");
        child21.set(Integer.class, (Object)5);
        IEclipseContext child22 = child2.createChild("child22");
        child22.set(Integer.class, (Object)6);
        TestInject testObjectRoot = (TestInject)ContextInjectionFactory.make(TestInject.class, (IEclipseContext)rootContext);
        TestInject testObjectChild1 = (TestInject)ContextInjectionFactory.make(TestInject.class, (IEclipseContext)child1);
        TestInject testObjectChild2 = (TestInject)ContextInjectionFactory.make(TestInject.class, (IEclipseContext)child2);
        child12.activateBranch();
        Assert.assertEquals((Object)3, (Object)testObjectRoot.number);
        Assert.assertEquals((Object)3, (Object)testObjectChild1.number);
        Assert.assertEquals((Object)4, (Object)testObjectChild2.number);
        child21.activateBranch();
        Assert.assertEquals((Object)5, (Object)testObjectRoot.number);
        Assert.assertEquals((Object)3, (Object)testObjectChild1.number);
        Assert.assertEquals((Object)5, (Object)testObjectChild2.number);
        child21.deactivate();
        Assert.assertEquals((Object)4, (Object)testObjectRoot.number);
        Assert.assertEquals((Object)3, (Object)testObjectChild1.number);
        Assert.assertEquals((Object)4, (Object)testObjectChild2.number);
        child22.activateBranch();
        Assert.assertEquals((Object)6, (Object)testObjectRoot.number);
        Assert.assertEquals((Object)3, (Object)testObjectChild1.number);
        Assert.assertEquals((Object)6, (Object)testObjectChild2.number);
        child11.activateBranch();
        Assert.assertEquals((Object)2, (Object)testObjectRoot.number);
        Assert.assertEquals((Object)2, (Object)testObjectChild1.number);
        Assert.assertEquals((Object)6, (Object)testObjectChild2.number);
        child11.deactivate();
        Assert.assertEquals((Object)1, (Object)testObjectRoot.number);
        Assert.assertEquals((Object)1, (Object)testObjectChild1.number);
        Assert.assertEquals((Object)6, (Object)testObjectChild2.number);
        child1.dispose();
        child2.activateBranch();
        Assert.assertEquals((Object)6, (Object)testObjectRoot.number);
        Assert.assertEquals((Object)6, (Object)testObjectChild2.number);
    }

    public static class TestInject {
        @Optional
        @Inject
        @Active
        public Integer number;
    }

    public static class TestObject {
        public String name;

        @Inject
        public TestObject() {
        }

        @Inject
        public void setActiveContextName(@Named(value="testRAT") String name) {
            this.name = name;
        }
    }

    public static class TestObjectInject {
        public String name;

        @Inject
        public TestObjectInject() {
        }

        @Inject
        public void setActiveContextName(@Active @Named(value="debugString") String name) {
            this.name = "_" + name + "_";
        }
    }

    public static class TestRAT
    extends ContextFunction {
        public Object compute(IEclipseContext context, String contextKey) {
            IEclipseContext activeContext = context.getActiveLeaf();
            return "_" + activeContext.get("debugString") + "_";
        }
    }
}

