/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import junit.framework.AssertionFailedError;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectBasic;
import org.eclipse.e4.core.internal.tests.contexts.inject.ObjectSubClass;
import org.eclipse.e4.core.internal.tests.contexts.inject.OptionalAnnotations;
import org.junit.Assert;
import org.junit.Test;

public class AnnotationsInjectionTest {
    @Test
    public void testContextSetOneArg() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set("testing123", (Object)methodValue);
        class Injected {
            int contextSetCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            @Inject
            public void settings(IEclipseContext context) {
                ++this.contextSetCalled;
            }

            @Inject
            public void injectedMethod(@Named(value="testing123") TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assert.assertEquals((long)1L, (long)object.setMethodCalled);
        Assert.assertEquals((long)1L, (long)object.contextSetCalled);
        TestData methodValue2 = new TestData();
        context.set("testing123", (Object)methodValue2);
        Assert.assertEquals((long)2L, (long)object.setMethodCalled);
        Assert.assertEquals((Object)methodValue2, (Object)object.value);
        Assert.assertEquals((long)1L, (long)object.contextSetCalled);
    }

    @Test
    public void testPostConstruct() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class, (Object)methodValue);
        class Injected {
            int postConstructCalled = 0;
            int setMethodCalled = 0;
            public TestData value;

            Injected() {
            }

            @PostConstruct
            public void init() {
                ++this.postConstructCalled;
            }

            @Inject
            public void setData(TestData arg) {
                ++this.setMethodCalled;
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assert.assertEquals((long)1L, (long)object.setMethodCalled);
        Assert.assertEquals((long)1L, (long)object.postConstructCalled);
        TestData methodValue2 = new TestData();
        context.set(TestData.class, (Object)methodValue2);
        Assert.assertEquals((long)2L, (long)object.setMethodCalled);
        Assert.assertEquals((long)1L, (long)object.postConstructCalled);
        Assert.assertEquals((Object)methodValue2, (Object)object.value);
    }

    @Test
    public synchronized void testInjection() {
        Integer testInt = 123;
        String testString = "abc";
        Double testDouble = 1.23;
        Float testFloat = Float.valueOf(12.3f);
        Character testChar = Character.valueOf('v');
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class, (Object)testInt);
        context.set(String.class, (Object)testString);
        context.set(Double.class, (Object)testDouble);
        context.set(Float.class, (Object)testFloat);
        context.set(Character.class, (Object)testChar);
        ObjectBasic userObject = new ObjectBasic();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assert.assertEquals((Object)testString, (Object)userObject.injectedString);
        Assert.assertEquals((Object)testInt, (Object)userObject.getInt());
        Assert.assertEquals((Object)context, (Object)userObject.context);
        Assert.assertEquals((long)1L, (long)userObject.setMethodCalled);
        Assert.assertEquals((long)1L, (long)userObject.setMethodCalled2);
        Assert.assertEquals((Object)testDouble, (Object)userObject.d);
        Assert.assertEquals((Object)testFloat, (Object)userObject.f);
        Assert.assertEquals((Object)testChar, (Object)userObject.c);
        Assert.assertTrue((boolean)userObject.finalized);
    }

    @Test
    public void testFieldMethodOrder() {
        AssertionFailedError[] error = new AssertionFailedError[1];
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData fieldValue = new TestData();
        TestData methodValue = new TestData();
        context.set("valueField", (Object)fieldValue);
        context.set("valueMethod", (Object)methodValue);
        class Injected {
            @Inject
            @Named(value="valueField")
            Object injectedField;
            Object methodValue;
            private final /* synthetic */ AssertionFailedError[] val$error;

            Injected(AssertionFailedError[] assertionFailedErrorArray) {
                this.val$error = assertionFailedErrorArray;
            }

            @Inject
            public void injectedMethod(@Optional @Named(value="valueMethod") Object arg) {
                try {
                    Assert.assertTrue((this.injectedField != null ? 1 : 0) != 0);
                }
                catch (AssertionFailedError e) {
                    this.val$error[0] = e;
                }
                this.methodValue = arg;
            }
        }
        Injected object = new Injected(error);
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        if (error[0] != null) {
            throw error[0];
        }
        Assert.assertEquals((Object)fieldValue, (Object)object.injectedField);
        Assert.assertEquals((Object)methodValue, (Object)object.methodValue);
        context.remove("valueMethod");
        if (error[0] != null) {
            throw error[0];
        }
        Assert.assertEquals((Object)fieldValue, (Object)object.injectedField);
        Assert.assertNull((Object)object.methodValue);
        context.dispose();
        if (error[0] != null) {
            throw error[0];
        }
    }

    @Test
    public void testOptionalInjection() {
        Integer testInt = 123;
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class, (Object)testInt);
        OptionalAnnotations userObject = new OptionalAnnotations();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)userObject.methodOptionalCalled);
        Assert.assertEquals((long)1L, (long)userObject.methodRequiredCalled);
        Assert.assertEquals((Object)testInt, (Object)userObject.i);
        Assert.assertNull((Object)userObject.s);
        Assert.assertNull((Object)userObject.d);
        Assert.assertNull((Object)userObject.f);
        String testString = "abc";
        Double testDouble = 1.23;
        Float testFloat = Float.valueOf(12.3f);
        context.set(String.class, (Object)testString);
        context.set(Double.class, (Object)testDouble);
        context.set(Float.class, (Object)testFloat);
        Assert.assertEquals((long)1L, (long)userObject.methodOptionalCalled);
        Assert.assertEquals((long)2L, (long)userObject.methodRequiredCalled);
        Assert.assertEquals((Object)testInt, (Object)userObject.i);
        Assert.assertEquals((Object)testString, (Object)userObject.s);
        Assert.assertEquals((Object)testDouble, (Object)userObject.d);
        Assert.assertEquals((Object)testFloat, (Object)userObject.f);
    }

    @Test
    public void testOptionalInvoke() {
        IEclipseContext context = EclipseContextFactory.create();
        Object notAnObject = new Object();
        class TestObject {
            public int called = 0;

            TestObject() {
            }

            @Execute
            public String something(@Optional String param) {
                ++this.called;
                return param;
            }
        }
        TestObject testObject = new TestObject();
        context.set(String.class.getName(), (Object)testObject);
        Object result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)context, (Object)notAnObject);
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)1L, (long)testObject.called);
        String string = "sample";
        context.set(String.class, (Object)string);
        result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)context, (Object)notAnObject);
        Assert.assertEquals((Object)string, (Object)result);
        Assert.assertEquals((long)2L, (long)testObject.called);
    }

    @Test
    public void testInheritedSpecialMethods() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Integer.class, (Object)123);
        context.set(String.class, (Object)"abc");
        context.set(Float.class, (Object)Float.valueOf(12.3f));
        ObjectSubClass userObject = new ObjectSubClass();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assert.assertEquals((long)1L, (long)userObject.superPostConstructCount);
        Assert.assertEquals((long)1L, (long)userObject.subPostConstructCount);
        Assert.assertEquals((long)0L, (long)userObject.superPreDestroyCount);
        Assert.assertEquals((long)0L, (long)userObject.subPreDestroyCount);
        Assert.assertEquals((long)0L, (long)userObject.overriddenPreDestroyCount);
        context.set(Float.class, (Object)Float.valueOf(45.6f));
        Assert.assertEquals((long)1L, (long)userObject.superPostConstructCount);
        Assert.assertEquals((long)1L, (long)userObject.subPostConstructCount);
        Assert.assertEquals((long)0L, (long)userObject.superPreDestroyCount);
        Assert.assertEquals((long)0L, (long)userObject.subPreDestroyCount);
        Assert.assertEquals((long)0L, (long)userObject.overriddenPreDestroyCount);
        context.dispose();
        Assert.assertEquals((long)1L, (long)userObject.superPreDestroyCount);
        Assert.assertEquals((long)1L, (long)userObject.subPreDestroyCount);
        Assert.assertEquals((long)1L, (long)userObject.overriddenPreDestroyCount);
    }

    @Test
    public void testInvoke() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            public String value;

            public TestData(String tmp) {
                this.value = tmp;
            }
        }
        TestData methodValue = new TestData("abc");
        context.set("testing123", (Object)methodValue);
        class Injected {
            public String myString;

            @Execute
            public String something(@Named(value="testing123") TestData data) {
                this.myString = data.value;
                return "true";
            }
        }
        Injected object = new Injected();
        Assert.assertNull((Object)object.myString);
        Assert.assertEquals((Object)"true", (Object)ContextInjectionFactory.invoke((Object)object, Execute.class, (IEclipseContext)context, null));
        Assert.assertEquals((Object)"abc", (Object)object.myString);
    }

    @Test
    public void testPreDestroy() {
        IEclipseContext context = EclipseContextFactory.create();
        class TestData {
            TestData() {
            }
        }
        TestData methodValue = new TestData();
        context.set(TestData.class, (Object)methodValue);
        class Injected {
            int preDestoryCalled = 0;
            public TestData value;
            @Inject
            public TestData directFieldInjection;

            Injected() {
            }

            @PreDestroy
            public void aboutToClose() {
                ++this.preDestoryCalled;
                Assert.assertNotNull((Object)this.value);
                Assert.assertNotNull((Object)this.directFieldInjection);
            }

            @Inject
            public void setData(TestData arg) {
                this.value = arg;
            }
        }
        Injected object = new Injected();
        ContextInjectionFactory.inject((Object)object, (IEclipseContext)context);
        Assert.assertNotNull((Object)object.value);
        Assert.assertNotNull((Object)object.directFieldInjection);
        context.dispose();
        Assert.assertEquals((long)1L, (long)object.preDestoryCalled);
        Assert.assertNotNull((Object)object.value);
        Assert.assertNotNull((Object)object.directFieldInjection);
    }
}

