/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.Assert;
import org.junit.Test;

public class ComplexDisposalTest {
    @Test
    public void testU() {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("aString", (Object)"");
        parentContext.set(MyTest.class.getName(), (Object)new TestFunction());
        IEclipseContext context = parentContext.createChild();
        MyTest test = (MyTest)context.get(MyTest.class);
        Assert.assertEquals((long)0L, (long)test.getCount());
        context.dispose();
        Assert.assertEquals((String)"Context disposed, @PreDestroy should've been called", (long)1L, (long)test.getCount());
        parentContext.dispose();
        Assert.assertEquals((String)"Parent context disposed, @PreDestroy should not have been called again", (long)1L, (long)test.getCount());
    }

    @Test
    public void testV() {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("aString", (Object)"");
        IEclipseContext context = parentContext.createChild();
        MyTest test = (MyTest)ContextInjectionFactory.make(MyTest.class, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)test.getCount());
        context.dispose();
        Assert.assertEquals((String)"Context disposed, @PreDestroy should've been called", (long)1L, (long)test.getCount());
        parentContext.dispose();
        Assert.assertEquals((String)"Parent context disposed, @PreDestroy should not have been called again", (long)1L, (long)test.getCount());
    }

    @Test
    public void testW() {
        IEclipseContext parentContext = EclipseContextFactory.create();
        parentContext.set("aString", (Object)"");
        IEclipseContext context = parentContext.createChild();
        MyTest test = new MyTest();
        ContextInjectionFactory.inject((Object)test, (IEclipseContext)context);
        Assert.assertEquals((long)0L, (long)test.getCount());
        context.dispose();
        Assert.assertEquals((String)"Context disposed, @PreDestroy should've been called", (long)1L, (long)test.getCount());
        parentContext.dispose();
        Assert.assertEquals((String)"Parent context disposed, @PreDestroy should not have been called again", (long)1L, (long)test.getCount());
    }

    public static class MyTest {
        private int count = 0;
        @Inject
        @Named(value="aString")
        String string;

        public int getCount() {
            return this.count;
        }

        @PreDestroy
        void preDestroy() {
            ++this.count;
        }
    }

    public static class TestFunction
    extends ContextFunction {
        public Object compute(IEclipseContext context, String contextKey) {
            return ContextInjectionFactory.make(MyTest.class, (IEclipseContext)context);
        }
    }
}

