/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.Assert;
import org.junit.Test;

public class GenericsInjectionTest {
    @Test
    public synchronized void testNamedInjection() {
        Animal testAnimal = new Animal();
        Bird testBird = new Bird();
        BirdHouse testBirdHouse = new BirdHouse();
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Animal.class, (Object)testAnimal);
        context.set(Bird.class, (Object)testBird);
        context.set("test", (Object)testBirdHouse);
        TestNamedObject userObject = new TestNamedObject();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assert.assertEquals((Object)testBirdHouse, userObject.field);
    }

    @Test
    public synchronized void testGenericInjection() {
        Animal testAnimal = new Animal();
        Bird testBird = new Bird();
        BirdHouse testBirdHouse = new BirdHouse();
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Animal.class, (Object)testAnimal);
        context.set(Bird.class, (Object)testBird);
        context.set(Feeder.class, (Object)testBirdHouse);
        TestGenericObject userObject = new TestGenericObject();
        ContextInjectionFactory.inject((Object)userObject, (IEclipseContext)context);
        Assert.assertEquals((Object)testBirdHouse, userObject.field);
    }

    @Test
    public void testInterfaceGenericInjection() {
        Implementation implementation = new Implementation();
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Interface.class, (Object)implementation);
        InterfaceTarget target = new InterfaceTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context);
        Assert.assertEquals((Object)implementation, target.field);
    }

    @Test
    public void testClassGenericInjection() {
        Subclass implementation = new Subclass();
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Superclass.class, (Object)implementation);
        ClassTarget target = new ClassTarget();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context);
        Assert.assertEquals((Object)implementation, target.field);
    }

    public static class Animal {
    }

    public static class Bird
    extends Animal {
    }

    public static class BirdHouse
    extends Feeder<Bird> {
    }

    public static class ClassTarget {
        @Inject
        public Superclass<Object> field;
    }

    public static class Feeder<T extends Animal> {
    }

    public static class Implementation
    implements Interface<Object> {
    }

    public static interface Interface<T> {
    }

    public static class InterfaceTarget {
        @Inject
        public Interface<Object> field;
    }

    public static class Subclass
    extends Superclass<Object> {
    }

    public static class Superclass<T> {
    }

    public static class TestGenericObject {
        public Feeder<Bird> field;

        @Inject
        public void setFeeder(Feeder<Bird> value) {
            this.field = value;
        }
    }

    public static class TestNamedObject {
        public Feeder<Bird> field;

        @Inject
        public void setFeeder(@Named(value="test") Feeder<Bird> value) {
            this.field = value;
        }
    }
}

