/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.GroupUpdates;
import org.junit.Assert;
import org.junit.Test;

public class GroupedUpdatesTest {
    @Test
    public void testNoGrouping() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("string1", (Object)"x");
        context.set("string2", (Object)"y");
        InjectTargetImmediate target = new InjectTargetImmediate();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context);
        Assert.assertEquals((long)1L, (long)target.countMain);
        target.resetCounters();
        context.set("string1", (Object)"a");
        context.set("string2", (Object)"b");
        Assert.assertEquals((long)2L, (long)target.countMain);
        Assert.assertEquals((long)1L, (long)target.countSecondary);
        context.processWaiting();
        Assert.assertEquals((long)2L, (long)target.countMain);
        Assert.assertEquals((long)1L, (long)target.countSecondary);
    }

    @Test
    public void testGrouping() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("string1", (Object)"x");
        context.set("string2", (Object)"y");
        InjectTargetWait target = new InjectTargetWait();
        ContextInjectionFactory.inject((Object)target, (IEclipseContext)context);
        Assert.assertEquals((long)1L, (long)target.countMain);
        target.resetCounters();
        context.set("string1", (Object)"a");
        context.set("string2", (Object)"b");
        Assert.assertEquals((long)0L, (long)target.countMain);
        Assert.assertEquals((long)0L, (long)target.countSecondary);
        context.processWaiting();
        Assert.assertEquals((long)1L, (long)target.countMain);
        Assert.assertEquals((long)1L, (long)target.countSecondary);
        context.processWaiting();
        Assert.assertEquals((long)1L, (long)target.countMain);
        Assert.assertEquals((long)1L, (long)target.countSecondary);
        target.resetCounters();
        context.set("string1", (Object)"x");
        context.set("string2", (Object)"y");
        context.set("string2", (Object)"z");
        context.set("string1", (Object)"delta");
        Assert.assertEquals((long)0L, (long)target.countMain);
        Assert.assertEquals((long)0L, (long)target.countSecondary);
        context.processWaiting();
        Assert.assertEquals((long)1L, (long)target.countMain);
        Assert.assertEquals((long)1L, (long)target.countSecondary);
        Assert.assertEquals((Object)target.s1, (Object)"delta");
        Assert.assertEquals((Object)target.s2, (Object)"z");
    }

    static class InjectTarget {
        public int countMain = 0;
        public int countSecondary = 0;
        public String s1;
        public String s2;

        InjectTarget() {
        }

        public void resetCounters() {
            this.countMain = 0;
            this.countSecondary = 0;
        }
    }

    static class InjectTargetImmediate
    extends InjectTarget {
        InjectTargetImmediate() {
        }

        @Inject
        void setInfo(@Named(value="string1") String s, @Named(value="string2") String s2) {
            ++this.countMain;
            this.s1 = s;
            this.s2 = s2;
        }

        @Inject
        void setInfoSecondary(@Named(value="string2") String s2) {
            ++this.countSecondary;
            this.s2 = s2;
        }
    }

    static class InjectTargetWait
    extends InjectTarget {
        InjectTargetWait() {
        }

        @Inject
        @GroupUpdates
        void setInfo(@Named(value="string1") String s, @Named(value="string2") String s2) {
            ++this.countMain;
            this.s1 = s;
            this.s2 = s2;
        }

        @Inject
        @GroupUpdates
        void setInfoSecondary(@Named(value="string2") String s2) {
            ++this.countSecondary;
            this.s2 = s2;
        }
    }
}

