/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.Assert;
import org.junit.Test;

public class InjectStaticContextTest {
    @Test
    public void testStaticMake() {
        IEclipseContext trackedContext = EclipseContextFactory.create();
        trackedContext.set("a", (Object)"abc");
        trackedContext.set("aConstructor", (Object)"abcConstructor");
        trackedContext.set("b", (Object)"bbc");
        IEclipseContext staticContext = EclipseContextFactory.create();
        staticContext.set("b", (Object)"123");
        staticContext.set("bConstructor", (Object)"123Constructor");
        staticContext.set("c", (Object)"xyz");
        TestClass testObject = (TestClass)ContextInjectionFactory.make(TestClass.class, (IEclipseContext)trackedContext, (IEclipseContext)staticContext);
        Assert.assertEquals((Object)trackedContext, (Object)testObject.injectedContext);
        Assert.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assert.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        staticContext.set("b", (Object)"_123_");
        staticContext.set("bConstructor", (Object)"_123Constructor_");
        staticContext.set("c", (Object)"_xyz_");
        Assert.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assert.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        staticContext.dispose();
        Assert.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assert.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        trackedContext.set("a", (Object)"_abc_");
        trackedContext.set("b", (Object)"_bbc_");
        Assert.assertEquals((Object)"_abc_", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        ContextInjectionFactory.uninject((Object)testObject, (IEclipseContext)trackedContext);
        Assert.assertNull((Object)testObject.injectedContext);
        Assert.assertNull((Object)testObject.aString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)1L, (long)testObject.preDestroyCalled);
        trackedContext.set("a", (Object)"+abc+");
        Assert.assertNull((Object)testObject.aString);
        trackedContext.dispose();
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)1L, (long)testObject.preDestroyCalled);
    }

    @Test
    public void testStaticInject() {
        IEclipseContext trackedContext = EclipseContextFactory.create();
        trackedContext.set("a", (Object)"abc");
        trackedContext.set("aConstructor", (Object)"abcConstructor");
        trackedContext.set("b", (Object)"bbc");
        IEclipseContext staticContext = EclipseContextFactory.create();
        staticContext.set("b", (Object)"123");
        staticContext.set("bConstructor", (Object)"123Constructor");
        staticContext.set("c", (Object)"xyz");
        TestClass testObject = new TestClass();
        Assert.assertNull((Object)testObject.injectedContext);
        Assert.assertNull((Object)testObject.aConstructorString);
        Assert.assertNull((Object)testObject.bConstructorString);
        Assert.assertNull((Object)testObject.aString);
        Assert.assertNull((Object)testObject.bString);
        Assert.assertNull((Object)testObject.cString);
        Assert.assertEquals((long)0L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        ContextInjectionFactory.inject((Object)testObject, (IEclipseContext)trackedContext, (IEclipseContext)staticContext);
        Assert.assertEquals((Object)trackedContext, (Object)testObject.injectedContext);
        Assert.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assert.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        staticContext.set("b", (Object)"_123_");
        staticContext.set("bConstructor", (Object)"_123Constructor_");
        staticContext.set("c", (Object)"_xyz_");
        Assert.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assert.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        staticContext.dispose();
        Assert.assertEquals((Object)"abcConstructor", (Object)testObject.aConstructorString);
        Assert.assertEquals((Object)"123Constructor", (Object)testObject.bConstructorString);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)"xyz", (Object)testObject.cString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)0L, (long)testObject.preDestroyCalled);
        trackedContext.set("a", (Object)"_abc_");
        trackedContext.set("b", (Object)"_bbc_");
        Assert.assertEquals((Object)"_abc_", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        ContextInjectionFactory.uninject((Object)testObject, (IEclipseContext)trackedContext);
        Assert.assertNull((Object)testObject.injectedContext);
        Assert.assertNull((Object)testObject.aString);
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)1L, (long)testObject.preDestroyCalled);
        trackedContext.set("a", (Object)"+abc+");
        Assert.assertNull((Object)testObject.aString);
        trackedContext.dispose();
        Assert.assertEquals((long)1L, (long)testObject.postConstructCalled);
        Assert.assertEquals((long)1L, (long)testObject.preDestroyCalled);
    }

    @Test
    public void testStaticInvoke() {
        IEclipseContext trackedContext = EclipseContextFactory.create((String)"main");
        trackedContext.set("a", (Object)"abc");
        IEclipseContext staticContext = EclipseContextFactory.create((String)"static");
        staticContext.set("b", (Object)"123");
        TestInvokeClass testObject = new TestInvokeClass();
        Assert.assertNull((Object)testObject.aString);
        Assert.assertNull((Object)testObject.bString);
        Object result = ContextInjectionFactory.invoke((Object)testObject, Execute.class, (IEclipseContext)trackedContext, (IEclipseContext)staticContext, null);
        Assert.assertEquals((Object)"abc123", (Object)result);
        Assert.assertEquals((Object)"abc", (Object)testObject.aString);
        Assert.assertEquals((Object)"123", (Object)testObject.bString);
        Assert.assertEquals((Object)trackedContext, (Object)testObject.context);
    }

    static class TestClass {
        public IEclipseContext injectedContext;
        public String aString;
        public String bString;
        public String cString;
        public String aConstructorString;
        public String bConstructorString;
        public int postConstructCalled = 0;
        public int preDestroyCalled = 0;

        TestClass() {
        }

        @Inject
        public void contextSet(@Optional IEclipseContext context) {
            this.injectedContext = context;
        }

        @Inject
        public void setA(@Optional @Named(value="a") String aString) {
            this.aString = aString;
        }

        @Inject
        public void setB(@Named(value="b") String bString) {
            this.bString = bString;
        }

        @Inject
        public void setC(@Named(value="c") String cString) {
            this.cString = cString;
        }

        @Inject
        public void InjectedMethod(@Named(value="aConstructor") String aString, @Named(value="bConstructor") String bString) {
            this.aConstructorString = aString;
            this.bConstructorString = bString;
        }

        @PostConstruct
        public void init() {
            ++this.postConstructCalled;
        }

        @PreDestroy
        public void dispose() {
            ++this.preDestroyCalled;
        }
    }

    static class TestInvokeClass {
        public String aString;
        public String bString;
        public IEclipseContext context;

        TestInvokeClass() {
        }

        @Execute
        public String testMethod(@Named(value="a") String aString, @Named(value="b") String bString, IEclipseContext context) {
            this.aString = aString;
            this.bString = bString;
            this.context = context;
            return String.valueOf(aString) + bString;
        }
    }
}

