/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectorFactory;
import org.eclipse.e4.core.di.annotations.Execute;
import org.junit.Assert;
import org.junit.Test;

public class ProviderInjectionTest {
    @Test
    public synchronized void testInvokeWithProvider() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class.getName(), (Object)"abc");
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(TestData.class);
        TestInvokeClass userObject = new TestInvokeClass();
        Assert.assertEquals((Object)1, (Object)ContextInjectionFactory.invoke((Object)userObject, Execute.class, (IEclipseContext)context, null));
        Assert.assertNotNull((Object)userObject.provider.get());
        Assert.assertEquals((Object)"abc", (Object)((TestData)userObject.provider.get()).data);
    }

    @Test
    public synchronized void testConstructorWithProvider() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class.getName(), (Object)"abc");
        IInjector injector = InjectorFactory.getDefault();
        injector.addBinding(TestData.class);
        TestConstructorClass userObject = (TestConstructorClass)ContextInjectionFactory.make(TestConstructorClass.class, (IEclipseContext)context);
        Assert.assertNotNull((Object)userObject);
        Assert.assertNotNull(userObject.provider);
        Assert.assertNotNull((Object)userObject.provider.get());
        Assert.assertEquals((Object)"abc", (Object)((TestData)userObject.provider.get()).data);
    }

    public static class TestConstructorClass {
        public Provider<TestData> provider;

        @Inject
        public TestConstructorClass(Provider<TestData> provider) {
            this.provider = provider;
        }
    }

    public static class TestData {
        public String data;

        @Inject
        public TestData(String tmp) {
            this.data = tmp;
        }
    }

    public static class TestInvokeClass {
        public Provider<TestData> provider;

        @Execute
        public int execute(Provider<TestData> arg) {
            this.provider = arg;
            return 1;
        }
    }
}

