/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.inject;

import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.junit.Assert;
import org.junit.Test;

public class TestConstructorInjection {
    @Test
    public void testConstructorInjection() throws InvocationTargetException, InstantiationException {
        IEclipseContext context = EclipseContextFactory.create();
        Integer intValue = 123;
        context.set(Integer.class.getName(), (Object)intValue);
        Boolean boolValue = Boolean.TRUE;
        context.set(Boolean.class.getName(), (Object)boolValue);
        Double doubleValue = 1.23;
        context.set(Double.class.getName(), (Object)doubleValue);
        Float floatValue = Float.valueOf(12.3f);
        context.set(Float.class.getName(), (Object)floatValue);
        Character charValue = Character.valueOf('v');
        context.set(Character.class.getName(), (Object)charValue);
        Object result = ContextInjectionFactory.make(TestConstructorObject.class, (IEclipseContext)context);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof TestConstructorObject));
        TestConstructorObject testObject = (TestConstructorObject)result;
        Assert.assertFalse((boolean)testObject.defaultConstructorCalled);
        Assert.assertFalse((boolean)testObject.constructorIntStrCalled);
        Assert.assertTrue((boolean)testObject.constructorIntBoolCalled);
        Assert.assertTrue((boolean)testObject.injectedMethodCalled);
        Assert.assertFalse((boolean)testObject.nonInjectedMethodCalled);
        Assert.assertTrue((boolean)testObject.orderCorrect);
        Assert.assertEquals((Object)intValue, (Object)testObject.i);
        Assert.assertEquals((Object)boolValue, (Object)testObject.b);
        Assert.assertEquals((Object)doubleValue, (Object)testObject.d);
        Assert.assertEquals((Object)floatValue, (Object)testObject.f);
        Assert.assertEquals((Object)charValue, (Object)testObject.getChar());
        Assert.assertNull((Object)testObject.s);
    }

    static class TestConstructorObject {
        public boolean defaultConstructorCalled = false;
        public boolean constructorIntStrCalled = false;
        public boolean constructorIntBoolCalled = false;
        public boolean injectedMethodCalled = false;
        public boolean nonInjectedMethodCalled = false;
        @Inject
        private Character c;
        public Integer i;
        public String s;
        public Boolean b;
        public Double d;
        public Float f;
        public boolean orderCorrect = true;

        public TestConstructorObject() {
            this.defaultConstructorCalled = true;
        }

        public TestConstructorObject(Integer i, String s) {
            this.constructorIntStrCalled = true;
            this.i = i;
            this.s = s;
        }

        @Inject
        public TestConstructorObject(Integer i, Boolean b) {
            this.constructorIntBoolCalled = true;
            this.i = i;
            this.b = b;
            if (this.c != null || this.d != null || this.f != null) {
                this.orderCorrect = false;
            }
        }

        @Inject
        public void injectedMethod(Double d, Float f) {
            this.injectedMethodCalled = true;
            this.d = d;
            this.f = f;
            if (this.c == null || this.i == null || this.b == null) {
                this.orderCorrect = false;
            }
        }

        public void nonInjectedMethod(Double d) {
            this.nonInjectedMethodCalled = true;
            this.d = d;
        }

        public Character getChar() {
            return this.c;
        }
    }
}

