/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.contexts.performance;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.core.internal.tests.CoreTestsActivator;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleContext;

public class ContextPerformanceTest
extends TestCase {
    IEclipseContext parentContext;
    IEclipseContext context;

    public static Test suite() {
        return new TestSuite(ContextPerformanceTest.class);
    }

    public ContextPerformanceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.parentContext = EclipseContextFactory.getServiceContext((BundleContext)CoreTestsActivator.getDefault().getBundleContext());
        this.context = this.parentContext.createChild(this.getName());
        int i = 0;
        while (i < 100) {
            this.context.set("Value-" + i, (Object)i);
            ++i;
        }
        i = 0;
        while (i < 1000) {
            this.context.get("NonExistentValue-" + i);
            ++i;
        }
        this.context.get(DebugOptions.class.getName());
        this.context.get(IAdapterManager.class.getName());
        this.context.get(IExtensionRegistry.class.getName());
        this.context.get(IPreferencesService.class.getName());
        this.context.get(Location.class.getName());
    }

    public void testLookup() {
        new PerformanceTestRunner(){

            protected void test() {
                ContextPerformanceTest.this.context.get("something");
            }
        }.run((TestCase)this, 10, 600000);
    }

    public void testLookupContextFunction() {
        this.context.set("somefunction", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return "result";
            }
        });
        new PerformanceTestRunner(){

            protected void test() {
                ContextPerformanceTest.this.context.get("somefunction");
            }
        }.run((TestCase)this, 10, 5000000);
    }

    public void testSetContextFunction() {
        this.context.set("somefunction", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                return context.get("something");
            }
        });
        new PerformanceTestRunner(){
            int i = 0;

            protected void test() {
                ContextPerformanceTest.this.context.set("something", (Object)("value-" + this.i++));
            }
        }.run((TestCase)this, 10, 600000);
    }

    public void testSetValueRunAndTrack() {
        this.context.set("somefunction", (Object)new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                int i = 0;
                while (i < 1000) {
                    context.get("NonExistentValue-" + i);
                    ++i;
                }
                return context.get("something");
            }
        });
        this.context.runAndTrack(new RunAndTrack(){

            public boolean changed(IEclipseContext context) {
                context.get("somefunction");
                return true;
            }
        });
        new PerformanceTestRunner(){
            int i = 0;

            protected void test() {
                ContextPerformanceTest.this.context.set("something", (Object)("value-" + this.i++));
            }
        }.run((TestCase)this, 10, 400);
    }
}

