/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AutoConstructWithCreatableTest {
    private IEclipseContext context;

    @Before
    public void createContext() {
        this.context = EclipseContextFactory.create();
    }

    @Test
    public void testCreatableIsCreated() {
        Consumer1 consumer1 = (Consumer1)ContextInjectionFactory.make(Consumer1.class, (IEclipseContext)this.context);
        Assert.assertNotNull((Object)consumer1);
        boolean exception = false;
        try {
            ContextInjectionFactory.make(Consumer2.class, (IEclipseContext)this.context);
        }
        catch (InjectionException injectionException) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        this.context.set(Dependent2.class, (Object)new Dependent2());
        Consumer2 consumer2 = (Consumer2)ContextInjectionFactory.make(Consumer2.class, (IEclipseContext)this.context);
        Assert.assertNotNull((Object)consumer2);
    }

    @Test(expected=InjectionException.class)
    public void testNonCreatableInstanceAreNotCreated() {
        ContextInjectionFactory.make(Consumer2.class, (IEclipseContext)this.context);
        Assert.assertTrue((boolean)false);
    }

    @Test
    public void testNonCreatableInstancesAreUsedFromContext() {
        this.context.set(Dependent2.class, (Object)new Dependent2());
        Consumer2 consumer2 = (Consumer2)ContextInjectionFactory.make(Consumer2.class, (IEclipseContext)this.context);
        Assert.assertNotNull((Object)consumer2);
    }

    static class Consumer1 {
        @Inject
        public Consumer1(Dependent1 dep) {
        }
    }

    static class Consumer2 {
        @Inject
        public Consumer2(Dependent2 dep) {
        }
    }

    @Creatable
    static class Dependent1 {
        @Inject
        public Dependent1() {
        }
    }

    static class Dependent2 {
        @Inject
        public Dependent2() {
        }
    }
}

