/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.junit.Assert;
import org.junit.Test;

public class InjectBaseTypeTest {
    @Test
    public void testPrimitiveTypes() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set("test_int", (Object)12);
        context.set("test_long", (Object)124564523466L);
        context.set("test_float", (Object)Float.valueOf(12.34f));
        context.set("test_double", (Object)12.345345345634634);
        context.set("test_short", (Object)10);
        context.set("test_byte", (Object)55);
        context.set("test_boolean", (Object)true);
        context.set("test_char", (Object)Character.valueOf('a'));
        TestClass testClass = (TestClass)ContextInjectionFactory.make(TestClass.class, (IEclipseContext)context);
        Assert.assertEquals((long)12L, (long)testClass.intField);
        Assert.assertEquals((long)0L, (long)testClass.intFieldOptional);
        Assert.assertEquals((long)124564523466L, (long)testClass.longField);
        Assert.assertEquals((float)12.34f, (float)testClass.floatField, (float)0.0f);
        Assert.assertEquals((double)12.345345345634634, (double)testClass.doubleField, (double)0.0);
        Assert.assertEquals((long)10L, (long)testClass.shortField);
        Assert.assertEquals((long)55L, (long)testClass.byteField);
        Assert.assertEquals((Object)true, (Object)testClass.booleanField);
        Assert.assertEquals((long)97L, (long)testClass.charField);
        Assert.assertEquals((long)12L, (long)testClass.intArg);
        Assert.assertEquals((long)97L, (long)testClass.charArg);
        Assert.assertEquals((Object)true, (Object)testClass.booleanArg);
        ContextInjectionFactory.uninject((Object)testClass, (IEclipseContext)context);
        Assert.assertEquals((long)12L, (long)testClass.intField);
        Assert.assertEquals((long)0L, (long)testClass.intFieldOptional);
        Assert.assertEquals((long)124564523466L, (long)testClass.longField);
        Assert.assertEquals((float)12.34f, (float)testClass.floatField, (float)0.0f);
        Assert.assertEquals((double)12.345345345634634, (double)testClass.doubleField, (double)0.0);
        Assert.assertEquals((long)10L, (long)testClass.shortField);
        Assert.assertEquals((long)55L, (long)testClass.byteField);
        Assert.assertEquals((Object)false, (Object)testClass.booleanField);
        Assert.assertEquals((long)97L, (long)testClass.charField);
        Assert.assertEquals((long)12L, (long)testClass.intArg);
        Assert.assertEquals((long)97L, (long)testClass.charArg);
        Assert.assertEquals((Object)true, (Object)testClass.booleanArg);
    }

    static class TestClass {
        @Inject
        @Named(value="test_int")
        public int intField;
        @Inject
        @Named(value="test_int_optional")
        @Optional
        public int intFieldOptional;
        @Inject
        @Named(value="test_long")
        public long longField;
        @Inject
        @Named(value="test_float")
        public float floatField;
        @Inject
        @Named(value="test_double")
        public double doubleField;
        @Inject
        @Named(value="test_short")
        public short shortField;
        @Inject
        @Named(value="test_byte")
        public byte byteField;
        @Inject
        @Optional
        @Named(value="test_boolean")
        public boolean booleanField;
        @Inject
        @Named(value="test_char")
        public char charField;
        public int intArg;
        public char charArg;
        public boolean booleanArg;

        TestClass() {
        }

        @Inject
        public void set(@Named(value="test_int") int intArg, @Named(value="test_char") char charArg, @Named(value="test_boolean") boolean booleanArg) {
            this.intArg = intArg;
            this.charArg = charArg;
            this.booleanArg = booleanArg;
        }
    }
}

