/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.tests.di;

import javax.inject.Inject;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.annotations.Execute;
import org.junit.Test;

public class InjectBridgeTest {
    @Test
    public void testInjection() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class, (Object)"Value");
        ContextInjectionFactory.make(Concrete.class, (IEclipseContext)context);
    }

    @Test(expected=InjectionException.class)
    public void testInjectionFail() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Object.class, (Object)"Value");
        ContextInjectionFactory.make(Concrete.class, (IEclipseContext)context);
    }

    @Test
    public void testInvokation() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(String.class, (Object)"Value");
        ContextInjectionFactory.invoke((Object)new Concrete(), Execute.class, (IEclipseContext)context);
    }

    @Test(expected=InjectionException.class)
    public void testInvokationFail() {
        IEclipseContext context = EclipseContextFactory.create();
        context.set(Object.class, (Object)"Value");
        ContextInjectionFactory.invoke((Object)new Concrete(), Execute.class, (IEclipseContext)context);
    }

    static class Base<T> {
        Base() {
        }

        public void testInject(T value) {
        }

        public void testInvoke(T value) {
        }
    }

    static class Concrete
    extends Base<String> {
        Concrete() {
        }

        @Override
        @Inject
        public void testInject(String value) {
        }

        @Override
        @Execute
        public void testInvoke(String value) {
        }
    }
}

